/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.pdf;

import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.Locale;

public class PdfUtils {
    public static final float UNIT_SIZE_INCHES = 0.013888889f;
    public static final float A4_HEIGHT_INCHES = 11.692f;
    public static final float A4_WIDTH_INCHES = 8.27f;
    public static final float A4_HEIGHT_UNITS = 841.82404f;
    public static final float A4_WIDTH_UNITS = 595.44f;
    public static final float US_LETTER_HEIGHT_INCHES = 10.98f;
    public static final float US_LETTER_WIDTH_INCHES = 8.5f;
    public static final float US_LETTER_HEIGHT_UNITS = 790.55994f;
    public static final float US_LETTER_WIDTH_UNITS = 612.0f;

    public static RectF defaultPhysicalBounds() {
        return new RectF(0.0f, 0.0f, 11.692f, 11.692f);
    }

    public static RectF a4PhysicalBounds(RectF bounds) {
        boolean bl;
        boolean bl2 = bl = bounds.width() <= bounds.height();
        if (bl) {
            return new RectF(0.0f, 0.0f, 8.27f, 11.692f);
        }
        return new RectF(0.0f, 0.0f, 11.692f, 8.27f);
    }

    public static RectF usLetterPhysicalBounds(RectF bounds) {
        boolean bl;
        boolean bl2 = bl = bounds.width() <= bounds.height();
        if (bl) {
            return new RectF(0.0f, 0.0f, 8.5f, 10.98f);
        }
        return new RectF(0.0f, 0.0f, 10.98f, 8.5f);
    }

    public static RectF fitToPhysicalBounds(RectF bounds, RectF physicalBounds) {
        float f2 = Math.min(physicalBounds.width() / (bounds.width() * 0.013888889f), physicalBounds.height() / (bounds.height() * 0.013888889f));
        return new RectF(0.0f, 0.0f, bounds.width() * f2, bounds.height() * f2);
    }

    @NonNull
    public static RectF calculatePageBounds(PDFPageSize pageSize, Rect bounds, int rotation) {
        int n2;
        int n3;
        Locale locale = Locale.getDefault();
        if (rotation == 90 || rotation == 270) {
            n3 = bounds.height();
            n2 = bounds.width();
        } else {
            n3 = bounds.width();
            n2 = bounds.height();
        }
        RectF rectF = new RectF(0.0f, 0.0f, (float)n3, (float)n2);
        switch (pageSize) {
            case A4: {
                return PdfUtils.calculateA4PageBounds(rectF);
            }
            case FIXED_A4: {
                return PdfUtils.calculateFixedA4PageBounds(n3, n2);
            }
            case US_LETTER: {
                return PdfUtils.calculateUSLetterPageBounds(rectF);
            }
            case FIXED_US_LETTER: {
                return PdfUtils.calculateFixedUSLetterPageBounds(n3, n2);
            }
            case AUTO_LOCALE: {
                if (locale == Locale.US) {
                    return PdfUtils.calculateUSLetterPageBounds(rectF);
                }
                return PdfUtils.calculateA4PageBounds(rectF);
            }
            case AUTO: {
                float f2;
                float f3 = (float)n3 / (float)n2;
                float f4 = n3 <= n2 ? 0.7073212f : 1.4137849f;
                float f5 = f2 = n3 <= n2 ? 0.7741349f : 1.2917646f;
                if (Math.abs(f3 - f4) <= Math.abs(f3 - f2)) {
                    return PdfUtils.calculateA4PageBounds(rectF);
                }
                return PdfUtils.calculateUSLetterPageBounds(rectF);
            }
            case FROM_IMAGE: {
                return new RectF(0.0f, 0.0f, (float)n3, (float)n2);
            }
        }
        return rectF;
    }

    @NonNull
    private static RectF calculateFixedUSLetterPageBounds(int width, int height) {
        float f2 = width <= height ? 612.0f : 790.55994f;
        float f3 = width <= height ? 790.55994f : 612.0f;
        return new RectF(0.0f, 0.0f, f2, f3);
    }

    @NonNull
    private static RectF calculateFixedA4PageBounds(int width, int height) {
        float f2 = width <= height ? 595.44f : 841.82404f;
        float f3 = width <= height ? 841.82404f : 595.44f;
        return new RectF(0.0f, 0.0f, f2, f3);
    }

    @NonNull
    private static RectF calculateUSLetterPageBounds(RectF rotatedRect) {
        return PdfUtils.fitToPhysicalBounds(rotatedRect, PdfUtils.usLetterPhysicalBounds(rotatedRect));
    }

    @NonNull
    private static RectF calculateA4PageBounds(RectF rotatedRect) {
        return PdfUtils.fitToPhysicalBounds(rotatedRect, PdfUtils.a4PhysicalBounds(rotatedRect));
    }
}

