/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PageFactory {
    private static final ExecutorService a = Executors.newSingleThreadExecutor();
    private final BitmapLruCache b;
    private final PageStoreStrategy c;
    private final Logger d = LoggerProvider.getLogger();

    @Inject
    public PageFactory(BitmapLruCache bitmapLruCache, PageStoreStrategy pageStoreStrategy) {
        this.b = bitmapLruCache;
        this.c = pageStoreStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result buildPage(Bitmap image, int screenWidth, int screenHeight) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        try {
            Result result = this.buildPage(byteArrayOutputStream.toByteArray(), screenWidth, screenHeight);
            return result;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public Result buildPage(byte[] image, int screenWidth, int screenHeight) throws IOException {
        Page page = new Page();
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        File file2 = FileUtils.getFile((File)file, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)file2);
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.ORIGINAL.getFileName()), (byte[])image);
        final Bitmap bitmap = BitmapUtils.createPreview(image, screenWidth, screenHeight);
        page.setImageSize(Page.ImageType.OPTIMIZED_PREVIEW, bitmap.getWidth(), bitmap.getHeight());
        final String string2 = this.c.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
        this.b.put(string2, bitmap);
        a.execute(new Runnable(){

            @Override
            public void run() {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string2);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    try {
                        PageFactory.this.d.logException(iOException);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        });
        return new Result(page, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Page buildPage(Bitmap image) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        try {
            Page page = this.buildPage(byteArrayOutputStream.toByteArray());
            return page;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public Page buildPage(byte[] image) throws IOException {
        Page page = new Page();
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.OPTIMIZED.getFileName()), (byte[])image);
        return page;
    }

    public Result buildPage(String pageId, byte[] image, int screenWidth, int screenHeight) throws IOException {
        Page page = new Page(pageId);
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        File file2 = FileUtils.getFile((File)file, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)file2);
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.ORIGINAL.getFileName()), (byte[])image);
        final Bitmap bitmap = BitmapUtils.createPreview(image, screenWidth, screenHeight);
        page.setImageSize(Page.ImageType.OPTIMIZED_PREVIEW, bitmap.getWidth(), bitmap.getHeight());
        final String string2 = this.c.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
        this.b.put(string2, bitmap);
        a.execute(new Runnable(){

            @Override
            public void run() {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string2);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    try {
                        PageFactory.this.d.logException(iOException);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
        });
        return new Result(page, bitmap);
    }

    public final Page buildPage(File image) throws IOException {
        Page page = new Page();
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.OPTIMIZED.getFileName()), (byte[])FileUtils.readFileToByteArray((File)image));
        return page;
    }

    public final Page buildPage(String pageId, File image) throws IOException {
        Page page = new Page(pageId);
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.OPTIMIZED.getFileName()), (byte[])FileUtils.readFileToByteArray((File)image));
        return page;
    }

    public static class Result {
        public final Page page;
        public final Bitmap preview;

        public Result(Page page, Bitmap preview) {
            this.page = page;
            this.preview = preview;
        }
    }
}

