/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera.sensor;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import net.doo.snap.camera.sensor.SignificantMoveListener;

public class SignificantMoveCatcher
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor accelerometer;
    private float[] gravity;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private SignificantMoveListener moveListener = null;

    public SignificantMoveCatcher(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        this.acceleration = 0.0f;
        this.currentAcceleration = 9.80665f;
        this.lastAcceleration = 9.80665f;
    }

    private void registerSensorListener() {
        Sensor sensor = this.accelerometer;
        if (sensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this, sensor, 2);
        }
    }

    private void unregisterSensorListener() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public void registerSignificantMoveListener(SignificantMoveListener significantMoveListener) {
        if (significantMoveListener != null && this.moveListener != significantMoveListener) {
            this.moveListener = significantMoveListener;
            this.registerSensorListener();
        }
    }

    public void unregisterSignificantMoveListener(SignificantMoveListener significantMoveListener) {
        this.moveListener = null;
        this.unregisterSensorListener();
    }

    public void onSensorChanged(SensorEvent object) {
        if (object.sensor.getType() == 1) {
            SignificantMoveCatcher significantMoveCatcher = this;
            significantMoveCatcher.gravity = (float[])object.values.clone();
            object = significantMoveCatcher.gravity;
            float f2 = significantMoveCatcher.gravity[0];
            Object object2 = object;
            Object object3 = object2[1];
            SensorEvent sensorEvent = object2[2];
            this.lastAcceleration = this.currentAcceleration;
            SensorEvent sensorEvent2 = object3;
            SensorEvent sensorEvent3 = sensorEvent;
            significantMoveCatcher.currentAcceleration = (float)Math.sqrt(f2 * f2 + sensorEvent2 * sensorEvent2 + sensorEvent3 * sensorEvent3);
            object3 = significantMoveCatcher.currentAcceleration - this.lastAcceleration;
            significantMoveCatcher.acceleration = significantMoveCatcher.acceleration * 0.9f + object3;
            SignificantMoveListener significantMoveListener = significantMoveCatcher.moveListener;
            if (significantMoveListener != null && this.acceleration > significantMoveListener.getSignificantMoveThreshold()) {
                this.moveListener.onSignificantMove();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }
}

