/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.hardware.Camera;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class Utils {
    private static final int A4_AREA = 8699840;
    private static final double ASPECT_TOLERANCE = 0.1;

    public static boolean isFlashSupported(Camera.Parameters object) {
        if (object == null) {
            return false;
        }
        return !((object = object.getSupportedFlashModes()) == null || object.isEmpty() || object.size() == 1 && ((String)object.get(0)).equals("off"));
        {
        }
    }

    public static Camera.Size getBestA4PictureSize(Camera.Parameters object) {
        Object object22;
        TreeMap treeMap;
        Camera.Parameters parameters = object;
        object = treeMap;
        treeMap = new TreeMap();
        for (Object object22 : parameters.getSupportedPictureSizes()) {
            ((TreeMap)object).put(((Camera.Size)object22).width * ((Camera.Size)object22).height, object22);
        }
        Camera.Size size = null;
        object22 = ((TreeMap)object).ceilingEntry(8699840);
        if (object22 == null) {
            object22 = ((TreeMap)object).floorEntry(8699840);
        }
        if (object22 != null) {
            size = (Camera.Size)object22.getValue();
        }
        return size;
    }

    public static Camera.Size getLargestPictureSize(Camera.Parameters parameters) {
        Camera.Parameters parameters2 = parameters;
        parameters = null;
        for (Camera.Size size : parameters2.getSupportedPictureSizes()) {
            int n2;
            if (parameters != null && size.width * size.height <= (n2 = parameters.width * parameters.height)) {
                size = parameters;
            }
            parameters = size;
        }
        return parameters;
    }

    public static Camera.Size getLargestSizeWithAspectRatioMatch(List<Camera.Size> object, double d2) {
        ArrayList<Camera.Size> arrayList;
        a a2;
        List<Camera.Size> list = object;
        object = a2;
        a2 = new a(null);
        ArrayList<Camera.Size> arrayList2 = arrayList;
        arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size : list) {
            Camera.Size size2;
            if (!(Math.abs(d2 - (double)size2.width / (double)size.height) < 0.1)) continue;
            arrayList2.add(size);
        }
        return (Camera.Size)Collections.max(arrayList2, object);
    }

    public static Camera.Size findByWidthAndHeight(Camera.Parameters object, int n2, int n3) {
        for (Camera.Size size : object.getSupportedPictureSizes()) {
            if (size.width != n2 || size.height != n3) continue;
            return size;
        }
        return null;
    }

    public static Camera.Size getBestAspectPictureSize(int n2, int n3, int n4, Camera.Parameters parameters, double d2) {
        Camera.Size size3;
        block5: {
            double d3 = n3;
            double d4 = n4;
            double d5 = d3 / d4;
            Camera.Size size2 = null;
            double d6 = Double.MAX_VALUE;
            if (n2 == 90 || n2 == 270) {
                d5 = d4 / d3;
            }
            List list = parameters.getSupportedPictureSizes();
            Collections.sort(list, Collections.reverseOrder(new a(null)));
            for (Camera.Size size3 : list) {
                double d7;
                double d8 = (double)size3.width / (double)size3.height - d5;
                if (Math.abs(d7) < d6) {
                    d6 = Math.abs(d8);
                } else {
                    size3 = size2;
                }
                if (!(d6 < d2)) {
                    size2 = size3;
                    continue;
                }
                break block5;
            }
            size3 = size2;
        }
        return size3;
    }

    public static void enableContinuousFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            List<String> list = Utils.extractFocusModes(parameters);
            if (list.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (list.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else if (list.contains("auto")) {
                parameters.setFocusMode("auto");
            }
        }
    }

    public static void enableAutoFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Utils.extractFocusModes(parameters).contains("auto") && !parameters.getFocusMode().equals("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    private static List<String> extractFocusModes(Camera.Parameters object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if ((object = object.getSupportedFocusModes()) == null) {
            object = Collections.emptyList();
        }
        return object;
    }

    private static class a
    implements Comparator<Camera.Size> {
        private a() {
        }

        /* synthetic */ a(net.doo.snap.util.snap.a a2) {
            this();
        }

        public int a(Camera.Size size, Camera.Size size2) {
            return size.width * size.height - size2.width * size2.height;
        }
    }
}

