/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.a.a;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private static final int OK_DETECTIONS_COUNT_FOR_AUTOSNAP = 3;
    private static final double OK_DETECTIONS_THRESHOLD = 0.05;
    protected final ScanbotCameraView cameraView;
    protected final SignificantMoveCatcher significantMoveCatcher;
    protected final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove;
    protected final AtomicLong captureInterval;
    protected final Logger logger;
    protected long lastCapture;
    protected AtomicBoolean capturing;
    protected boolean ignoreBadAspectRatio;
    protected final Handler mainThreadHandler;
    private boolean isAutoSnapEnabled;
    private AtomicBoolean isAutosnappingShooting;
    private AutoSnappingCallback autoSnappingCallback;
    private final Runnable autosnappingShoot;
    private List<PointF> lastDetectedPolygon;
    private AtomicInteger okDetectionCounter;

    public static AutoSnappingController attach(ScanbotCameraView scanbotCameraView) {
        return AutoSnappingController.attach(scanbotCameraView, new ContourDetectorFrameHandler(scanbotCameraView.getContext()));
    }

    public static AutoSnappingController attach(ScanbotCameraView scanbotCameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(scanbotCameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView scanbotCameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this(scanbotCameraView, (PreviewBuffer.FrameHandler)contourDetectorFrameHandler);
        contourDetectorFrameHandler.addResultHandler(new c(null));
    }

    protected AutoSnappingController(ScanbotCameraView scanbotCameraView, PreviewBuffer.FrameHandler frameHandler) {
        ScanbotCameraView scanbotCameraView2 = scanbotCameraView;
        AutoSnappingController autoSnappingController = this;
        this.lastSignificantMove = 0L;
        this.captureInterval = new AtomicLong(1000L);
        this.logger = LoggerProvider.getLogger();
        this.lastCapture = 0L;
        this.capturing = new AtomicBoolean(false);
        this.ignoreBadAspectRatio = false;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.isAutoSnapEnabled = true;
        this.isAutosnappingShooting = new AtomicBoolean(false);
        this.autoSnappingCallback = AutoSnappingCallback.NULL;
        this.autosnappingShoot = new net.doo.snap.camera.a(this);
        this.okDetectionCounter = new AtomicInteger(0);
        autoSnappingController.cameraView = scanbotCameraView;
        autoSnappingController.significantMoveCatcher = new SignificantMoveCatcher(scanbotCameraView.getContext().getApplicationContext());
        autoSnappingController.significantMoveListener = new SignificantMoveListenerImpl();
        scanbotCameraView2.getPreviewBuffer().addFrameHandler(frameHandler);
        scanbotCameraView2.addPictureCallback(new d(null));
        scanbotCameraView2.addCameraStateCallback(new a(null));
        scanbotCameraView2.addTakePictureCallback(new b(null));
    }

    private void checkDetectedPolygonAndSnap(List<PointF> list) {
        if (list != null && !list.isEmpty() && this.okDetectionCounter.get() < 3) {
            List<PointF> list2 = this.lastDetectedPolygon;
            if (list2 == null) {
                this.lastDetectedPolygon = list;
            } else if (this.polygonsAreClose(list2, list)) {
                this.okDetectionCounter.incrementAndGet();
            } else {
                this.okDetectionCounter.set(0);
                this.lastDetectedPolygon = list;
            }
        } else {
            AutoSnappingController autoSnappingController = this;
            autoSnappingController.isAutosnappingShooting.set(true);
            autoSnappingController.mainThreadHandler.post(this.autosnappingShoot);
            autoSnappingController.okDetectionCounter.set(0);
            autoSnappingController.lastDetectedPolygon = null;
        }
    }

    private boolean polygonsAreClose(List<PointF> list, List<PointF> list2) {
        return (double)Math.abs(list.get((int)0).x - list2.get((int)0).x) < 0.05 && (double)Math.abs(list.get((int)0).y - list2.get((int)0).y) < 0.05 && (double)Math.abs(list.get((int)2).x - list2.get((int)2).x) < 0.05 && (double)Math.abs(list.get((int)2).y - list2.get((int)2).y) < 0.05;
    }

    private float clamp(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        return f2;
    }

    static /* synthetic */ long access$000(AutoSnappingController autoSnappingController) {
        return autoSnappingController.lastSignificantMove;
    }

    static /* synthetic */ boolean access$100(AutoSnappingController autoSnappingController) {
        return autoSnappingController.isAutoSnapEnabled;
    }

    static /* synthetic */ AutoSnappingCallback access$200(AutoSnappingController autoSnappingController) {
        return autoSnappingController.autoSnappingCallback;
    }

    static /* synthetic */ long access$002(AutoSnappingController autoSnappingController, long l2) {
        autoSnappingController.lastSignificantMove = l2;
        return l2;
    }

    protected void onDetectionOK(List<PointF> list) {
        if (!this.isAutosnappingShooting.get()) {
            this.checkDetectedPolygonAndSnap(list);
        }
    }

    public void setEnabled(boolean bl) {
        this.isAutoSnapEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float f2) {
        AutoSnappingController autoSnappingController = this;
        this.logger.logMethod();
        float f3 = 1.0f - autoSnappingController.clamp(f2);
        autoSnappingController.captureInterval.set((long)(f3 * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean bl) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = bl;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback autoSnappingCallback) {
        this.logger.logMethod();
        if (autoSnappingCallback == null) {
            autoSnappingCallback = AutoSnappingCallback.NULL;
        }
        this.autoSnappingCallback = autoSnappingCallback;
    }

    private class b
    implements CameraTakePictureCallback {
        private b() {
        }

        /* synthetic */ b(net.doo.snap.camera.a a2) {
            this();
        }

        @Override
        public void onTakePictureRequested() {
        }

        @Override
        public void onTakePictureCancelled() {
            b b2 = this;
            b2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            b2.AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    protected class SignificantMoveListenerImpl
    implements SignificantMoveListener {
        protected SignificantMoveListenerImpl() {
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            SignificantMoveListenerImpl significantMoveListenerImpl = this;
            AutoSnappingController.access$002(significantMoveListenerImpl.AutoSnappingController.this, SystemClock.elapsedRealtime());
            if (significantMoveListenerImpl.AutoSnappingController.this.capturing.get() && AutoSnappingController.this.isAutosnappingShooting.get()) {
                SignificantMoveListenerImpl significantMoveListenerImpl2 = this;
                significantMoveListenerImpl2.AutoSnappingController.this.cameraView.continuousFocus();
                significantMoveListenerImpl2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
                significantMoveListenerImpl2.AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    }

    private class a
    implements CameraStateCallback {
        private a() {
        }

        /* synthetic */ a(net.doo.snap.camera.a a2) {
            this();
        }

        @Override
        public void onResume() {
            a a2 = autoSnappingController;
            a2.AutoSnappingController.this.capturing.set(true);
            AutoSnappingController autoSnappingController = a2.AutoSnappingController.this;
            autoSnappingController.significantMoveCatcher.registerSignificantMoveListener(autoSnappingController.significantMoveListener);
        }

        @Override
        public void onPause() {
            a a2 = autoSnappingController;
            AutoSnappingController autoSnappingController = a2.AutoSnappingController.this;
            autoSnappingController.significantMoveCatcher.unregisterSignificantMoveListener(autoSnappingController.significantMoveListener);
            a2.AutoSnappingController.this.isAutosnappingShooting.set(false);
            a2.AutoSnappingController.this.capturing.set(false);
            a2.AutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class d
    implements PictureCallback {
        private d() {
        }

        /* synthetic */ d(net.doo.snap.camera.a a2) {
            this();
        }

        @Override
        public void onPictureTaken(byte[] byArray, int n2) {
            d d2 = this;
            d2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            d2.AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class c
    implements ContourDetectorFrameHandler.ResultHandler {
        private c() {
        }

        private void a(List<PointF> list) {
            AutoSnappingController.this.mainThreadHandler.post((Runnable)new net.doo.snap.camera.c(this, list));
        }

        /* synthetic */ c(net.doo.snap.camera.a a2) {
            this();
        }

        @Override
        public boolean handleResult(io.scanbot.sdk.a.a<ContourDetectorFrameHandler.DetectedFrame, io.scanbot.sdk.a> object) {
            if (object instanceof a.b) {
                object = (ContourDetectorFrameHandler.DetectedFrame)((a.b)object).a();
                AutoSnappingController.this.logger.logMethod();
                Object object2 = ((ContourDetectorFrameHandler.DetectedFrame)object).detectionResult;
                if ((object2 == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && object2 == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get()) {
                    object2 = AutoSnappingController.this;
                    if (SystemClock.elapsedRealtime() - object2.lastCapture > object2.captureInterval.get()) {
                        if (AutoSnappingController.this.lastCapture != 0L) {
                            this.a(((ContourDetectorFrameHandler.DetectedFrame)object).polygon);
                        }
                        AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                    }
                }
            }
            return false;
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new net.doo.snap.camera.b();

        public boolean onAutoSnapping();
    }
}

