/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.chequescanner;

import android.content.Context;
import io.scanbot.chequescanner.model.Result;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.a;
import io.scanbot.sdk.a.a;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.chequescanner.ChequeScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ChequeScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private ChequeScanner chequeScanner;
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private boolean enabled;

    public static ChequeScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, ChequeScanner chequeScanner) {
        ChequeScannerFrameHandler chequeScannerFrameHandler;
        ChequeScannerFrameHandler chequeScannerFrameHandler2 = chequeScannerFrameHandler;
        chequeScannerFrameHandler2(scanbotCameraView.getContext(), chequeScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(chequeScannerFrameHandler2);
        return chequeScannerFrameHandler;
    }

    public ChequeScannerFrameHandler(Context context, ChequeScanner chequeScanner) {
        ChequeScannerFrameHandler chequeScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        chequeScannerFrameHandler.chequeScanner = chequeScanner;
        chequeScannerFrameHandler.sapManager = c.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean notifyHandlers(io.scanbot.sdk.a.a<Result, a> a2) {
        ChequeScannerFrameHandler chequeScannerFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = chequeScannerFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = chequeScannerFrameHandler.handlers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return bl;
                }
                bl |= iterator.next().handleResult(a2);
            }
        }
    }

    @Override
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame frame) {
        ChequeScannerFrameHandler chequeScannerFrameHandler = chequeScannerFrameHandler3;
        chequeScannerFrameHandler.logger.logMethod();
        if (!chequeScannerFrameHandler.enabled) {
            return false;
        }
        if (!chequeScannerFrameHandler3.sapManager.checkLicenseStatus(SdkFeature.Cheque).booleanValue()) {
            chequeScannerFrameHandler3.notifyHandlers(new a.a<a>(new a()));
            return false;
        }
        ChequeScannerFrameHandler chequeScannerFrameHandler2 = chequeScannerFrameHandler3;
        ChequeScannerFrameHandler chequeScannerFrameHandler3 = chequeScannerFrameHandler2.chequeScanner.recognizeCheque(frame.frame, frame.width, frame.height, frame.frameOrientation);
        return chequeScannerFrameHandler2.notifyHandlers(new a.b<ChequeScannerFrameHandler>(chequeScannerFrameHandler3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(io.scanbot.sdk.a.a<Result, a> var1);
    }
}

