/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.a;
import io.scanbot.sdk.a.a;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class MRZScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private MRZScanner mrzScanner;
    private final Set<ResultHandler> handlers;
    protected final SapManager sapManager;
    private final Logger logger;
    protected boolean enabled;

    public static MRZScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, MRZScanner mRZScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler;
        MRZScannerFrameHandler mRZScannerFrameHandler2 = mRZScannerFrameHandler;
        mRZScannerFrameHandler2(scanbotCameraView.getContext(), mRZScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(mRZScannerFrameHandler2);
        return mRZScannerFrameHandler;
    }

    public MRZScannerFrameHandler(Context context, MRZScanner mRZScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        mRZScannerFrameHandler.mrzScanner = mRZScanner;
        mRZScannerFrameHandler.sapManager = c.a();
    }

    @Override
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame frame) {
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        mRZScannerFrameHandler.logger.logMethod();
        if (!mRZScannerFrameHandler.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.MRZRecognition).booleanValue()) {
            this.notifyHandlers(new a.a<a>(new a()));
            return false;
        }
        Rect rect = frame.finderRect;
        frame = rect == null ? this.mrzScanner.recognizeMRZ(frame.frame, frame.width, frame.height, frame.frameOrientation) : this.mrzScanner.recognizeMRZWithFinderOverlay(frame.frame, frame.width, frame.height, frame.frameOrientation, rect, false);
        return this.notifyHandlers(new a.b<PreviewBuffer.FrameHandler.Frame>(frame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean notifyHandlers(io.scanbot.sdk.a.a<MRZRecognitionResult, a> a2) {
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = mRZScannerFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = mRZScannerFrameHandler.handlers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return bl;
                }
                bl |= iterator.next().handleResult(a2);
            }
        }
    }

    public static interface ResultHandler {
        public boolean handleResult(io.scanbot.sdk.a.a<MRZRecognitionResult, a> var1);
    }
}

