/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.sdk.a.a;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.R;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.ui.h;
import net.doo.snap.ui.i;
import net.doo.snap.ui.j;
import net.doo.snap.ui.k;
import net.doo.snap.util.snap.PolygonHelper;

public class PolygonView
extends View
implements ContourDetectorFrameHandler.ResultHandler {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    protected List<PointF> polygon;
    private float[] points;
    private float[] animationPoints;
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    private ValueAnimator polygonAnimator;
    private ObjectAnimator polygonAlphaAnimator;
    private a polygonEvaluator = new a(null);
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);

    public PolygonView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public PolygonView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context, attributeSet);
    }

    private void initView(Context context, AttributeSet attributeSet) {
        PolygonView polygonView = this;
        polygonView.strokePaint = new Paint();
        polygonView.strokePaint.setColor(-1);
        polygonView.strokePaint.setStyle(Paint.Style.STROKE);
        polygonView.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView.strokePaint.setAntiAlias(true);
        polygonView.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.fillPaint = new Paint();
        polygonView.fillPaint.setColor(-16711936);
        polygonView.fillPaint.setStyle(Paint.Style.FILL);
        polygonView.strokePaintOK = new Paint();
        polygonView.strokePaintOK.setColor(-1);
        polygonView.strokePaintOK.setStyle(Paint.Style.STROKE);
        polygonView.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView.strokePaintOK.setAntiAlias(true);
        polygonView.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        polygonView.fillPaintOK = new Paint();
        polygonView.fillPaintOK.setColor(-16711936);
        polygonView.fillPaintOK.setStyle(Paint.Style.FILL);
        polygonView.points = new float[16];
        polygonView.animationPoints = new float[polygonView.points.length];
        polygonView.polygonHelper = new PolygonHelper();
        polygonView.polygon = Collections.emptyList();
        polygonView.path = new Path();
        if (attributeSet != null) {
            this.loadAttributes(context, attributeSet);
        }
    }

    private void loadAttributes(Context context, AttributeSet attributeSet) {
        int n2;
        context = context.obtainStyledAttributes(attributeSet, R.styleable.PolygonView);
        try {
            n2 = R.styleable.PolygonView_polygonFillColor;
        }
        catch (Throwable throwable) {
            context.recycle();
            throw throwable;
        }
        int n3 = context.getColor(n2, 0);
        int n4 = n3 != 0 ? 1 : 0;
        Context context2 = context;
        PolygonView polygonView = this;
        Context context3 = context;
        this.useFill = n4;
        this.fillPaint.setColor(n3);
        int n5 = R.styleable.PolygonView_polygonStrokeColor;
        n4 = context3.getColor(n5, -1);
        polygonView.strokePaint.setColor(n4);
        n3 = context2.getColor(R.styleable.PolygonView_polygonFillColorOK, n3);
        boolean bl = n3 != 0;
        PolygonView polygonView2 = this;
        this.useFillOK = bl;
        this.fillPaintOK.setColor(n3);
        n3 = context.getColor(R.styleable.PolygonView_polygonStrokeColorOK, n4);
        this.strokePaintOK.setColor(n3);
        float f2 = context.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        polygonView2.strokePaint.setStrokeWidth(f2);
        polygonView2.strokePaintOK.setStrokeWidth(f2);
        context.recycle();
    }

    private void animateToPolygon(List<PointF> list) {
        ValueAnimator valueAnimator = this.polygonAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
            this.polygonAnimator = null;
        }
        if ((valueAnimator = this.polygonAlphaAnimator) != null) {
            valueAnimator.cancel();
            this.polygonAlphaAnimator = null;
        }
        if (list.isEmpty()) {
            this.animatePolygonFadeOut();
        } else {
            this.animateToNextPolygon();
        }
    }

    private void animateToNextPolygon() {
        PolygonView polygonView = this;
        polygonView.strokePaint.setAlpha(255);
        polygonView.polygonHelper.polygonToPoints(this.polygon, this.animationPoints);
        polygonView.polygonAnimator = ValueAnimator.ofObject((TypeEvaluator)polygonView.polygonEvaluator, (Object[])new Object[]{this.points, this.animationPoints});
        polygonView.polygonAnimator.addListener((Animator.AnimatorListener)new i(this));
        polygonView.polygonAnimator.start();
    }

    private void animatePolygonFadeOut() {
        PolygonView polygonView = this;
        polygonView.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)polygonView.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        polygonView.polygonAlphaAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new j(this));
        polygonView.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new k(this));
        polygonView.polygonAlphaAnimator.setDuration(250L);
        polygonView.polygonAlphaAnimator.start();
    }

    private void updatePath() {
        PolygonView polygonView = this;
        polygonView.path.rewind();
        float[] fArray = this.points;
        polygonView.path.moveTo(this.points[0], fArray[1]);
        int n2 = 2;
        while (true) {
            float[] fArray2 = this.points;
            if (n2 >= this.points.length) break;
            this.path.lineTo(fArray2[n2], fArray2[n2 + 1]);
            n2 += 2;
        }
    }

    public void setFillColor(int n2) {
        boolean bl = n2 != 0;
        PolygonView polygonView = this;
        polygonView.useFill = bl;
        polygonView.fillPaint.setColor(n2);
        polygonView.invalidate();
    }

    public void setFillColorOK(int n2) {
        boolean bl = n2 != 0;
        PolygonView polygonView = this;
        polygonView.useFillOK = bl;
        polygonView.fillPaintOK.setColor(n2);
        polygonView.invalidate();
    }

    public void setStrokeColor(int n2) {
        PolygonView polygonView = this;
        polygonView.strokePaint.setColor(n2);
        polygonView.invalidate();
    }

    public void setStrokeColorOK(int n2) {
        PolygonView polygonView = this;
        polygonView.strokePaintOK.setColor(n2);
        polygonView.invalidate();
    }

    public void setStrokeWidth(float f2) {
        PolygonView polygonView = this;
        polygonView.strokePaint.setStrokeWidth(f2);
        polygonView.strokePaintOK.setStrokeWidth(f2);
        polygonView.invalidate();
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        PolygonView polygonView = this;
        super.onSizeChanged(n2, n3, n4, n5);
        polygonView.polygonHelper.setLayout(0, 0, n2, n3);
    }

    @Override
    public boolean handleResult(io.scanbot.sdk.a.a<ContourDetectorFrameHandler.DetectedFrame, io.scanbot.sdk.a> object) {
        if (object instanceof a.b) {
            List<PointF> list;
            object = (ContourDetectorFrameHandler.DetectedFrame)((a.b)object).a();
            if (this.polygon == null && ((ContourDetectorFrameHandler.DetectedFrame)object).polygon == null || (list = this.polygon) != null && list.equals(((ContourDetectorFrameHandler.DetectedFrame)object).polygon)) {
                return false;
            }
            if (this.polygonUpdating.get()) {
                return false;
            }
            this.post(new h(this, (ContourDetectorFrameHandler.DetectedFrame)object));
        }
        return false;
    }

    protected void updatePolygon(DetectionResult detectionResult, int n2, List<PointF> list) {
        PolygonView polygonView = this;
        polygonView.lastResult = detectionResult;
        polygonView.polygonHelper.setRotation(n2);
        if (polygonView.polygon.isEmpty()) {
            PolygonView polygonView2 = this;
            polygonView2.polygonHelper.polygonToPoints(list, this.points);
            if (polygonView2.useFill || this.useFillOK) {
                this.updatePath();
            }
            this.polygonUpdating.set(false);
        } else {
            this.animateToPolygon(list);
        }
        this.polygon = list;
        this.invalidate();
    }

    protected void dispatchDraw(Canvas canvas) {
        PolygonView polygonView = this;
        super.dispatchDraw(canvas);
        Paint paint = polygonView.lastResult == DetectionResult.OK ? this.fillPaintOK : this.fillPaint;
        Paint paint2 = this.lastResult == DetectionResult.OK ? this.strokePaintOK : this.strokePaint;
        boolean bl = this.lastResult == DetectionResult.OK ? this.useFillOK : this.useFill;
        if (!this.polygon.isEmpty()) {
            if (bl) {
                canvas.drawPath(this.path, paint);
            }
            canvas.drawLines(this.points, paint2);
        }
    }

    private class a
    implements TypeEvaluator {
        private a() {
        }

        private void a(float f2, float[] fArray, float[] fArray2) {
            for (int i2 = 0; i2 < PolygonView.this.points.length; ++i2) {
                ((PolygonView)PolygonView.this).points[i2] = fArray[i2] + f2 * (fArray2[i2] - fArray[i2]);
            }
            if (PolygonView.this.useFill || PolygonView.this.useFillOK) {
                PolygonView.this.updatePath();
            }
            PolygonView.this.invalidate();
        }

        /* synthetic */ a(h h2) {
            this();
        }

        public Object evaluate(float f2, Object object, Object object2) {
            this.a(f2, (float[])object, (float[])object2);
            return null;
        }
    }
}

