/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.loading;

import android.content.Context;
import android.content.Loader;
import android.os.Handler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public abstract class SingleThreadLoader<D>
extends Loader<D> {
    private static ExecutorService executor;
    private final Handler handler = new Handler();
    private final Logger logger = LoggerProvider.getLogger();
    private D data;
    private Future future;
    private Runnable loadDataTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SingleThreadLoader(Context context) {
        super((Context)context);
        this_.loadDataTask = new Runnable(){

            @Override
            public void run() {
                a a2 = this;
                final Object d2 = a2.SingleThreadLoader.this.doInBackground();
                a2.SingleThreadLoader.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        SingleThreadLoader.this.dispatchOnLoadComplete(d2);
                    }
                });
            }
        };
        Class<SingleThreadLoader> this_ = SingleThreadLoader.class;
        synchronized (SingleThreadLoader.class) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor();
            }
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void dispatchOnLoadComplete(D data) {
        this.future = null;
        this.data = data;
        if (this.isAbandoned()) {
            this.logger.d("Loader", "Loader was abandoned, not delivering");
        } else if (this.isStarted()) {
            void var1_1;
            this.logger.d("Loader", "Delivering new result=" + var1_1);
            this.deliverResult(var1_1);
        } else {
            this.logger.d("Loader", "Loader was stopped, not delivering");
        }
    }

    protected abstract D doInBackground();

    protected void onStartLoading() {
        SingleThreadLoader singleThreadLoader = this;
        super.onStartLoading();
        D d2 = singleThreadLoader.data;
        if (d2 != null) {
            this.deliverResult(d2);
        } else if (!this.takeContentChanged() && this.future != null) {
            this.logger.d("OCR", "Doing nothing");
        } else {
            this.forceLoad();
        }
    }

    protected void onForceLoad() {
        block4: {
            SingleThreadLoader singleThreadLoader = this;
            super.onForceLoad();
            if (singleThreadLoader.future == null) break block4;
            this.future.cancel(true);
        }
        try {
            this.future = executor.submit(this.loadDataTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.deliverResult(null);
        }
    }

    protected void onReset() {
        SingleThreadLoader singleThreadLoader = this;
        super.onReset();
        Future future = singleThreadLoader.future;
        if (future != null) {
            future.cancel(true);
        }
        SingleThreadLoader singleThreadLoader2 = this;
        singleThreadLoader2.data = null;
        singleThreadLoader2.future = null;
    }
}

