/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.graphics.PointF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.a;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private static final int OK_DETECTIONS_COUNT_FOR_AUTOSNAP = 3;
    private static final double OK_DETECTIONS_THRESHOLD = 0.05;
    protected final ScanbotCameraView cameraView;
    protected final SignificantMoveCatcher significantMoveCatcher;
    protected final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove;
    protected final AtomicLong captureInterval;
    protected final Logger logger;
    protected long lastCapture;
    protected AtomicBoolean capturing;
    protected boolean ignoreBadAspectRatio;
    protected final Handler mainThreadHandler;
    private boolean isAutoSnapEnabled;
    private AtomicBoolean isAutosnappingShooting;
    private AutoSnappingCallback autoSnappingCallback;
    private final Runnable autosnappingShoot;
    private List<PointF> lastDetectedPolygon;
    private AtomicInteger okDetectionCounter;

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        return AutoSnappingController.attach(cameraView, new ContourDetectorFrameHandler(cameraView.getContext()));
    }

    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(cameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this(cameraView, (PreviewBuffer.FrameHandler)contourDetectorFrameHandler);
        contourDetectorFrameHandler.addResultHandler(new d());
    }

    protected AutoSnappingController(ScanbotCameraView cameraView, PreviewBuffer.FrameHandler frameHandler) {
        ScanbotCameraView scanbotCameraView = cameraView;
        AutoSnappingController autoSnappingController = this;
        this.lastSignificantMove = 0L;
        this.captureInterval = new AtomicLong(1000L);
        this.logger = LoggerProvider.getLogger();
        this.lastCapture = 0L;
        this.capturing = new AtomicBoolean(false);
        this.ignoreBadAspectRatio = false;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.isAutoSnapEnabled = true;
        this.isAutosnappingShooting = new AtomicBoolean(false);
        this.autoSnappingCallback = AutoSnappingCallback.NULL;
        this.autosnappingShoot = new Runnable(){

            @Override
            public void run() {
                boolean bl = SystemClock.elapsedRealtime() - AutoSnappingController.this.lastSignificantMove <= 2000L;
                if (AutoSnappingController.this.isAutoSnapEnabled && !bl) {
                    if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                        if (Build.VERSION.SDK_INT >= 24) {
                            AutoSnappingController.this.cameraView.takePicture(false);
                        } else {
                            AutoSnappingController.this.cameraView.takePicture(true);
                        }
                    }
                } else {
                    AutoSnappingController.this.isAutosnappingShooting.set(false);
                }
            }
        };
        this.okDetectionCounter = new AtomicInteger(0);
        autoSnappingController.cameraView = cameraView;
        autoSnappingController.significantMoveCatcher = new SignificantMoveCatcher(cameraView.getContext().getApplicationContext());
        autoSnappingController.significantMoveListener = new SignificantMoveListenerImpl();
        scanbotCameraView.getPreviewBuffer().addFrameHandler(frameHandler);
        scanbotCameraView.addPictureCallback(new e());
        scanbotCameraView.addCameraStateCallback(new b());
        scanbotCameraView.addTakePictureCallback(new c());
    }

    /*
     * WARNING - void declaration
     */
    private void checkDetectedPolygonAndSnap(List<PointF> polygon) {
        void var1_1;
        if (polygon != null && !var1_1.isEmpty() && this.okDetectionCounter.get() < 3) {
            List<PointF> list = this.lastDetectedPolygon;
            if (list == null) {
                this.lastDetectedPolygon = var1_1;
            } else if (this.polygonsAreClose(list, (List<PointF>)var1_1)) {
                this.okDetectionCounter.incrementAndGet();
            } else {
                this.okDetectionCounter.set(0);
                this.lastDetectedPolygon = var1_1;
            }
        } else {
            AutoSnappingController autoSnappingController = this;
            autoSnappingController.isAutosnappingShooting.set(true);
            autoSnappingController.mainThreadHandler.post(this.autosnappingShoot);
            autoSnappingController.okDetectionCounter.set(0);
            autoSnappingController.lastDetectedPolygon = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean polygonsAreClose(List<PointF> lastDetectedPolygon, List<PointF> polygon) {
        void var2_2;
        void var1_1;
        return (double)Math.abs(lastDetectedPolygon.get((int)0).x - polygon.get((int)0).x) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)0)).y - ((PointF)var2_2.get((int)0)).y) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)2)).x - ((PointF)var2_2.get((int)2)).x) < 0.05 && (double)Math.abs(((PointF)var1_1.get((int)2)).y - ((PointF)var2_2.get((int)2)).y) < 0.05;
    }

    /*
     * WARNING - void declaration
     */
    private float clamp(float value) {
        void var1_1;
        if (value < 0.0f) {
            return 0.0f;
        }
        if (var1_1 > 1.0f) {
            return 1.0f;
        }
        return (float)var1_1;
    }

    static /* synthetic */ long access$002(AutoSnappingController x0, long x1) {
        x0.lastSignificantMove = x1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onDetectionOK(List<PointF> polygon) {
        if (!this.isAutosnappingShooting.get()) {
            void var1_1;
            this.checkDetectedPolygonAndSnap((List<PointF>)var1_1);
        }
    }

    public void setEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float sensitivity) {
        AutoSnappingController autoSnappingController = this_;
        this_.logger.logMethod();
        float this_ = 1.0f - autoSnappingController.clamp(sensitivity);
        autoSnappingController.captureInterval.set((long)(this_ * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = ignoreBadAspectRatio;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        AutoSnappingCallback autoSnappingCallback;
        this.logger.logMethod();
        if (callback == null) {
            autoSnappingCallback = AutoSnappingCallback.NULL;
        }
        this.autoSnappingCallback = autoSnappingCallback;
    }

    private class c
    implements CameraTakePictureCallback {
        private c() {
        }

        @Override
        public void onTakePictureRequested() {
        }

        @Override
        public void onTakePictureCancelled() {
            c c2 = this;
            c2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            c2.AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    protected class SignificantMoveListenerImpl
    implements SignificantMoveListener {
        protected SignificantMoveListenerImpl() {
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            SignificantMoveListenerImpl significantMoveListenerImpl = this;
            AutoSnappingController.access$002(significantMoveListenerImpl.AutoSnappingController.this, SystemClock.elapsedRealtime());
            if (significantMoveListenerImpl.AutoSnappingController.this.capturing.get() && AutoSnappingController.this.isAutosnappingShooting.get()) {
                SignificantMoveListenerImpl significantMoveListenerImpl2 = this;
                significantMoveListenerImpl2.AutoSnappingController.this.cameraView.continuousFocus();
                significantMoveListenerImpl2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
                significantMoveListenerImpl2.AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    }

    private class b
    implements CameraStateCallback {
        private b() {
        }

        @Override
        public void onResume() {
            b b2 = this_;
            b2.AutoSnappingController.this.capturing.set(true);
            AutoSnappingController this_ = b2.AutoSnappingController.this;
            this_.significantMoveCatcher.registerSignificantMoveListener(this_.significantMoveListener);
        }

        @Override
        public void onPause() {
            b b2 = this_;
            AutoSnappingController this_ = b2.AutoSnappingController.this;
            this_.significantMoveCatcher.unregisterSignificantMoveListener(this_.significantMoveListener);
            b2.AutoSnappingController.this.isAutosnappingShooting.set(false);
            b2.AutoSnappingController.this.capturing.set(false);
            b2.AutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class e
    implements PictureCallback {
        private e() {
        }

        @Override
        public void onPictureTaken(byte[] image, int imageOrientation) {
            e e2 = this;
            e2.AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            e2.AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class d
    implements ContourDetectorFrameHandler.ResultHandler {
        private d() {
        }

        private void a(final List<PointF> polygon) {
            AutoSnappingController.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    AutoSnappingController.this.onDetectionOK(polygon);
                }
            });
        }

        @Override
        public boolean handleResult(FrameHandlerResult<ContourDetectorFrameHandler.DetectedFrame, a> result) {
            if (result instanceof FrameHandlerResult.Success) {
                ContourDetectorFrameHandler.DetectedFrame detectedFrame;
                detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)((Object)detectedFrame)).getValue();
                AutoSnappingController.this.logger.logMethod();
                Object object = detectedFrame.detectionResult;
                if ((object == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && object == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get()) {
                    object = AutoSnappingController.this;
                    if (SystemClock.elapsedRealtime() - object.lastCapture > object.captureInterval.get()) {
                        if (AutoSnappingController.this.lastCapture != 0L) {
                            this.a(detectedFrame.polygon);
                        }
                        AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                    }
                }
            }
            return false;
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

