/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final Pattern FILE_NAME_ANTIPATTERN = Pattern.compile("[\\\\|?*<\\\">+\\[\\]/':]", 2);
    private static final int MAX_FILE_NAME_LENGTH = 250;
    public static final String SCANBOT_SDK_FILES_DIR = "scanbot-sdk";

    public static boolean isFileNameSafe(CharSequence name) {
        CharSequence charSequence;
        if (!TextUtils.isEmpty((CharSequence)name) && charSequence.length() <= 250) {
            return FILE_NAME_ANTIPATTERN.matcher(charSequence).find() ^ true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static File getExternalFilesDirOrShowError(Context context, String directoryName) throws IOException {
        void var1_1;
        File file;
        Object object = null;
        try {
            object = context.getExternalFilesDir(null);
        }
        catch (NullPointerException nullPointerException) {}
        if (object == null) {
            return FileUtils.fail();
        }
        File file2 = file;
        if (!new File((File)object, (String)var1_1).exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File getExternalStorageDirOrShowError(Context context, String directoryName) throws IOException {
        void var1_1;
        Context context2;
        File file;
        context = Environment.getExternalStorageDirectory();
        if (context == null) {
            return FileUtils.fail();
        }
        File file2 = file;
        if (!new File((File)context2, (String)var1_1).exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File getAppFilesDirOrShowError(Context context, String directoryName) throws IOException {
        void var1_1;
        File file;
        Object object = null;
        try {
            object = context.getFilesDir();
        }
        catch (NullPointerException nullPointerException) {}
        if (object == null) {
            return FileUtils.fail();
        }
        File file2 = file;
        if (!new File((File)object, (String)var1_1).exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File getExternalCacheDirOrShowError(Context context, String directoryName) throws IOException {
        void var1_1;
        Context context2;
        File file;
        if ((context = context.getExternalCacheDir()) == null) {
            return FileUtils.fail();
        }
        File file2 = file;
        if (!new File((File)context2, (String)var1_1).exists() && !file2.mkdir()) {
            return FileUtils.fail();
        }
        return file2;
    }

    public static boolean ensureDirExists(String directoryPath) {
        String string2;
        File file;
        if (TextUtils.isEmpty((CharSequence)directoryPath)) {
            return false;
        }
        File file2 = file;
        return new File(string2).exists() || file2.mkdirs();
    }

    public static File getFilesDirOrShowError(String parentDirPath, String directoryName) throws IOException {
        String string2;
        File file;
        File file2;
        File file3 = file2;
        file2 = new File((String)parentDirPath);
        parentDirPath = file;
        if (!new File(file3, directoryName).exists() && !((File)((Object)string2)).mkdir()) {
            return FileUtils.fail();
        }
        return string2;
    }

    private static File fail() throws IOException {
        throw new IOException("can't get external directory");
    }
}

