/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doo.snap.util.log.Logger;

public final class DebugLog
implements Logger {
    public static final String LOG_DIRECTORY = "debug_logs";
    public static final String LOG_EXTENSION = ".txt";
    private static final String LOG_FIELD_SEPARATOR = " | ";
    private static final String UNKNOWN_SIGNATURE = "[unknown]";
    private static final String DEFAULT_PACKAGE_NAME = "default";
    private static final String NO_APPLICATION_INFO_MESSAGE = "[No application info]";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS] ");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("([A-Z]*|(^[a-z]))[_\\da-z\\$]*");
    private static boolean prepared = false;
    private static boolean savingEnabled = true;
    private static boolean echoEnabled = true;
    private static Logger.Level savingLevel;
    private static Logger.Level echoLevel;
    private static String packageName;

    /*
     * WARNING - void declaration
     */
    public DebugLog(Context context) {
        prepared = true;
        if (context != null) {
            void var1_1;
            void v0 = var1_1;
            packageName = v0.getPackageName();
            this.printVersionInfo((Context)v0);
        } else {
            packageName = DEFAULT_PACKAGE_NAME;
        }
    }

    private void printVersionInfo(Context context) {
        String string2;
        StringBuilder stringBuilder;
        PackageInfo packageInfo;
        block8: {
            block7: {
                StringBuilder stringBuilder2;
                packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
                int n2 = packageInfo.applicationInfo.labelRes;
                stringBuilder = stringBuilder2;
                stringBuilder2 = new StringBuilder();
                if (n2 == 0) break block7;
                string2 = string2.getString(n2);
                break block8;
            }
            string2 = UNKNOWN_SIGNATURE;
        }
        try {
            string2 = stringBuilder.append(string2).append(" v").append(packageInfo.versionName).append(" #").append(packageInfo.versionCode).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.logException(nameNotFoundException);
            string2 = NO_APPLICATION_INFO_MESSAGE;
        }
        this.i("APP_INFO", string2);
    }

    /*
     * WARNING - void declaration
     */
    private void logMessage(String tag, String message, Logger.Level level) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (!prepared) {
            return;
        }
        if (echoEnabled && var3_3.ordinal() >= echoLevel.ordinal()) {
            this.echoMessage((String)var1_1, (String)var2_2, (Logger.Level)var3_3);
        }
        if (savingEnabled && var3_3.ordinal() >= savingLevel.ordinal()) {
            this.logToFile((String)var1_1, (String)var2_2, (Logger.Level)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void echoMessage(String tag, String message, Logger.Level level) {
        switch (level) {
            default: {
                break;
            }
            case Verbose: {
                void var2_2;
                void var1_1;
                Log.v((String)var1_1, (String)var2_2);
                break;
            }
            case Information: {
                void var2_2;
                void var1_1;
                Log.i((String)var1_1, (String)var2_2);
                break;
            }
            case Warning: {
                void var2_2;
                void var1_1;
                Log.w((String)var1_1, (String)var2_2);
                break;
            }
            case Error: {
                void var2_2;
                void var1_1;
                Log.e((String)var1_1, (String)var2_2);
                break;
            }
            case Debug: {
                void var2_2;
                void var1_1;
                Log.d((String)var1_1, (String)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void logToFile(String tag, String message, Logger.Level level) {
        Writer writer = this.getLogWriter();
        if (writer != null) {
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                Writer writer2 = writer;
                writer2.write(this.buildLogMessage((String)var1_1, (String)var2_2, (Logger.Level)var3_3));
                this.closeSafely(writer2);
            }
            catch (Throwable throwable) {
                this.closeSafely(writer);
                throw throwable;
            }
            catch (IOException iOException) {
                this.closeSafely(writer);
            }
        }
    }

    private void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - void declaration
     */
    private String buildLogMessage(String tag, String message, Logger.Level level) {
        void var2_2;
        void var3_3;
        void var1_1;
        String string2 = tag != null ? var1_1.replace('|', '/') : "";
        return TIME_FORMAT.format(new Date()) + var3_3 + LOG_FIELD_SEPARATOR + (String)string2 + LOG_FIELD_SEPARATOR + (String)var2_2 + "\r\n";
    }

    private Writer getLogWriter() {
        FileWriter fileWriter;
        File file;
        Object var1_1 = null;
        File file2 = Environment.getExternalStorageDirectory();
        ((DebugLog)this_).prepareLogsFolder(file2);
        File file3 = file;
        file = new File(file2, ((DebugLog)this_).getLogFilename());
        Object this_ = fileWriter;
        try {
            fileWriter = new FileWriter(file3, true);
        }
        catch (IOException iOException) {
            this_ = var1_1;
        }
        return this_;
    }

    private void prepareLogsFolder(File externalStorage) {
        File file;
        File this_ = file;
        if (!new File(externalStorage, LOG_DIRECTORY).exists()) {
            this_.mkdir();
        }
    }

    private String getLogFilename() {
        return LOG_DIRECTORY + File.separatorChar + packageName + LOG_EXTENSION;
    }

    private String tokenizeClassName(String className) {
        String string2;
        block9: {
            ArrayList arrayList;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList();
            Matcher matcher = CLASS_NAME_PATTERN.matcher(string2);
            while (true) {
                if (!matcher.find()) break;
                String string3 = string2.substring(matcher.start(), matcher.end());
                if (TextUtils.isEmpty((CharSequence)string3.trim())) continue;
                this_.add(string3.toUpperCase());
            }
            try {
                if (this_.isEmpty()) break block9;
            }
            catch (Exception exception) {}
            string2 = TextUtils.join((CharSequence)"_", (Iterable)this_);
        }
        return string2;
    }

    private String getCallerClassName() {
        Object object;
        block7: {
            try {
                object = Thread.currentThread().getStackTrace();
            }
            catch (Exception exception) {}
            if (((StackTraceElement[])object).length <= 4) break block7;
            object = object[4].getClassName();
            int n2 = ((String)object).lastIndexOf(".");
            if (n2 < 0) break block7;
            ++n2;
            if (n2 >= ((String)object).length()) break block7;
            object = ((String)object).substring(n2);
        }
        object = UNKNOWN_SIGNATURE;
        return this.tokenizeClassName((String)object);
    }

    private String getCallerMethodName() {
        Object object;
        block4: {
            try {
                object = Thread.currentThread().getStackTrace();
            }
            catch (Exception exception) {}
            if (((StackTraceElement[])object).length <= 4) break block4;
            object = object[4].getMethodName();
        }
        object = UNKNOWN_SIGNATURE;
        return object;
    }

    static {
        echoLevel = savingLevel = Logger.Level.Verbose;
        packageName = DEFAULT_PACKAGE_NAME;
    }

    @Override
    public void d(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Debug);
    }

    @Override
    public void w(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Warning);
    }

    @Override
    public void e(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Error);
    }

    @Override
    public void i(String tag, String message) {
        this.logMessage(tag, message, Logger.Level.Information);
    }

    public void e(String tag, String where, Throwable e2) {
        this.e(tag, "Exception in " + where + ": " + e2.getClass().getName() + LOG_FIELD_SEPARATOR + e2.getMessage());
    }

    public void d(String message) {
        DebugLog debugLog = this;
        debugLog.d(debugLog.getCallerClassName(), message);
    }

    public void i(String message) {
        DebugLog debugLog = this;
        debugLog.i(debugLog.getCallerClassName(), message);
    }

    public void w(String message) {
        DebugLog debugLog = this;
        debugLog.w(debugLog.getCallerClassName(), message);
    }

    public void e(String message) {
        DebugLog debugLog = this;
        debugLog.e(debugLog.getCallerClassName(), message);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logException(Throwable e2) {
        void var1_1;
        if (!prepared) {
            return;
        }
        DebugLog debugLog = this;
        String string2 = debugLog.getCallerClassName();
        String string3 = debugLog.getCallerMethodName();
        if (var1_1 != null) {
            this.e(string2, string3, (Throwable)var1_1);
        } else {
            this.e(string2, string3, new Exception("Unknown exception"));
        }
    }

    @Override
    public void logMethod() {
        if (!prepared) {
            return;
        }
        DebugLog debugLog = this;
        debugLog.i(debugLog.getCallerClassName(), this.getCallerMethodName());
    }
}

