/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.hardware.Camera;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class Utils {
    private static final int A4_AREA = 8699840;
    private static final double ASPECT_TOLERANCE = 0.1;

    public static boolean isFlashSupported(Camera.Parameters parameters) {
        Object object;
        if (parameters == null) {
            return false;
        }
        return !((object = object.getSupportedFlashModes()) == null || object.isEmpty() || object.size() == 1 && ((String)object.get(0)).equals("off"));
        {
        }
    }

    public static Camera.Size getBestA4PictureSize(Camera.Parameters parameters) {
        Camera.Parameters parameters2;
        Object object2;
        TreeMap treeMap;
        Camera.Parameters parameters3 = parameters;
        parameters = treeMap;
        treeMap = new TreeMap();
        for (Object object2 : parameters3.getSupportedPictureSizes()) {
            parameters2.put(((Camera.Size)object2).width * ((Camera.Size)object2).height, object2);
        }
        Camera.Size size = null;
        object2 = parameters2.ceilingEntry(8699840);
        if (object2 == null) {
            object2 = parameters2.floorEntry(8699840);
        }
        if (object2 != null) {
            size = (Camera.Size)object2.getValue();
        }
        return size;
    }

    public static Camera.Size getLargestPictureSize(Camera.Parameters parameters) {
        Camera.Parameters parameters2;
        Camera.Parameters parameters3 = parameters;
        parameters = null;
        for (Camera.Size size : parameters3.getSupportedPictureSizes()) {
            int n2;
            if (parameters2 != null && size.width * size.height <= (n2 = parameters2.width * parameters2.height)) {
                size = parameters2;
            }
            parameters2 = size;
        }
        return parameters2;
    }

    /*
     * WARNING - void declaration
     */
    public static Camera.Size getLargestSizeWithAspectRatioMatch(List<Camera.Size> sizes, double targetAspect) {
        List<Camera.Size> list;
        ArrayList<Camera.Size> arrayList;
        b b2;
        List<Camera.Size> list2 = sizes;
        sizes = b2;
        b2 = new b();
        ArrayList<Camera.Size> arrayList2 = arrayList;
        arrayList = new ArrayList<Camera.Size>();
        for (Camera.Size size : list2) {
            Camera.Size size2;
            void var1_1;
            if (!(Math.abs((double)(var1_1 - (double)size2.width / (double)size.height)) < 0.1)) continue;
            arrayList2.add(size);
        }
        return Collections.max(arrayList2, list);
    }

    /*
     * WARNING - void declaration
     */
    public static Camera.Size findByWidthAndHeight(Camera.Parameters parameters, int width, int height) {
        for (Camera.Size size : parameters.getSupportedPictureSizes()) {
            void var2_2;
            void var1_1;
            if (size.width != var1_1 || size.height != var2_2) continue;
            return size;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Camera.Size getBestAspectPictureSize(int displayOrientation, int width2, int height, Camera.Parameters parameters, double closeEnough) {
        Camera.Size size3;
        block5: {
            void var3_7;
            int n2;
            double d2 = width2;
            double width2 = height;
            double d3 = d2 / width2;
            Camera.Size size2 = null;
            double d4 = Double.MAX_VALUE;
            if (displayOrientation == 90 || n2 == 270) {
                void var1_3;
                d3 = var1_3 / d2;
            }
            List list = var3_7.getSupportedPictureSizes();
            Collections.sort(list, Collections.reverseOrder(new b()));
            for (Camera.Size size3 : list) {
                void var4_8;
                double d5;
                double d6 = (double)size3.width / (double)size3.height - d3;
                if (Math.abs(d5) < d4) {
                    d4 = Math.abs(d6);
                } else {
                    size3 = size2;
                }
                if (!(d4 < var4_8)) {
                    size2 = size3;
                    continue;
                }
                break block5;
            }
            size3 = size2;
        }
        return size3;
    }

    public static void enableContinuousFocus(Camera.Parameters parameters) {
        if (parameters == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            Camera.Parameters parameters2;
            List<String> list = Utils.extractFocusModes(parameters2);
            if (list.contains("continuous-picture")) {
                parameters2.setFocusMode("continuous-picture");
            } else if (list.contains("continuous-video")) {
                parameters2.setFocusMode("continuous-video");
            } else if (list.contains("auto")) {
                parameters2.setFocusMode("auto");
            }
        }
    }

    public static void enableAutoFocus(Camera.Parameters parameters) {
        Camera.Parameters parameters2;
        if (parameters == null) {
            return;
        }
        if (Utils.extractFocusModes(parameters2).contains("auto") && !parameters2.getFocusMode().equals("auto")) {
            parameters2.setFocusMode("auto");
        }
    }

    private static List<String> extractFocusModes(Camera.Parameters parameters) {
        Object object;
        if (parameters == null) {
            return Collections.emptyList();
        }
        if ((object = object.getSupportedFocusModes()) == null) {
            object = Collections.emptyList();
        }
        return object;
    }

    private static class b
    implements Comparator<Camera.Size> {
        private b() {
        }

        public int a(Camera.Size lhs, Camera.Size rhs) {
            return lhs.width * lhs.height - rhs.width * rhs.height;
        }
    }
}

