/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    public static final String d = "thumbnail";
    public static final String e = "snapping_documents";
    private static final String f = "%s(%d)%s";
    private static final String g = " (1).";
    private final Context a;
    private final SharedPreferences b;
    private final Logger c = LoggerProvider.getLogger();

    @Inject
    public DocumentStoreStrategy(Context context, SharedPreferences preferences) {
        this.a = context;
        this.b = preferences;
    }

    /*
     * WARNING - void declaration
     */
    public boolean ensureDocumentDir(File docDir) {
        void var1_1;
        return docDir != null && var1_1.exists() && (this = var1_1.listFiles()) != null && this.length >= 1;
    }

    public File getDocumentsDir() throws IOException {
        String string = this.b.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!string.isEmpty()) {
            return net.doo.snap.util.FileUtils.getFilesDirOrShowError(string, e);
        }
        return net.doo.snap.util.FileUtils.getFilesDirOrShowError(net.doo.snap.util.FileUtils.getAppFilesDirOrShowError(this.a, "scanbot-sdk").getPath(), e);
    }

    public File getDocumentDir(String docId) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{docId});
    }

    public void ensureDocumentDirectory(String docId) throws IOException {
        FileUtils.forceMkdir((File)this.getDocumentDir(docId));
    }

    public File getDocumentFile(String docId, String name) throws IOException {
        return FileUtils.getFile((File)this.getDocumentDir(docId), (String[])new String[]{name});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        File[] fileArray = this.getDocumentsDir().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.addAll(Arrays.asList(fileArray[i2].listFiles(new FilenameFilter(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean accept(File dir, String filename) {
                    void var2_2;
                    return filename.endsWith(".jpg") || var2_2.endsWith(".pdf");
                }
            })));
        }
        return arrayList2;
    }

    public File getThumbnailFile(String docId) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{docId, d});
    }

    /*
     * WARNING - void declaration
     */
    public void eraseDocument(String docId, String docName) {
        void var2_3;
        void var1_1;
        DocumentStoreStrategy documentStoreStrategy = this;
        void v1 = var1_1;
        FileUtils.deleteQuietly((File)this.getDocumentFile((String)var1_1, (String)var2_3));
        try {
            FileUtils.deleteQuietly((File)documentStoreStrategy.getDocumentDir((String)v1));
        }
        catch (IOException iOException) {
            this.c.logException(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void eraseDocumentThumbnail(String docId) {
        try {
            void var1_1;
            FileUtils.deleteQuietly((File)this.getThumbnailFile((String)var1_1));
        }
        catch (IOException iOException) {
            this.c.logException(iOException);
        }
    }

    public boolean renameDocument(String docId, String oldName, String newName) throws IOException {
        DocumentStoreStrategy documentStoreStrategy = this_;
        File this_ = ((DocumentStoreStrategy)((Object)this_)).getDocumentFile(docId, ((DocumentStoreStrategy)((Object)this_)).getUniqueName(newName));
        return documentStoreStrategy.getDocumentFile(docId, oldName).renameTo(this_);
    }

    /*
     * Loose catch block
     */
    public String getUniqueName(String newName) {
        String string;
        block15: {
            while (true) {
                int n2;
                block14: {
                    String string2;
                    string2 = TextUtils.isEmpty((CharSequence)(string2 = FilenameUtils.getExtension((String)newName))) ? "" : "." + string2;
                    String string3 = FilenameUtils.getBaseName((String)string);
                    n2 = string3.lastIndexOf("(");
                    int n3 = string3.lastIndexOf(")");
                    Integer n4 = 0;
                    String string4 = FilenameUtils.getBaseName((String)string);
                    if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                        try {
                            n4 = Integer.valueOf(string3.substring(n2 + 1, n3));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        string4 = string3.substring(0, n2 - 1);
                    }
                    n2 = 0;
                    Iterator<File> iterator = this.getDocumentsFiles().iterator();
                    while (true) {
                        if (!iterator.hasNext()) break block14;
                        if (!FilenameUtils.getBaseName((String)iterator.next().getName()).equals(string3)) continue;
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append(string4).append(" (");
                    int n5 = n4;
                    string = stringBuilder.append(n5 + 1).append(")").append(string2).toString();
                    n2 = 1;
                }
                if (n2 != 0) {
                    continue;
                }
                break block15;
                break;
            }
            catch (IOException iOException) {
                this.c.logException(iOException);
            }
        }
        return string;
    }

    public String getPageImagePath(int pagePosition, Document document) throws IOException {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = FilenameUtils.removeExtension((String)this.getDocumentFile(document.getId(), document.getName()).getPath());
        objectArray[1] = pagePosition;
        objectArray[2] = ".jpg";
        return String.format(f, objectArray2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void migrateDocuments(String newPath, List<Document> documents) {
        var2_3 = TextUtils.isEmpty((CharSequence)newPath) ^ true;
        var3_4 = documents.iterator();
        while (true) {
            if (!var3_4.hasNext()) {
                return;
            }
            v0 = var3_4.next();
            var4_5 = v0.getName();
            var5_7 = v0.getId();
            if (!var2_3) ** GOTO lbl18
            ** GOTO lbl14
            {
                block10: {
                    block11: {
                        catch (Throwable v1) {}
                        continue;
lbl14:
                        // 1 sources

                        var6_8 = v2;
                        v2 = new File((String)var1_1);
                        break block11;
lbl18:
                        // 1 sources

                        var6_8 = this.getDocumentDir(var5_7);
                    }
                    if (!FileUtils.getFile((File)var6_8, (String[])new String[]{var4_5}).exists()) break block10;
                    v3 = this;
                    v4 = var5_7;
                    v5 = var4_5;
                    v6 = v5;
                    var4_5 = FilenameUtils.getExtension((String)v5);
                    var7_9 = FilenameUtils.getBaseName((String)v5);
                    var4_5 = var7_9 + " (1)." + var4_5;
                    try {
                        v3.renameDocument(v4, v6, var4_5);
                    }
                    catch (IOException var4_6) {}
                    {
                        this.c.logException(var4_6);
                        continue;
                    }
                }
                FileUtils.moveFileToDirectory((File)this.getDocumentFile(var5_7, var4_5), (File)var6_8, (boolean)true);
            }
            break;
        }
    }
}

