/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import net.doo.snap.R;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.i;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessor {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;
    private final BitmapLruCache c;
    private final ComposerFactory d;
    private final a e;
    private final i<Document> f;
    private final Cleaner g;
    private final Logger h;

    @Inject
    public DocumentProcessor(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, i<Document> i2, Cleaner cleaner) {
        DocumentProcessor documentProcessor = this;
        this.h = LoggerProvider.getLogger();
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
        this.c = bitmapLruCache;
        this.d = composerFactory;
        this.f = i2;
        documentProcessor.g = cleaner;
        documentProcessor.e = new a(resources, documentStoreStrategy, pageStoreStrategy);
    }

    private void a(Document document, Page[] pageArray) throws IOException {
        this.a.ensureDocumentDirectory(document.getId());
        if (document.getSize() < 0L) {
            for (int i2 = 0; i2 < pageArray.length; ++i2) {
                Page page = pageArray[i2];
                if (i2 != 0) continue;
                this.e.a(document, page);
            }
        }
        Composer composer = this.d.composerForDocument(document);
        this.h.d("Processing", "(" + document.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document, pageArray);
    }

    public DocumentProcessingResult processDocument(@NotNull DocumentDraft pageArray) throws IOException {
        DocumentProcessor documentProcessor = this;
        Document document = pageArray.getDocument();
        pageArray = pageArray.getPages();
        documentProcessor.a(document, pageArray);
        documentProcessor.f.a(document);
        documentProcessor.c.evictAll();
        documentProcessor.g.cleanUpPagesData(pageArray);
        return new DocumentProcessingResult(document, Arrays.asList(pageArray), this.a.getDocumentFile(document.getId(), document.getName()));
    }

    private static class a {
        private final Resources a;
        private final DocumentStoreStrategy b;
        private PageStoreStrategy c;

        a(Resources resources, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
            this.a = resources;
            this.b = documentStoreStrategy;
            this.c = pageStoreStrategy;
        }

        private void a(Document document, Page page) throws IOException {
            BitmapFactory.Options options;
            int n2 = (int)this.a.getDimension(R.dimen.document_thumbnail_size);
            BitmapFactory.Options options2 = options;
            options2();
            options2.inJustDecodeBounds = true;
            String string = this.c.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options2);
            int n3 = Math.max(options.outHeight, options2.outWidth) / n2;
            if (n3 < 1) {
                n3 = 1;
            }
            new BitmapFactory.Options().inSampleSize = n3;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)new BitmapFactory.Options());
            if (BitmapUtils.isBitmapValid(bitmap)) {
                this.a(page.getRotationType().getDegrees(), n2, bitmap, this.b.getThumbnailFile(document.getId()));
            }
        }

        private void a(int n2, int n3, Bitmap bitmap, File file) throws FileNotFoundException {
            Bitmap.CompressFormat compressFormat;
            FileOutputStream fileOutputStream;
            Matrix matrix;
            Bitmap bitmap2 = bitmap;
            float f2 = (float)n3 / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
            Matrix matrix2 = matrix;
            float f3 = f2;
            matrix2();
            matrix2.preRotate((float)n2, (float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2));
            matrix.postScale(f3, f3);
            int n4 = bitmap2.getWidth();
            n2 = bitmap2.getHeight();
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n2, (Matrix)matrix2, (boolean)true);
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2(file);
            try {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)fileOutputStream2);
                throw throwable;
            }
            bitmap3.compress(compressFormat, 90, (OutputStream)fileOutputStream2);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }
}

