/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.a;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.d.c;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 02\u00020\u0001:\u000201B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rJ\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016J#\u0010$\u001a\u00020\u00132\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020(0&H\u0000\u00a2\u0006\u0002\b)J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rJ\u0014\u0010+\u001a\u00020\u001f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-J\u000e\u0010/\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00062"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "Lnet/doo/snap/camera/PreviewBuffer$FrameHandler;", "context", "Landroid/content/Context;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "(Landroid/content/Context;Lio/scanbot/sdk/ScanbotSDK;)V", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "detectionIntervalInMs", "", "handlers", "Ljava/util/LinkedHashSet;", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "intervalEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getIntervalEnabled$scanbot_sdk_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "sapManager", "Lio/scanbot/sap/SapManager;", "getSapManager$scanbot_sdk_release", "()Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "handleFrame", "previewFrame", "Lnet/doo/snap/camera/PreviewBuffer$FrameHandler$Frame;", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "notifyHandlers$scanbot_sdk_release", "removeResultHandler", "setBarcodeFormatsFilter", "barcodeFormats", "", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "setDetectionInterval", "Companion", "ResultHandler", "scanbot-sdk_release"})
public class BarcodeDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private static final int DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS = 10000;
    public static final Companion Companion = new Companion(null);
    private final LinkedHashSet<ResultHandler> handlers;
    @NotNull
    private final SapManager sapManager;
    private final Logger logger;
    private final ScanbotBarcodeDetector barcodeDetector;
    private boolean isEnabled;
    @NotNull
    private final AtomicBoolean intervalEnabled;
    private long detectionIntervalInMs;

    public BarcodeDetectorFrameHandler(@NotNull Context context, @NotNull ScanbotSDK scanbotSDK) {
        BarcodeDetectorFrameHandler barcodeDetectorFrameHandler = this;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scanbotSDK, (String)"scanbotSDK");
        this.handlers = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
        this.intervalEnabled = new AtomicBoolean(true);
        this.detectionIntervalInMs = 10000;
        barcodeDetectorFrameHandler.barcodeDetector = scanbotSDK.barcodeDetector();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        barcodeDetectorFrameHandler.sapManager = sapManager;
    }

    @JvmStatic
    @NotNull
    public static final BarcodeDetectorFrameHandler attach(@NotNull ScanbotCameraView cameraView, @NotNull ScanbotSDK scanbotSDK) {
        return Companion.attach(cameraView, scanbotSDK);
    }

    @NotNull
    public final SapManager getSapManager$scanbot_sdk_release() {
        return this.sapManager;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final AtomicBoolean getIntervalEnabled$scanbot_sdk_release() {
        return this.intervalEnabled;
    }

    @Override
    public synchronized boolean handleFrame(@NotNull PreviewBuffer.FrameHandler.Frame previewFrame) {
        BarcodeDetectorFrameHandler barcodeDetectorFrameHandler = this;
        Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
        barcodeDetectorFrameHandler.logger.logMethod();
        if (barcodeDetectorFrameHandler.isEnabled && this.intervalEnabled.get()) {
            BarcodeScanningResult barcodeScanningResult;
            if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
                this.notifyHandlers$scanbot_sdk_release(new FrameHandlerResult.Failure<SdkLicenseError>(new SdkLicenseError()));
                return false;
            }
            if (((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).finderRect == null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).frame, (String)"previewFrame.frame");
                barcodeScanningResult = this.barcodeDetector.decodeWithState(((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).frame, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).width, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).height, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).frameOrientation);
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).frame, (String)"previewFrame.frame");
                barcodeScanningResult = this.barcodeDetector.decodeWithState(((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).frame, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).width, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).height, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).frameOrientation, ((PreviewBuffer.FrameHandler.Frame)((Object)barcodeScanningResult)).finderRect);
            }
            if (barcodeScanningResult != null) {
                this.intervalEnabled.set(false);
                new Timer().schedule(new TimerTask(this){
                    final /* synthetic */ BarcodeDetectorFrameHandler this$0;
                    {
                        this.this$0 = $outer;
                    }

                    public void run() {
                        this.this$0.getIntervalEnabled$scanbot_sdk_release().set(true);
                    }
                }, this.detectionIntervalInMs);
            }
            return this.notifyHandlers$scanbot_sdk_release(new FrameHandlerResult.Success<BarcodeScanningResult>(barcodeScanningResult));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            void var1_1;
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        LinkedHashSet<ResultHandler> linkedHashSet = this.handlers;
        synchronized (linkedHashSet) {
            void var1_1;
            this.handlers.remove(var1_1);
            return;
        }
    }

    public final void setDetectionInterval(long detectionIntervalInMs) {
        this.detectionIntervalInMs = detectionIntervalInMs;
        this.intervalEnabled.set(true);
    }

    public final void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Intrinsics.checkParameterIsNotNull(barcodeFormats, (String)"barcodeFormats");
        this.barcodeDetector.setBarcodeFormatsFilter(barcodeFormats);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean notifyHandlers$scanbot_sdk_release(@NotNull FrameHandlerResult<BarcodeScanningResult, SdkLicenseError> result) {
        BarcodeDetectorFrameHandler barcodeDetectorFrameHandler = this_;
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        boolean this_ = false;
        LinkedHashSet<ResultHandler> linkedHashSet = barcodeDetectorFrameHandler.handlers;
        synchronized (linkedHashSet) {
            int n2;
            Iterator iterator = barcodeDetectorFrameHandler.handlers.iterator();
            while (true) {
                void var1_2;
                if (!iterator.hasNext()) break;
                n2 |= ((ResultHandler)iterator.next()).a(var1_2);
                continue;
                break;
            }
            void v1 = n2;
            LinkedHashSet<ResultHandler> linkedHashSet2 = linkedHashSet;
            return (boolean)v1;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "scanbot-sdk_release"})
    public static interface ResultHandler
    extends a<BarcodeScanningResult, SdkLicenseError> {
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler$Companion;", "", "()V", "DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS", "", "attach", "Lio/scanbot/sdk/barcode/BarcodeDetectorFrameHandler;", "cameraView", "Lnet/doo/snap/camera/ScanbotCameraView;", "scanbotSDK", "Lio/scanbot/sdk/ScanbotSDK;", "scanbot-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        @NotNull
        public final BarcodeDetectorFrameHandler attach(@NotNull ScanbotCameraView cameraView, @NotNull ScanbotSDK scanbotSDK) {
            BarcodeDetectorFrameHandler barcodeDetectorFrameHandler;
            Intrinsics.checkParameterIsNotNull((Object)((Object)cameraView), (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)scanbotSDK, (String)"scanbotSDK");
            BarcodeDetectorFrameHandler this_ = barcodeDetectorFrameHandler;
            Context context = cameraView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"cameraView.context");
            this_(context, scanbotSDK);
            cameraView.getPreviewBuffer().addFrameHandler(this_);
            return barcodeDetectorFrameHandler;
        }
    }
}

