/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.R;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.ui.MagnifierView;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends AppCompatImageView {
    private static final int CORNERS_COUNT = 4;
    public static final List<PointF> DEFAULT_POLYGON = new ArrayList<PointF>(){
        {
            a a2 = this;
            a2.add(new PointF(0.0f, 0.0f));
            a2.add(new PointF(1.0f, 0.0f));
            a2.add(new PointF(1.0f, 1.0f));
            a2.add(new PointF(0.0f, 1.0f));
        }
    };
    private EditPolygonAnimationEndListener editPolygonAnimationEndListener = null;
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final int edgeColorOnLine;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private Paint paint;
    private Paint paintOnLine;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<i> horizontalLines = new ArrayList<i>();
    private final List<i> verticalLines = new ArrayList<i>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<h> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private h selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue;
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix;
    private RectF touchRect;
    private float polygonStrokeWidth;
    private int lastKnownImageWidth;
    private int lastKnownImageHeight;
    private float scaleLandscape;
    private float scalePortrait;

    public static List<PointF> getDefaultPolygon() {
        return new ArrayList<PointF>(){
            {
                b b2 = this;
                b2.add(new PointF(0.0f, 0.0f));
                b2.add(new PointF(1.0f, 0.0f));
                b2.add(new PointF(1.0f, 1.0f));
                b2.add(new PointF(0.0f, 1.0f));
            }
        };
    }

    public EditPolygonImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int n2;
        h h2;
        TypedArray typedArray;
        Comparator<PointF> comparator;
        Comparator<PointF> comparator2 = comparator;
        comparator = new Comparator<PointF>(){

            public int a(PointF lhs, PointF rhs) {
                return Double.compare(Math.atan2(lhs.y - EditPolygonImageView.this.medianY, lhs.x - EditPolygonImageView.this.medianX), Math.atan2(rhs.y - EditPolygonImageView.this.medianY, rhs.x - EditPolygonImageView.this.medianX));
            }
        };
        this.pointsQueue = new PriorityQueue<PointF>(4, comparator2);
        this.imageMatrix = new float[9];
        this.touchRect = new RectF();
        this.lastKnownImageWidth = -1;
        this.lastKnownImageHeight = -1;
        this.scaleLandscape = 1.0f;
        this.scalePortrait = 1.0f;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        EditPolygonImageView editPolygonImageView = this;
        typedArray = typedArray.getTheme().obtainStyledAttributes((AttributeSet)h2, R.styleable.EditPolygonImageView, 0, 0);
        try {
            this.edgeColor = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            this.edgeColorOnLine = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColorOnLine, this.edgeColor);
            this.cornerDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            this.edgeDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            this.magneticLineTreshold = typedArray.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            this.polygonStrokeWidth = typedArray.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.handleSize = typedArray.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
        editPolygonImageView.polygon = Collections.emptyList();
        editPolygonImageView.paint = new Paint();
        editPolygonImageView.paint.setColor(this.edgeColor);
        editPolygonImageView.paint.setStyle(Paint.Style.STROKE);
        editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paint.setAntiAlias(true);
        editPolygonImageView.paint.setStrokeCap(Paint.Cap.SQUARE);
        editPolygonImageView.paintOnLine = new Paint();
        editPolygonImageView.paintOnLine.setColor(this.edgeColorOnLine);
        editPolygonImageView.paintOnLine.setStyle(Paint.Style.STROKE);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paintOnLine.setAntiAlias(true);
        editPolygonImageView.paintOnLine.setStrokeCap(Paint.Cap.SQUARE);
        editPolygonImageView.handlePaint = new Paint();
        editPolygonImageView.handlePaint.setAntiAlias(true);
        editPolygonImageView.handlePaint.setFilterBitmap(true);
        editPolygonImageView.polygonHelper = new PolygonHelper();
        editPolygonImageView.corners = new ArrayList<PointF>();
        for (n2 = 0; n2 < 4; ++n2) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<h>();
        n2 = 0;
        while (n2 < this.corners.size()) {
            h h3;
            h2 = h3;
            h2();
            h.a(h2, this.corners.get(n2));
            int n3 = n2 + 1;
            h.b(h2, this.corners.get(n3 % 4));
            h.c(h2, this.corners.get((n2 + 3) % 4));
            h.d(h3, this.corners.get((n2 + 2) % 4));
            this.edges.add(h2);
            n2 = n3;
        }
        return;
    }

    private float getRotationScale(float currentRotation, float rotateBy) {
        if (Math.abs((currentRotation + rotateBy) % 360.0f) / 90.0f % 2.0f == 0.0f) {
            return this.scalePortrait;
        }
        return this.scaleLandscape;
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        void var3_3;
        void var2_2;
        void var1_1;
        canvas.save();
        if (degrees != 0.0f) {
            void var4_4;
            var1_1.rotate((float)var4_4, var2_2.x, var2_2.y);
        }
        void v0 = var1_1;
        EditPolygonImageView editPolygonImageView = this;
        float f2 = 1.0f / editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), 0.0f);
        var1_1.scale(f2, f2, var2_2.x, var2_2.y);
        v0.drawBitmap((Bitmap)var3_3, var2_2.x - (float)(var3_3.getWidth() >> 1), var2_2.y - (float)(var3_3.getHeight() >> 1), this.handlePaint);
        v0.restore();
    }

    private void keepInsideView(PointF point) {
        PointF pointF = point;
        pointF.set(Math.max(0.0f, Math.min(pointF.x, (float)this.getWidth() - this.offsetX * 2.0f)), Math.max(0.0f, Math.min(point.y, (float)this.getHeight() - this.offsetY * 2.0f)));
    }

    private void restoreSelectedEdge() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.selectedEdge.a.set(this.tmpPointA);
        editPolygonImageView.selectedEdge.b.set(this.tmpPointB);
        editPolygonImageView.selectedEdge.e.a(this.selectedEdge.a, this.selectedEdge.b);
    }

    private void ensureNoPolygonIntersection() {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.calculateMedian();
        if (editPolygonImageView.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            float f4 = f3;
            PointF pointF = this.corners.get(i2);
            f3 = f2 + pointF.x;
            f2 = f4 + pointF.y;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        int n2 = 0;
        while (n2 < 4) {
            h h2 = this.edges.get(n2);
            h.a(h2, this.corners.get(n2));
            int n3 = n2 + 1;
            h.b(h2, this.corners.get(n3 % 4));
            h.c(h2, this.corners.get((n2 + 3) % 4));
            h.d(h2, this.corners.get((n2 + 2) % 4));
            n2 = n3;
        }
    }

    private void onImageSizeUpdated() {
        if (this.getDrawable() != null) {
            float f2;
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.offsetX = 0.0f;
            editPolygonImageView.offsetY = 0.0f;
            editPolygonImageView.getImageMatrix().getValues(this.imageMatrix);
            Drawable drawable = editPolygonImageView.getDrawable();
            int n2 = drawable.getIntrinsicHeight();
            float f3 = drawable.getIntrinsicWidth();
            EditPolygonImageView editPolygonImageView2 = this;
            float f4 = f3 * this.getScaleX();
            float f5 = n2;
            float f6 = f5 * this.getScaleY();
            RectF rectF = new RectF(0.0f, 0.0f, f4, f6);
            editPolygonImageView2.scalePortrait = io.scanbot.sdk.b.a.a((View)editPolygonImageView2, 0.0f, rectF) * this.getScaleX();
            editPolygonImageView2.scaleLandscape = io.scanbot.sdk.b.a.a((View)editPolygonImageView2, 90.0f, rectF) * this.getScaleY();
            if (f2 * editPolygonImageView2.scalePortrait < (float)this.getWidth()) {
                this.offsetX = this.getWidth() - (int)(f3 * this.scalePortrait) >> 1;
            }
            if (f5 * this.scalePortrait < (float)this.getHeight()) {
                this.offsetY = this.getHeight() - (int)(f5 * this.scalePortrait) >> 1;
            }
            EditPolygonImageView editPolygonImageView3 = this;
            f4 = this.scalePortrait;
            editPolygonImageView3.polygonHelper.setImageSize((int)(f3 * f4), (int)(f5 * f4));
            editPolygonImageView3.scaleLandscape /= this.scalePortrait;
            editPolygonImageView3.scalePortrait = 1.0f;
            if (editPolygonImageView3.getRotation() / 90.0f % 2.0f == 1.0f) {
                EditPolygonImageView editPolygonImageView4 = this;
                editPolygonImageView4.setScaleX(editPolygonImageView4.scaleLandscape);
                editPolygonImageView4.setScaleY(editPolygonImageView4.scaleLandscape);
            }
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    static /* synthetic */ List access$702(EditPolygonImageView x0, List x1) {
        x0.polygon = x1;
        return x1;
    }

    protected void onAttachedToWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onAttachedToWindow();
        editPolygonImageView.cornerBitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.cornerDrawable);
        editPolygonImageView.edgeBitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        EditPolygonImageView editPolygonImageView = this;
        super.onDetachedFromWindow();
        editPolygonImageView.cornerBitmap.recycle();
        editPolygonImageView.edgeBitmap.recycle();
        editPolygonImageView.editPolygonAnimationEndListener = null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        EditPolygonImageView editPolygonImageView = this;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        editPolygonImageView.onImageSizeUpdated();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setPolygon(final List<PointF> polygon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!polygon.isEmpty()) {
                    d d2 = this;
                    EditPolygonImageView.access$702(d2.EditPolygonImageView.this, polygon);
                    if (!d2.EditPolygonImageView.this.corners.isEmpty()) {
                        EditPolygonImageView.this.polygonHelper.getDrawingPolygon(polygon, EditPolygonImageView.this.corners);
                    }
                    EditPolygonImageView.this.invalidate();
                }
            }
        });
    }

    public List<PointF> getPolygon() {
        if (!this.corners.isEmpty() && !this.polygon.isEmpty()) {
            this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        }
        return this.polygon;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(float rotation) {
        void var1_1;
        if (rotation % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        float f2 = editPolygonImageView.getRotation() - var1_1;
        f2 = editPolygonImageView.getRotationScale(editPolygonImageView.getRotation(), f2);
        MagnifierView magnifierView = editPolygonImageView.magnifierView;
        if (magnifierView != null) {
            magnifierView.setImageRotation((float)var1_1);
        }
        EditPolygonImageView editPolygonImageView2 = this;
        this.setScaleX(f2);
        editPolygonImageView2.setScaleY(f2);
        editPolygonImageView2.invalidate();
        super.setRotation((float)var1_1);
    }

    public void setLines(final List<Line2D> horizontalLines, final List<Line2D> verticalLines) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList;
                Object object;
                Object object22;
                ArrayList<Line2D> arrayList2;
                Iterator<Line2D> iterator = arrayList2;
                arrayList2 = new ArrayList<Line2D>(horizontalLines.size());
                for (Object object22 : horizontalLines) {
                    iterator.add(new Line2D(new PointF(object22.getStart().x, object22.getStart().y), new PointF(object22.getEnd().x, object22.getEnd().y)));
                }
                e e2 = this;
                e2.EditPolygonImageView.this.horizontalLines2D.clear();
                e2.EditPolygonImageView.this.horizontalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines((List<Line2D>)((Object)iterator)));
                e2.EditPolygonImageView.this.horizontalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    i i2;
                    object = (Line2D)iterator.next();
                    object22 = i2;
                    object22();
                    i2.a(object.getStart(), object.getEnd());
                    EditPolygonImageView.this.horizontalLines.add(object22);
                }
                iterator = arrayList;
                arrayList = new ArrayList(verticalLines.size());
                for (Object object22 : verticalLines) {
                    iterator.add(new Line2D(new PointF(object22.getStart().x, object22.getStart().y), new PointF(object22.getEnd().x, object22.getEnd().y)));
                }
                e e3 = this;
                e3.EditPolygonImageView.this.verticalLines2D.clear();
                e3.EditPolygonImageView.this.verticalLines2D.addAll(EditPolygonImageView.this.polygonHelper.scaleLines((List<Line2D>)((Object)iterator)));
                e3.EditPolygonImageView.this.verticalLines.clear();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    i i3;
                    object = (Line2D)iterator.next();
                    object22 = i3;
                    object22();
                    i3.a(object.getStart(), object.getEnd());
                    EditPolygonImageView.this.verticalLines.add(object22);
                }
            }
        });
    }

    public void setEdgeColor(int color2) {
        this.paint.setColor(color2);
    }

    public void setEdgeColorOnLine(int color2) {
        this.paintOnLine.setColor(color2);
    }

    public void setEdgeWidth(float width) {
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.polygonStrokeWidth = width;
        editPolygonImageView.paint.setStrokeWidth(this.polygonStrokeWidth);
        editPolygonImageView.paintOnLine.setStrokeWidth(this.polygonStrokeWidth);
    }

    public void rotateClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, 90.0f);
        editPolygonImageView.animate().rotationBy(90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    public void rotateCounterClockwise() {
        float f2 = this.getRotation();
        if (f2 % 90.0f != 0.0f) {
            return;
        }
        EditPolygonImageView editPolygonImageView = this;
        f2 = editPolygonImageView.getRotationScale(f2, -90.0f);
        editPolygonImageView.animate().rotationBy(-90.0f).scaleX(f2).scaleY(f2).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (EditPolygonImageView.this.magnifierView != null) {
                    EditPolygonImageView.this.magnifierView.setImageRotation(EditPolygonImageView.this.getRotation());
                }
                if (EditPolygonImageView.this.editPolygonAnimationEndListener != null) {
                    EditPolygonImageView.this.editPolygonAnimationEndListener.onAnimationEnded();
                }
                EditPolygonImageView.this.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        EditPolygonImageView editPolygonImageView = this;
        super.dispatchDraw(canvas);
        editPolygonImageView.checkWhetherImageSizeUpdated();
        if (!editPolygonImageView.polygon.isEmpty()) {
            void var1_1;
            var1_1.save();
            var1_1.translate(this.offsetX, this.offsetY);
            for (h h2 : this.edges) {
                float f2 = ((h)h2).a.x;
                float f3 = ((h)h2).a.y;
                float f4 = ((h)h2).b.x;
                float f5 = ((h)h2).b.y;
                Paint paint = h2.k ? this.paintOnLine : this.paint;
                var1_1.drawLine(f2, f3, f4, f5, paint);
            }
            Object object = this.selectedCorner;
            if (object != null) {
                this.drawHandle((Canvas)var1_1, (PointF)object, this.cornerBitmap, 0.0f);
                var1_1.save();
                var1_1.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    PointF pointF;
                    object = pointF;
                    pointF = new PointF(this.selectedCorner.x / ((float)this.getWidth() - this.offsetX * 2.0f), this.selectedCorner.y / ((float)this.getHeight() - this.offsetY * 2.0f));
                    this.magnifierView.drawMagnifier((PointF)object);
                }
                var1_1.restore();
            } else {
                object = this.selectedEdge;
                if (object != null) {
                    this.drawHandle((Canvas)var1_1, ((h)object).b(), this.edgeBitmap, this.selectedEdge.a());
                } else {
                    for (h h3 : this.edges) {
                        this.drawHandle((Canvas)var1_1, h3.b(), this.edgeBitmap, h3.a());
                    }
                    object = this.corners.iterator();
                    while (object.hasNext()) {
                        this.drawHandle((Canvas)var1_1, (PointF)object.next(), this.cornerBitmap, 0.0f);
                    }
                }
            }
            var1_1.restore();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent event) {
        Line2D line2D;
        double d2;
        float f2;
        MagnifierView magnifierView;
        block20: {
            switch (event.getAction()) {
                default: {
                    return super.onTouchEvent((MotionEvent)magnifierView);
                }
                case 2: {
                    PointF pointF = this.selectedCorner;
                    if (pointF != null) {
                        EditPolygonImageView editPolygonImageView = this;
                        pointF.set(magnifierView.getX() - this.offsetX, magnifierView.getY() - this.offsetY);
                        editPolygonImageView.keepInsideView(editPolygonImageView.selectedCorner);
                        editPolygonImageView.ensureNoPolygonIntersection();
                        editPolygonImageView.invalidate();
                        return true;
                    }
                    if (this.selectedEdge == null) return true;
                    EditPolygonImageView editPolygonImageView = this;
                    MagnifierView magnifierView2 = magnifierView;
                    float f3 = magnifierView2.getX() - this.selectedEdge.i;
                    f2 = magnifierView2.getY() - this.selectedEdge.j;
                    editPolygonImageView.finger.offset(f3, f2);
                    editPolygonImageView.tmpPointA.set(this.selectedEdge.a);
                    editPolygonImageView.tmpPointB.set(this.selectedEdge.b);
                    d2 = Double.MAX_VALUE;
                    line2D = null;
                    if (editPolygonImageView.selectedEdge.c()) {
                        break;
                    }
                    for (int i2 = 0; i2 < this.verticalLines.size(); ++i2) {
                        double d3;
                        double d4 = this.verticalLines.get(i2).a(this.finger);
                        if (d3 < d2) {
                            line2D = this.verticalLines2D.get(i2);
                        } else {
                            d4 = d2;
                        }
                        d2 = d4;
                    }
                    break block20;
                }
                case 1: 
                case 3: {
                    this.selectedCorner = null;
                    this.selectedEdge = null;
                    magnifierView = this.magnifierView;
                    if (magnifierView != null) {
                        magnifierView.eraseMagnifier();
                    }
                    this.invalidate();
                    return true;
                }
                case 0: {
                    h h2;
                    PointF pointF;
                    EditPolygonImageView editPolygonImageView = this;
                    int n2 = editPolygonImageView.handleSize >> 1;
                    float f4 = n2;
                    editPolygonImageView.touchRect.set(magnifierView.getX() - this.offsetX - f4, magnifierView.getY() - this.offsetY - f4, magnifierView.getX() - this.offsetX + f4, magnifierView.getY() - this.offsetY + f4);
                    for (PointF pointF2 : editPolygonImageView.corners) {
                        if (!this.touchRect.contains(pointF2.x, pointF2.y)) continue;
                        this.selectedCorner = pointF2;
                        this.invalidate();
                        return true;
                    }
                    Iterator<Object> iterator = this.edges.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        h2 = (h)iterator.next();
                        pointF = h2.b();
                    } while (!this.touchRect.contains(pointF.x, pointF.y));
                    EditPolygonImageView editPolygonImageView2 = this;
                    h h3 = this.selectedEdge = h2;
                    h.a(h2, magnifierView.getX());
                    h.b(h3, magnifierView.getY());
                    h3.f.a(h2.a, h2.c);
                    h3.g.a(h2.b, h2.d);
                    editPolygonImageView2.finger.set(pointF);
                    editPolygonImageView2.invalidate();
                    return true;
                }
            }
            for (int i3 = 0; i3 < this.horizontalLines.size(); ++i3) {
                double d5;
                double d6 = this.horizontalLines.get(i3).a(this.finger);
                if (d5 < d2) {
                    line2D = this.horizontalLines2D.get(i3);
                } else {
                    d6 = d2;
                }
                d2 = d6;
            }
        }
        if (line2D != null && d2 < (double)this.magneticLineTreshold) {
            EditPolygonImageView editPolygonImageView = this;
            editPolygonImageView.selectedEdge.a.set(line2D.getStart());
            editPolygonImageView.selectedEdge.b.set(line2D.getEnd());
            h.a(editPolygonImageView.selectedEdge, true);
        } else {
            EditPolygonImageView editPolygonImageView = this;
            h.a(editPolygonImageView.selectedEdge, false);
            PointF pointF = editPolygonImageView.selectedEdge.b();
            PointF pointF3 = editPolygonImageView.finger;
            f2 = pointF3.x - pointF.x;
            float f5 = pointF3.y - pointF.y;
            editPolygonImageView.selectedEdge.a.offset(f2, f5);
            editPolygonImageView.selectedEdge.b.offset(f2, f5);
        }
        EditPolygonImageView editPolygonImageView = this;
        editPolygonImageView.selectedEdge.e.a(this.selectedEdge.a, this.selectedEdge.b);
        PointF pointF = editPolygonImageView.selectedEdge.e.a(this.selectedEdge.f);
        if (!Float.isNaN(pointF.x) && !Float.isNaN(pointF.y)) {
            EditPolygonImageView editPolygonImageView3 = this;
            editPolygonImageView3.selectedEdge.a.set(pointF);
            pointF = editPolygonImageView3.selectedEdge.e.a(this.selectedEdge.g);
            if (!Float.isNaN(pointF.x) && !Float.isNaN(pointF.y)) {
                EditPolygonImageView editPolygonImageView4 = this;
                editPolygonImageView4.selectedEdge.b.set(pointF);
                editPolygonImageView4.keepInsideView(editPolygonImageView4.selectedEdge.a);
                editPolygonImageView4.keepInsideView(editPolygonImageView4.selectedEdge.b);
                h.a(editPolygonImageView4.selectedEdge, magnifierView.getX());
                h.b(editPolygonImageView4.selectedEdge, magnifierView.getY());
                editPolygonImageView4.invalidate();
                return true;
            }
            this.restoreSelectedEdge();
            return false;
        }
        this.restoreSelectedEdge();
        return false;
    }

    void setMagnifier(MagnifierView magnifier) {
        this.magnifierView = magnifier;
        this.invalidate();
    }

    public void setEditPolygonAnimationEndListener(EditPolygonAnimationEndListener editPolygonAnimationEndListener) {
        this.editPolygonAnimationEndListener = editPolygonAnimationEndListener;
    }

    public static interface EditPolygonAnimationEndListener {
        public void onAnimationEnded();
    }

    private class i {
        private double a;
        private double b;
        private double c;
        private PointF d = new PointF();

        private i() {
        }

        PointF a(i line) {
            PointF pointF = this_.d;
            i i2 = this_;
            double d2 = i2.c;
            double d3 = line.b;
            double d4 = d2 * d3;
            double d5 = i2.b;
            double this_ = line.c;
            double d6 = line.a;
            double d7 = d5 * d6;
            double d8 = i2.a;
            pointF.x = (float)((d4 -= d5 * this_) / (d7 - d8 * d3));
            pointF.y = (float)((d8 * this_ - d2 * d6) / (d5 * d6 - d8 * d3));
            return pointF;
        }

        void a(PointF start2, PointF end2) {
            float start2 = start2.y;
            float end2 = end2.y;
            this.a = start2 - end2;
            float f2 = end2.x;
            float f3 = start2.x;
            this.b = f2 - f3;
            this.c = (f3 - f2) * start2 + (end2 - start2) * f3;
        }

        /*
         * WARNING - void declaration
         */
        double a(PointF point) {
            void var1_1;
            if (this.a == 0.0 && this.b == 0.0) {
                return 0.0;
            }
            double d2 = this.a;
            double d3 = this.b;
            return Math.abs(this.a * (double)var1_1.x + this.b * (double)var1_1.y + this.c) / Math.sqrt(d2 * d2 + d3 * d3);
        }
    }

    private class h {
        private PointF a;
        private PointF b;
        private PointF c;
        private PointF d;
        private i e;
        private i f;
        private i g;
        private PointF h;
        private float i;
        private float j;
        private boolean k;

        private h() {
            this.e = new i();
            this.f = new i();
            this.g = new i();
            this.h = new PointF();
            this.k = false;
        }

        static /* synthetic */ PointF a(h x0, PointF x1) {
            x0.a = x1;
            return x1;
        }

        static /* synthetic */ PointF b(h x0, PointF x1) {
            x0.b = x1;
            return x1;
        }

        static /* synthetic */ PointF c(h x0, PointF x1) {
            x0.c = x1;
            return x1;
        }

        static /* synthetic */ PointF d(h x0, PointF x1) {
            x0.d = x1;
            return x1;
        }

        static /* synthetic */ float a(h x0, float x1) {
            x0.i = x1;
            return x1;
        }

        static /* synthetic */ float b(h x0, float x1) {
            x0.j = x1;
            return x1;
        }

        static /* synthetic */ boolean a(h x0, boolean x1) {
            x0.k = x1;
            return x1;
        }

        float a() {
            PointF pointF = this22.b;
            h this22 = this22.a;
            float this22 = pointF.x - ((PointF)this22).x;
            return (float)(Math.toDegrees(Math.atan2(pointF.y - ((PointF)this22).y, this22)) + 90.0);
        }

        PointF b() {
            PointF pointF = this_.a;
            h this_ = this_.b;
            this_.h.x = (pointF.x + ((PointF)this_).x) / 2.0f;
            this_.h.y = (pointF.y + ((PointF)this_).y) / 2.0f;
            return this_.h;
        }

        boolean c() {
            PointF pointF = this_.b;
            h this_ = this_.a;
            float f2 = pointF.y - ((PointF)this_).y;
            return Math.abs(pointF.x - ((PointF)this_).x) > Math.abs(f2);
        }
    }
}

