/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.content.Context;
import android.graphics.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.aztec.AztecReader;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.maxicode.MaxiCodeReader;
import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEReader;
import com.google.zxing.oned.rss.RSS14Reader;
import com.google.zxing.oned.rss.expanded.RSSExpandedReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ZXingBarcodeDetector$WhenMappings;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.c.c;
import net.doo.snap.util.YUVUtil;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J2\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J%\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0 H\u0002\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020\u00192\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0*H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/barcode/ZXingBarcodeDetector;", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "barcodeScanEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "reader", "Lcom/google/zxing/Reader;", "sapManager", "Lio/scanbot/sap/SapManager;", "decodeWithState", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "data", "", "width", "", "height", "frameOrientation", "finderRect", "Landroid/graphics/Rect;", "enableBarcodeScan", "", "", "getAppFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "zxingBarcodeFormat", "Lcom/google/zxing/BarcodeFormat;", "getCornerPoints", "", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "cornerPoints", "Lcom/google/zxing/ResultPoint;", "([Lcom/google/zxing/ResultPoint;)[Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getFormat", "barcodeFormat", "reinitReader", "setBarcodeFormatsFilter", "barcodeFormats", "", "scanbot-sdk_release"})
public final class ZXingBarcodeDetector
implements ScanbotBarcodeDetector {
    private final Logger logger;
    private Reader reader;
    private final SapManager sapManager;
    private final AtomicBoolean barcodeScanEnabled;

    private final com.google.zxing.BarcodeFormat getFormat(BarcodeFormat barcodeFormat) {
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$0[barcodeFormat.ordinal()]) {
            default: {
                return null;
            }
            case 17: {
                return com.google.zxing.BarcodeFormat.UPC_EAN_EXTENSION;
            }
            case 16: {
                return com.google.zxing.BarcodeFormat.UPC_E;
            }
            case 15: {
                return com.google.zxing.BarcodeFormat.UPC_A;
            }
            case 14: {
                return com.google.zxing.BarcodeFormat.RSS_EXPANDED;
            }
            case 13: {
                return com.google.zxing.BarcodeFormat.RSS_14;
            }
            case 12: {
                return com.google.zxing.BarcodeFormat.QR_CODE;
            }
            case 11: {
                return com.google.zxing.BarcodeFormat.PDF_417;
            }
            case 10: {
                return com.google.zxing.BarcodeFormat.MAXICODE;
            }
            case 9: {
                return com.google.zxing.BarcodeFormat.ITF;
            }
            case 8: {
                return com.google.zxing.BarcodeFormat.EAN_13;
            }
            case 7: {
                return com.google.zxing.BarcodeFormat.EAN_8;
            }
            case 6: {
                return com.google.zxing.BarcodeFormat.DATA_MATRIX;
            }
            case 5: {
                return com.google.zxing.BarcodeFormat.CODE_128;
            }
            case 4: {
                return com.google.zxing.BarcodeFormat.CODE_93;
            }
            case 3: {
                return com.google.zxing.BarcodeFormat.CODE_39;
            }
            case 2: {
                return com.google.zxing.BarcodeFormat.CODABAR;
            }
            case 1: 
        }
        return com.google.zxing.BarcodeFormat.AZTEC;
    }

    /*
     * WARNING - void declaration
     */
    private final ResultPoint[] getCornerPoints(com.google.zxing.ResultPoint[] cornerPoints) {
        ArrayList arrayList;
        ResultPoint[] this_ = arrayList;
        arrayList = new ArrayList();
        int n2 = cornerPoints.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            void var4_4 = var1_1[i2];
            if (var4_4 != null) {
                this_.add(new ResultPoint(var4_4.getX(), var4_4.getY()));
                continue;
            }
            this_.add(null);
        }
        if ((this_ = this_.toArray(new ResultPoint[0])) != null) {
            return this_;
        }
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    /*
     * WARNING - void declaration
     */
    private final BarcodeFormat getAppFormat(com.google.zxing.BarcodeFormat zxingBarcodeFormat) {
        void var1_1;
        if (zxingBarcodeFormat == null) {
            return BarcodeFormat.UNKNOWN;
        }
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$1[var1_1.ordinal()]) {
            default: {
                return BarcodeFormat.UNKNOWN;
            }
            case 17: {
                return BarcodeFormat.UPC_EAN_EXTENSION;
            }
            case 16: {
                return BarcodeFormat.UPC_E;
            }
            case 15: {
                return BarcodeFormat.UPC_A;
            }
            case 14: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 13: {
                return BarcodeFormat.RSS_14;
            }
            case 12: {
                return BarcodeFormat.QR_CODE;
            }
            case 11: {
                return BarcodeFormat.PDF_417;
            }
            case 10: {
                return BarcodeFormat.MAXICODE;
            }
            case 9: {
                return BarcodeFormat.ITF;
            }
            case 8: {
                return BarcodeFormat.EAN_13;
            }
            case 7: {
                return BarcodeFormat.EAN_8;
            }
            case 6: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 5: {
                return BarcodeFormat.CODE_128;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 3: {
                return BarcodeFormat.CODE_39;
            }
            case 2: {
                return BarcodeFormat.CODABAR;
            }
            case 1: 
        }
        return BarcodeFormat.AZTEC;
    }

    private final void reinitReader(BarcodeFormat barcodeFormat) {
        switch (ZXingBarcodeDetector$WhenMappings.$EnumSwitchMapping$2[barcodeFormat.ordinal()]) {
            default: {
                break;
            }
            case 19: {
                this.reader = new MultiFormatReader();
                break;
            }
            case 18: {
                this.reader = new MultiFormatUPCEANReader(null);
                break;
            }
            case 17: {
                this.reader = new UPCEReader();
                break;
            }
            case 16: {
                this.reader = new UPCAReader();
                break;
            }
            case 15: {
                this.reader = new RSSExpandedReader();
                break;
            }
            case 14: {
                this.reader = new RSS14Reader();
                break;
            }
            case 13: {
                this.reader = new QRCodeReader();
                break;
            }
            case 12: {
                this.reader = new PDF417Reader();
                break;
            }
            case 11: {
                this.reader = new MaxiCodeReader();
                break;
            }
            case 10: {
                this.reader = new ITFReader();
                break;
            }
            case 9: {
                this.reader = new EAN13Reader();
                break;
            }
            case 8: {
                this.reader = new EAN8Reader();
                break;
            }
            case 7: {
                this.reader = new DataMatrixReader();
                break;
            }
            case 6: {
                this.reader = new Code128Reader();
                break;
            }
            case 5: {
                this.reader = new Code93Reader();
                break;
            }
            case 4: {
                this.reader = new Code39Reader();
                break;
            }
            case 3: {
                this.reader = new CodaBarReader();
                break;
            }
            case 2: {
                this.reader = new AztecReader();
                break;
            }
            case 1: {
                this.reader = new MultiFormatReader();
            }
        }
    }

    @Inject
    public ZXingBarcodeDetector(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = LoggerProvider.getLogger();
        this.barcodeScanEnabled = new AtomicBoolean(true);
        this.reader = new MultiFormatReader();
        SapManager sapManager = c.a();
        Intrinsics.checkExpressionValueIsNotNull((Object)sapManager, (String)"SapSingleton.getInstance()");
        this.sapManager = sapManager;
    }

    @Override
    public void enableBarcodeScan(boolean barcodeScanEnabled) {
        this.barcodeScanEnabled.set(barcodeScanEnabled);
    }

    @Override
    public synchronized void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        HashMap hashMap;
        List<? extends BarcodeFormat> list = barcodeFormats;
        Intrinsics.checkParameterIsNotNull(list, (String)"barcodeFormats");
        if (list.isEmpty()) {
            this.reader = new MultiFormatReader();
        } else if (hashMap.size() == 1) {
            this.reinitReader((BarcodeFormat)((Object)hashMap.get(0)));
        } else {
            ArrayList<com.google.zxing.BarcodeFormat> arrayList;
            HashMap hashMap2;
            void v1 = hashMap;
            hashMap = hashMap2;
            hashMap2 = new HashMap();
            ArrayList<com.google.zxing.BarcodeFormat> arrayList2 = arrayList;
            arrayList = new ArrayList<com.google.zxing.BarcodeFormat>();
            Iterator iterator = v1.iterator();
            while (iterator.hasNext()) {
                com.google.zxing.BarcodeFormat barcodeFormat = this.getFormat((BarcodeFormat)((Object)iterator.next()));
                if (barcodeFormat == null) continue;
                arrayList2.add(barcodeFormat);
            }
            hashMap.put(DecodeHintType.POSSIBLE_FORMATS, arrayList2);
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            multiFormatReader.setHints(hashMap);
            this.reader = multiFormatReader;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation) {
        block20: {
            block19: {
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                    return null;
                }
                if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
                    return null;
                }
                v0 = var4_6;
                var1_1 /* !! */  = YUVUtil.rotateYUV21Image((int)v0, var1_1 /* !! */ , (int)var2_3, (int)var3_5);
                if (v0 % 180 == false) {
                    var4_7 = v1;
                    v1 = new PlanarYUVLuminanceSource(var1_1 /* !! */ , (int)var2_3, (int)var3_5, 0, 0, (int)var2_3, (int)var3_5, false);
                } else {
                    var4_7 = v2;
                    v2 = new PlanarYUVLuminanceSource(var1_1 /* !! */ , (int)var3_5, (int)var2_3, 0, 0, (int)var3_5, (int)var2_3, false);
                }
                v3 = this;
                var1_1 /* !! */  = (byte[])v4;
                v4 = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)var4_7));
                if (!(v3.reader instanceof MultiFormatReader)) ** GOTO lbl28
                var2_4 = this.reader;
                if (var2_4 == null) throw new TypeCastException("null cannot be cast to non-null type com.google.zxing.MultiFormatReader");
                v5 = ((MultiFormatReader)var2_4).decodeWithState((BinaryBitmap)var1_1 /* !! */ );
                var1_1 /* !! */  = (byte[])v5;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(reader as MultiFormatRe\u2026).decodeWithState(bitmap)");
                break block19;
lbl28:
                // 1 sources

                v6 = this.reader.decode((BinaryBitmap)var1_1 /* !! */ );
                var1_1 /* !! */  = (byte[])v6;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"reader.decode(bitmap)");
            }
            v7 = v8;
            v9 = this;
            v10 = v11;
            v12 = v11;
            v13 = var1_1 /* !! */ .getText();
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"result.text");
                v14 = var1_1 /* !! */ .getRawBytes();
                v15 = var1_1 /* !! */ .getResultPoints();
                Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"result.resultPoints");
                v10(v13, v14, this.getCornerPoints(v15), this.getAppFormat(var1_1 /* !! */ .getBarcodeFormat()), null, 16, null);
                v7(CollectionsKt.listOf((Object)v12), 0L, 2, null);
            }
            catch (FormatException v18) {
                break block20;
            }
            catch (NotFoundException v19) {}
            v9.reader.reset();
            return v8;
            {
                catch (Throwable v16) {}
                catch (ChecksumException var1_2) {}
                {
                    v17 = this;
                    v17.logger.d("ZXingBarcodeDetector", var1_2.getMessage());
                    v17.reader.reset();
                }
            }
            break block20;
            finally {
                return null;
            }
        }
        this.reader.reset();
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public synchronized BarcodeScanningResult decodeWithState(@NotNull byte[] data, int width, int height, int frameOrientation, @NotNull Rect finderRect) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
                        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
                            return null;
                        }
                        if (!this.sapManager.checkLicenseStatus(SdkFeature.Barcode).booleanValue()) {
                            return null;
                        }
                        v0 = var4_5;
                        var1_1 /* !! */  = YUVUtil.rotateYUV21Image((int)v0, var1_1 /* !! */ , (int)var2_2, (int)var3_4);
                        if (v0 % 180 != false) break block16;
                        var4_6 = v1;
                        v1 = new PlanarYUVLuminanceSource(var1_1 /* !! */ , (int)var2_2, (int)var3_4, var5_7.left, var5_7.top, var5_7.width(), var5_7.height(), false);
                        ** GOTO lbl19
                    }
                    var4_6 = v2;
                    v2 = new PlanarYUVLuminanceSource(var1_1 /* !! */ , (int)var3_4, (int)var2_2, var5_7.left, var5_7.top, var5_7.width(), var5_7.height(), false);
lbl19:
                    // 2 sources

                    v3 = this;
                    var1_1 /* !! */  = (byte[])v4;
                    v4 = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)var4_6));
                    if (!(v3.reader instanceof MultiFormatReader)) ** GOTO lbl32
                    var2_3 = this.reader;
                    if (var2_3 == null) throw new TypeCastException("null cannot be cast to non-null type com.google.zxing.MultiFormatReader");
                    v5 = ((MultiFormatReader)var2_3).decodeWithState((BinaryBitmap)var1_1 /* !! */ );
                    var1_1 /* !! */  = (byte[])v5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"(reader as MultiFormatRe\u2026r).decodeWithState(image)");
                    break block17;
lbl32:
                    // 1 sources

                    v6 = this.reader.decode((BinaryBitmap)var1_1 /* !! */ );
                    var1_1 /* !! */  = (byte[])v6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"reader.decode(image)");
                }
                v7 = v8;
                v9 = this;
                v10 = v11;
                v12 = v11;
                v13 = var1_1 /* !! */ .getText();
                try {
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"result.text");
                    v14 = var1_1 /* !! */ .getRawBytes();
                    v15 = var1_1 /* !! */ .getResultPoints();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"result.resultPoints");
                    v10(v13, v14, this.getCornerPoints(v15), this.getAppFormat(var1_1 /* !! */ .getBarcodeFormat()), null, 16, null);
                    v7(CollectionsKt.listOf((Object)v12), 0L, 2, null);
                }
                catch (FormatException v19) {
                    break block19;
                }
                catch (NotFoundException v20) {}
                v9.reader.reset();
                return v8;
                {
                    catch (Throwable v16) {
                        break block18;
                    }
                    catch (ChecksumException v17) {}
                    {
                        v18 = this;
                        v18.logger.d("ZXingBarcodeDetector", "ChecksumException: barcode detected and decoded, but its checksum feature failed.");
                        v18.reader.reset();
                        return null;
                    }
                }
            }
            this.reader.reset();
            throw v16;
        }
        this.reader.reset();
        return null;
    }
}

