/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.payformscanner;

import android.content.Context;
import io.scanbot.payformscanner.PayFormScanner;
import io.scanbot.sap.SapManager;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.payformscanner.PayFormScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class PayFormScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private PayFormScanner payFormScanner;
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private boolean enabled;

    public static PayFormScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, PayFormScanner payFormScanner) {
        PayFormScannerFrameHandler payFormScannerFrameHandler;
        PayFormScannerFrameHandler payFormScannerFrameHandler2 = payFormScannerFrameHandler;
        payFormScannerFrameHandler2(scanbotCameraView.getContext(), payFormScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(payFormScannerFrameHandler2);
        return payFormScannerFrameHandler;
    }

    public PayFormScannerFrameHandler(Context context, PayFormScanner payFormScanner) {
        PayFormScannerFrameHandler payFormScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        payFormScannerFrameHandler.payFormScanner = payFormScanner;
        payFormScannerFrameHandler.sapManager = c.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean notifyHandlers(PayFormScanner.DetectionResult detectionResult) {
        PayFormScannerFrameHandler payFormScannerFrameHandler = this;
        boolean bl = false;
        Set<ResultHandler> set = payFormScannerFrameHandler.handlers;
        synchronized (set) {
            Iterator<ResultHandler> iterator = payFormScannerFrameHandler.handlers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return bl;
                }
                bl |= iterator.next().handleResult(detectionResult);
            }
        }
    }

    @Override
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame frame) {
        PayFormScannerFrameHandler payFormScannerFrameHandler = this;
        payFormScannerFrameHandler.logger.logMethod();
        if (!payFormScannerFrameHandler.enabled) {
            return false;
        }
        if (this.sapManager.isLicenseActive()) {
            PayFormScannerFrameHandler payFormScannerFrameHandler2 = this;
            return payFormScannerFrameHandler2.notifyHandlers(payFormScannerFrameHandler2.payFormScanner.preVerifyForm(frame.frame, frame.width, frame.height, frame.frameOrientation));
        }
        throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(PayFormScanner.DetectionResult var1);
    }
}

