/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.entity.Blob;
import net.doo.snap.entity.Language;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

public class BlobManager {
    private final BlobStoreStrategy blobStoreStrategy;
    private final AssetManager assetManager;
    private final BlobFactory blobFactory;
    private final Logger logger = LoggerProvider.getLogger();

    @Inject
    public BlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        this.blobStoreStrategy = blobStoreStrategy;
        this.assetManager = assetManager;
        this.blobFactory = blobFactory;
    }

    private long copyFromAssets(Blob blob, Uri uri) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)this.assetManager.open(uri.getPath()), (File)new File(blob.getLocalPath()));
        return -1L;
    }

    private void ensureDirectoryCreated(Blob blob) throws IOException {
        File file = new File(blob.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create destination directory");
        }
    }

    public boolean allBlobsAvailable(@NotNull Collection<Blob> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (this.isBlobAvailable((Blob)object.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isBlobAvailable(@NotNull Blob blob) {
        return new File(blob.getLocalPath()).exists();
    }

    @NotNull
    public Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        EnumSet<Language> enumSet = EnumSet.noneOf(Language.class);
        File[] fileArray = this.blobStoreStrategy.getOCRDataDirectory().listFiles();
        if (fileArray == null) {
            return enumSet;
        }
        for (Object object : fileArray) {
            if (object.isDirectory() || (object = Language.languageByIso(FilenameUtils.removeExtension((String)object.getName()))) == null) continue;
            BlobManager blobManager = this;
            if (!blobManager.allBlobsAvailable(blobManager.blobFactory.ocrLanguageBlobs())) continue;
            enumSet.add((Language)((Object)object));
        }
        return enumSet;
    }

    @NotNull
    public File getOCRBlobsDirectory() throws IOException {
        File file = ((BlobManager)((Object)file)).blobStoreStrategy.getOCRDataDirectory();
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't get OCR blobs directory");
        }
        return file;
    }

    @NotNull
    public File getBanksDataFile() throws IOException {
        File file = ((BlobManager)((Object)file)).blobStoreStrategy.getBanksDataFile();
        if (file.exists()) {
            return file;
        }
        throw new IOException("Can't get banks data file");
    }

    @NotNull
    public File getMRZTraineddataFile() throws IOException {
        File file = ((BlobManager)((Object)file)).blobStoreStrategy.getMRZTraindataFile();
        if (file.exists()) {
            return file;
        }
        throw new IOException("Can't get MRZ traineddata file");
    }

    @NotNull
    public File getMRZCascadeFile() throws IOException {
        File file = ((BlobManager)((Object)file)).blobStoreStrategy.getMRZCascadeFile();
        if (file.exists()) {
            return file;
        }
        throw new IOException("Can't get MRZ cascade file");
    }

    public long fetch(@NotNull Blob blob) throws IOException {
        if (this.isBlobAvailable(blob)) {
            return -1L;
        }
        Blob blob2 = blob;
        this.ensureDirectoryCreated(blob);
        return this.copyFromAssets(blob2, Uri.parse((String)blob2.getRemotePath()));
    }
}

