/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.c.c;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.g;
import net.doo.snap.camera.t;
import net.doo.snap.camera.u;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private static final int TAKE_PICTURE_DELAY_MS = 500;
    private CameraView cameraView;
    private g cameraHost;
    private boolean resumed = false;
    private b state = b.a;
    private final Set<CameraStateCallback> stateCallbacks = new LinkedHashSet<CameraStateCallback>();
    private final Set<CameraTakePictureCallback> takePictureCallbacks = new LinkedHashSet<CameraTakePictureCallback>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context);
    }

    private void initView(Context context) {
        FrameLayout.LayoutParams layoutParams;
        if (!io.scanbot.sdk.ScanbotSDKInitializer.isInitialized() && !ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        ScanbotCameraView scanbotCameraView = scanbotCameraView2;
        scanbotCameraView.cameraView = new CameraView(context);
        scanbotCameraView.cameraHost = new g(context);
        scanbotCameraView.cameraView.setCameraHost((CameraHost)scanbotCameraView2.cameraHost);
        scanbotCameraView.cameraView.a(scanbotCameraView2.new a(null));
        ScanbotCameraView scanbotCameraView2 = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)-1).gravity = 17;
        scanbotCameraView.addView((View)scanbotCameraView.cameraView, 0, (ViewGroup.LayoutParams)scanbotCameraView2);
    }

    private void notifyResumedState() {
        Iterator<CameraStateCallback> iterator = ((ScanbotCameraView)((Object)iterator)).stateCallbacks.iterator();
        while (iterator.hasNext()) {
            ((CameraStateCallback)iterator.next()).onResume();
        }
    }

    private void notifyPausedState() {
        Iterator<CameraStateCallback> iterator = ((ScanbotCameraView)((Object)iterator)).stateCallbacks.iterator();
        while (iterator.hasNext()) {
            ((CameraStateCallback)iterator.next()).onPause();
        }
    }

    private void notifyTakePictureCancelled() {
        Iterator<CameraTakePictureCallback> iterator = ((ScanbotCameraView)((Object)iterator)).takePictureCallbacks.iterator();
        while (iterator.hasNext()) {
            ((CameraTakePictureCallback)iterator.next()).onTakePictureCancelled();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performSnapping() {
        this.state = b.c;
        try {
            Camera.Parameters parameters = this.cameraView.getCameraParameters();
            PictureTransaction pictureTransaction = new PictureTransaction((CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (parameters != null) {
                pictureTransaction = pictureTransaction.flashMode(parameters.getFlashMode());
            }
            this.cameraView.takePicture(pictureTransaction);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
        }
    }

    static /* synthetic */ b access$200(ScanbotCameraView scanbotCameraView) {
        return scanbotCameraView.state;
    }

    static /* synthetic */ void access$300(ScanbotCameraView scanbotCameraView) {
        scanbotCameraView.performSnapping();
    }

    static /* synthetic */ b access$202(ScanbotCameraView scanbotCameraView, b b2) {
        scanbotCameraView.state = b2;
        return b2;
    }

    static /* synthetic */ void access$400(ScanbotCameraView scanbotCameraView) {
        scanbotCameraView.notifyTakePictureCancelled();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        ScanbotCameraView scanbotCameraView = this;
        this.logger.logMethod();
        super.onLayout(bl, n2, n3, n4, n5);
        View view = scanbotCameraView.cameraView.getChildAt(0);
        if (view == null) {
            return;
        }
        View view2 = view;
        n2 = this.getChildCount();
        n3 = View.MeasureSpec.makeMeasureSpec((int)view2.getWidth(), (int)Integer.MIN_VALUE);
        n4 = View.MeasureSpec.makeMeasureSpec((int)view2.getHeight(), (int)Integer.MIN_VALUE);
        for (n5 = 1; n5 < n2; ++n5) {
            View view3 = this.getChildAt(n5);
            if (view3 instanceof CameraView) continue;
            view3.measure(n3, n4);
            view3.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.b();
    }

    public void onResume() {
        ScanbotCameraView scanbotCameraView = this;
        ExecutionUtils.ensureMainThread();
        scanbotCameraView.logger.logMethod();
        if (scanbotCameraView.resumed) {
            return;
        }
        ScanbotCameraView scanbotCameraView2 = this;
        scanbotCameraView2.resumed = c.a().isLicenseActive();
        scanbotCameraView2.state = b.a;
        scanbotCameraView2.cameraView.onResume();
        scanbotCameraView2.notifyResumedState();
    }

    public void onPause() {
        ScanbotCameraView scanbotCameraView = this;
        ExecutionUtils.ensureMainThread();
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        ScanbotCameraView scanbotCameraView2 = this;
        scanbotCameraView2.resumed = false;
        scanbotCameraView2.state = b.a;
        scanbotCameraView2.cameraView.onPause();
        scanbotCameraView2.notifyPausedState();
    }

    public void startPreview() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.stopPreview();
    }

    public void takePicture(boolean bl) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        b b2 = b.a;
        if (scanbotCameraView.state != b2) {
            ScanbotCameraView scanbotCameraView2 = this;
            scanbotCameraView2.state = b2;
            scanbotCameraView2.notifyTakePictureCancelled();
            if (!scanbotCameraView2.resumed) {
                return;
            }
        }
        if (bl) {
            this.state = b.b;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    public void useFlash(boolean bl) {
        ScanbotCameraView scanbotCameraView = object;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        if (Utils.isFlashSupported(object.cameraView.getCameraParameters())) {
            Object object = object.cameraView;
            String string = bl ? "torch" : "off";
            object.setFlashMode(string);
        }
    }

    public void setAutoFocusOnTouch(boolean bl) {
        this.cameraView.a(bl);
    }

    public void autoFocus() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        if (!scanbotCameraView.resumed) {
            return;
        }
        this.cameraView.a();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.a(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.b(pictureCallback);
    }

    void addCameraStateCallback(CameraStateCallback cameraStateCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.stateCallbacks.add(cameraStateCallback);
    }

    void removeCameraStateCallback(CameraStateCallback cameraStateCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.stateCallbacks.remove(cameraStateCallback);
    }

    void addTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.takePictureCallbacks.add(cameraTakePictureCallback);
    }

    void removeTakePictureCallback(CameraTakePictureCallback cameraTakePictureCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.takePictureCallbacks.remove(cameraTakePictureCallback);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.a(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        ScanbotCameraView scanbotCameraView = scanbotCameraView2;
        scanbotCameraView.logger.logMethod();
        ScanbotCameraView scanbotCameraView2 = scanbotCameraView.cameraView.getCameraParameters();
        if (scanbotCameraView2 != null) {
            return scanbotCameraView2.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        ScanbotCameraView scanbotCameraView = scanbotCameraView2;
        scanbotCameraView.logger.logMethod();
        ScanbotCameraView scanbotCameraView2 = scanbotCameraView.cameraView.getCameraParameters();
        if (scanbotCameraView2 != null) {
            return scanbotCameraView2.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size size) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.a(size);
        Camera.Parameters parameters = scanbotCameraView.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPictureSize(size.width, size.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setPreviewSize(Camera.Size size) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.b(size);
        Camera.Parameters parameters = scanbotCameraView.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPreviewSize(size.width, size.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setAutoFocusSound(boolean bl) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.a(bl);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean bl) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.b(bl);
        scanbotCameraView.cameraView.b(bl);
    }

    public void setPreviewMode(CameraPreviewMode cameraPreviewMode) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraHost.a(cameraPreviewMode);
    }

    @Deprecated
    public void lockToPortrait() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToPortrait();
    }

    @Deprecated
    public void lockToLandscape() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToLandscape();
    }

    public void lockToPortrait(boolean bl) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToPortrait(bl);
    }

    public void lockToLandscape(boolean bl) {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.lockToLandscape(bl);
    }

    public void unlockOrientation() {
        ScanbotCameraView scanbotCameraView = this;
        scanbotCameraView.logger.logMethod();
        scanbotCameraView.cameraView.unlockOrientation();
    }

    private static enum b {
        a,
        b,
        c;

    }

    private class a
    implements CameraView.AutofocusCallback {
        private a() {
        }

        /* synthetic */ a(t t2) {
            this();
        }

        @Override
        public void onAutoFocusCompleted() {
            a a2 = this;
            a2.ScanbotCameraView.this.logger.logMethod();
            a2.ScanbotCameraView.this.postDelayed(new u(this), 500L);
        }
    }
}

