/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.text.TextUtils;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.doo.snap.R;

@Singleton
public class CameraConfiguration {
    private List<String> supportedFlashModes;
    private List<String> supportedFocusModes;
    private List<Integer> supportedPreviewFormats;
    private List<Integer> supportedPictureFormats;
    private List<Camera.Size> supportedPreviewSizes;
    private List<Camera.Size> supportedPictureSizes;
    private boolean isConigured = false;

    @Inject
    public CameraConfiguration() {
    }

    private String joinSizes(String string2, List<Camera.Size> object) {
        Object object2 = "";
        object = object.iterator();
        while (object.hasNext()) {
            Camera.Size size = (Camera.Size)object.next();
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + string2;
            }
            object2 = (String)object2 + size.width + "x" + size.height;
        }
        return object2;
    }

    public void loadCameraParameters(Camera.Parameters parameters) {
        CameraConfiguration cameraConfiguration = this;
        this.supportedFlashModes = parameters.getSupportedFlashModes();
        this.supportedFocusModes = parameters.getSupportedFocusModes();
        this.supportedPreviewFormats = parameters.getSupportedPreviewFormats();
        this.supportedPictureFormats = parameters.getSupportedPictureFormats();
        this.supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        cameraConfiguration.supportedPictureSizes = parameters.getSupportedPictureSizes();
        cameraConfiguration.isConigured = true;
    }

    public List<String> getSupportedFlashModes() {
        return this.supportedFlashModes;
    }

    public List<String> getSupportedFocusModes() {
        return this.supportedFocusModes;
    }

    public List<Integer> getSupportedPreviewFormats() {
        return this.supportedPreviewFormats;
    }

    public List<Integer> getSupportedPictureFormats() {
        return this.supportedPictureFormats;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        return this.supportedPreviewSizes;
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        return this.supportedPictureSizes;
    }

    public boolean isConigured() {
        return this.isConigured;
    }

    public String toString(Context context) {
        CharSequence charSequence = context.getString(R.string.device_configuration, new Object[]{Build.PRODUCT, Build.DEVICE, Build.BOARD, Build.HARDWARE, Build.MANUFACTURER, Build.BRAND, Build.MODEL, Build.HARDWARE, Build.SERIAL, Build.FINGERPRINT});
        if (((CameraConfiguration)object).isConigured) {
            Object object;
            charSequence = new StringBuilder().append((String)charSequence);
            int n2 = R.string.camera_configuration;
            Object[] objectArray = new Object[6];
            int n3 = 0;
            String string2 = ((CameraConfiguration)object).getSupportedFlashModes() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)object).getSupportedFlashModes());
            objectArray[n3] = string2;
            n3 = 1;
            string2 = ((CameraConfiguration)object).getSupportedFocusModes() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)object).getSupportedFocusModes());
            objectArray[n3] = string2;
            n3 = 2;
            string2 = ((CameraConfiguration)object).getSupportedPreviewFormats() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)object).getSupportedPreviewFormats());
            objectArray[n3] = string2;
            n3 = 3;
            string2 = ((CameraConfiguration)object).getSupportedPictureFormats() == null ? "" : TextUtils.join((CharSequence)", ", ((CameraConfiguration)object).getSupportedPictureFormats());
            objectArray[n3] = string2;
            n3 = 4;
            if (((CameraConfiguration)object).getSupportedPreviewSizes() == null) {
                string2 = "";
            } else {
                CameraConfiguration cameraConfiguration = object;
                string2 = cameraConfiguration.joinSizes(", ", cameraConfiguration.getSupportedPreviewSizes());
            }
            objectArray[n3] = string2;
            n3 = 5;
            if (((CameraConfiguration)object).getSupportedPictureSizes() == null) {
                object = "";
            } else {
                CameraConfiguration cameraConfiguration = object;
                object = cameraConfiguration.joinSizes(", ", cameraConfiguration.getSupportedPictureSizes());
            }
            objectArray[n3] = object;
            charSequence = ((StringBuilder)charSequence).append(context.getString(n2, objectArray)).toString();
        }
        return charSequence;
    }
}

