/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final Pattern FILE_NAME_ANTIPATTERN = Pattern.compile("[\\\\|?*<\\\">+\\[\\]/':]", 2);
    private static final int MAX_FILE_NAME_LENGTH = 250;
    public static final String SCANBOT_SDK_FILES_DIR = "scanbot-sdk";

    public static boolean isFileNameSafe(CharSequence charSequence) {
        if (!TextUtils.isEmpty((CharSequence)charSequence) && charSequence.length() <= 250) {
            return FILE_NAME_ANTIPATTERN.matcher(charSequence).find() ^ true;
        }
        return false;
    }

    public static File getExternalFilesDirOrShowError(Context object, String string2) throws IOException {
        File file;
        Context context = object;
        object = null;
        try {
            file = context.getExternalFilesDir(null);
        }
        catch (NullPointerException nullPointerException) {
            file = object;
        }
        if (file != null) {
            File file2;
            object = file2;
            if (!new File(file, string2).exists() && !((File)object).mkdir()) {
                FileUtils.fail();
                throw null;
            }
            return object;
        }
        FileUtils.fail();
        throw null;
    }

    public static File getExternalStorageDirOrShowError(Context object, String string2) throws IOException {
        object = Environment.getExternalStorageDirectory();
        if (object != null) {
            File file;
            File file2 = file;
            if (!new File((File)object, string2).exists() && !file2.mkdir()) {
                FileUtils.fail();
                throw null;
            }
            return file2;
        }
        FileUtils.fail();
        throw null;
    }

    public static File getAppFilesDirOrShowError(Context object, String string2) throws IOException {
        File file;
        Context context = object;
        object = null;
        try {
            file = context.getFilesDir();
        }
        catch (NullPointerException nullPointerException) {
            file = object;
        }
        if (file != null) {
            File file2;
            object = file2;
            if (!new File(file, string2).exists() && !((File)object).mkdir()) {
                FileUtils.fail();
                throw null;
            }
            return object;
        }
        FileUtils.fail();
        throw null;
    }

    public static File getExternalCacheDirOrShowError(Context object, String string2) throws IOException {
        if ((object = object.getExternalCacheDir()) != null) {
            File file;
            File file2 = file;
            if (!new File((File)object, string2).exists() && !file2.mkdir()) {
                FileUtils.fail();
                throw null;
            }
            return file2;
        }
        FileUtils.fail();
        throw null;
    }

    public static boolean ensureDirExists(String string2) {
        File file;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        File file2 = file;
        return new File(string2).exists() || file2.mkdirs();
    }

    public static File getFilesDirOrShowError(String object, String string2) throws IOException {
        File file;
        File file2;
        File file3 = file2;
        file2 = new File((String)object);
        object = file;
        if (!new File(file3, string2).exists() && !((File)object).mkdir()) {
            FileUtils.fail();
            throw null;
        }
        return object;
    }

    private static File fail() throws IOException {
        throw new IOException("can't get external directory");
    }
}

