/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public enum Language {
    AFR("afr", "af"),
    AMH("amh", "am"),
    ARA("ara", "ar"),
    ASM("asm", "as"),
    AZE("aze", "az"),
    AZE_CYRL("aze_cyrl", "DUPLICATE"),
    BEL("bel", "be"),
    BEN("ben", "bn"),
    BOD("bod", "bo"),
    BOS("bos", "bs"),
    BUL("bul", "bg"),
    CAT("cat", "ca"),
    CEB("ceb", "DUPLICATE"),
    CES("ces", "cs"),
    CHI_SIM("chi_sim", "DUPLICATE"),
    CHI_TRA("chi_tra", "DUPLICATE"),
    CHR("chr", "DUPLICATE"),
    CYM("cym", "cy"),
    DAN("dan", "da"),
    DEU("deu", "de"),
    DZO("dzo", "dz"),
    ELL("ell", "el"),
    ENG("eng", "en"),
    ENM("enm", "DUPLICATE"),
    EPO("epo", "eo"),
    EST("est", "et"),
    EUS("eus", "eu"),
    FAS("fas", "fa"),
    FIN("fin", "fi"),
    FRA("fra", "fr"),
    FRK("frk", "DUPLICATE"),
    FRM("frm", "DUPLICATE"),
    GLE("gle", "ga"),
    GLG("glg", "gl"),
    GRC("grc", "DUPLICATE"),
    GUJ("guj", "gu"),
    HAT("hat", "ht"),
    HEB("heb", "he"),
    HIN("hin", "hi"),
    HRV("hrv", "hr"),
    HUN("hun", "hu"),
    IKU("iku", "iu"),
    IND("ind", "id"),
    ISL("isl", "is"),
    ITA("ita", "it"),
    ITA_OLD("ita_old", "DUPLICATE"),
    JAV("jav", "jv"),
    JPN("jpn", "ja"),
    KAN("kan", "kn"),
    KAT("kat", "ka"),
    KAT_OLD("kat_old", "DUPLICATE"),
    KAZ("kaz", "kk"),
    KHM("khm", "km"),
    KIR("kir", "ky"),
    KOR("kor", "ko"),
    KUR("kur", "ku"),
    LAO("lao", "lo"),
    LAT("lat", "la"),
    LAV("lav", "lv"),
    LIT("lit", "lt"),
    MAL("mal", "ml"),
    MAR("mar", "mr"),
    MKD("mkd", "mk"),
    MLT("mlt", "mt"),
    MSA("msa", "ms"),
    MYA("mya", "my"),
    NEP("nep", "ne"),
    NLD("nld", "nl"),
    NOR("nor", "no"),
    ORI("ori", "or"),
    PAN("pan", "pa"),
    POL("pol", "pl"),
    POR("por", "pt"),
    PUS("pus", "ps"),
    RON("ron", "ro"),
    RUS("rus", "ru"),
    SAN("san", "sa"),
    SIN("sin", "si"),
    SLK("slk", "sk"),
    SLV("slv", "sl"),
    SPA("spa", "es"),
    SPA_OLD("spa_old", "DUPLICATE"),
    SQI("sqi", "sq"),
    SRP("srp", "sr"),
    SRP_LATN("srp_latn", "DUPLICATE"),
    SWA("swa", "sw"),
    SWE("swe", "sv"),
    SYR("syr", "DUPLICATE"),
    TAM("tam", "ta"),
    TEL("tel", "te"),
    TGK("tgk", "tg"),
    TGL("tgl", "tl"),
    THA("tha", "th"),
    TIR("tir", "ti"),
    TUR("tur", "tr"),
    UIG("uig", "ug"),
    UKR("ukr", "uk"),
    URD("urd", "ur"),
    UZB("uzb", "uz"),
    UZB_CYRL("uzb_cyrl", "DUPLICATE"),
    VIE("vie", "vi"),
    YID("yid", "yi");

    private static final HashMap<String, Language> isoToLanguage;
    private final String iso3Code;
    private final String iso1Code;

    public static Language languageByIso(String isoCode) {
        return isoToLanguage.get(isoCode);
    }

    public static String[] languageCodes(Collection<Language> languages) {
        String[] stringArray = new String[languages.size()];
        int n2 = 0;
        for (Language language : languages) {
            stringArray[n2] = language.getIsoCode();
            ++n2;
        }
        return stringArray;
    }

    private Language(@NotNull String iso3Code, String iso1Code) {
        this.iso3Code = iso3Code;
        this.iso1Code = iso1Code;
    }

    public String getIsoCode() {
        return this.iso3Code;
    }

    public String getIso1Code() {
        return this.iso1Code;
    }

    static {
        isoToLanguage = new HashMap();
        for (Language language : Language.values()) {
            isoToLanguage.put(language.getIsoCode(), language);
            if (language.getIso1Code().equals("DUPLICATE")) continue;
            isoToLanguage.put(language.getIso1Code(), language);
        }
        isoToLanguage.put("nob", NOR);
        isoToLanguage.put("zho", CHI_SIM);
    }
}

