/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.TextRecognition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J$\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010 \u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "textRecognition", "Lnet/doo/snap/process/TextRecognition;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Lnet/doo/snap/process/TextRecognition;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "checkMissingLangs", "", "languages", "", "Lnet/doo/snap/entity/Language;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lnet/doo/snap/entity/Document;", "recognizeTextFromPages", "Lnet/doo/snap/process/OcrResult;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUris", "sdk-bundle_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    private final TextRecognition textRecognition;
    private final PageFactory pageFactory;
    private final BlobManager blobManager;
    private final PageFileStorage pageFileStorage;

    private final Document getPendingDocument() {
        Document document;
        ScanbotOpticalCharacterRecognizer this_ = document;
        new Document().setId(UUID.randomUUID().toString());
        this_.setName(this_.getId() + ".pdf");
        this_.setOcrStatus(OcrStatus.PENDING);
        return this_;
    }

    private final void checkMissingLangs(Set<? extends Language> languages) {
        if (!((this = SetsKt.minus(languages, ((ScanbotOpticalCharacterRecognizer)this).getInstalledLanguages())).isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException(this + " Provided set of languages was not presented on device");
    }

    @Inject
    public ScanbotOpticalCharacterRecognizer(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.textRecognition = textRecognition;
        this.pageFactory = pageFactory;
        this.blobManager = blobManager;
        this.pageFileStorage = pageFileStorage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        void var2_2;
        ArrayList<net.doo.snap.entity.Page> arrayList;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Set<? extends Language> set = languages;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull(set, (String)"languages");
        scanbotOpticalCharacterRecognizer.checkMissingLangs(set);
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.textRecognition;
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(imageFileUris, (int)10));
        for (Uri uri : imageFileUris) {
            arrayList2.add(this.pageFactory.buildPage(UriKt.toFile((Uri)uri)));
        }
        OcrResult ocrResult = textRecognition.withoutPDF(arrayList2, (Set)var2_2).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        void var2_2;
        ArrayList<net.doo.snap.entity.Page> arrayList;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Set<? extends Language> set = languages;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(set, (String)"languages");
        scanbotOpticalCharacterRecognizer.checkMissingLangs(set);
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.textRecognition;
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(pages, (int)10));
        for (Page page : pages) {
            net.doo.snap.entity.Page page2 = this.pageFactory.buildPage(page.getPageId(), new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(page.getFilter());
            arrayList2.add(page2);
        }
        OcrResult ocrResult = textRecognition.withoutPDF(arrayList2, (Set)var2_2).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void var3_3;
        ArrayList<net.doo.snap.entity.Page> arrayList;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Set<? extends Language> set = languages;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(set, (String)"languages");
        scanbotOpticalCharacterRecognizer.checkMissingLangs(set);
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.textRecognition;
        Document document = scanbotOpticalCharacterRecognizer.getPendingDocument();
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(imageFileUris, (int)10));
        for (Uri uri : imageFileUris) {
            void var2_2;
            net.doo.snap.entity.Page page = this.pageFactory.buildPage(UriKt.toFile((Uri)uri));
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"oldPage");
            page.setPageSize((PDFPageSize)var2_2);
            arrayList2.add(page);
        }
        OcrResult ocrResult = textRecognition.withPDF(document, arrayList2, (Set)var3_3).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void var3_3;
        ArrayList<net.doo.snap.entity.Page> arrayList;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        Set<? extends Language> set = languages;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(set, (String)"languages");
        scanbotOpticalCharacterRecognizer.checkMissingLangs(set);
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.textRecognition;
        Document document = scanbotOpticalCharacterRecognizer.getPendingDocument();
        ArrayList<net.doo.snap.entity.Page> arrayList2 = arrayList;
        arrayList = new ArrayList<net.doo.snap.entity.Page>(CollectionsKt.collectionSizeOrDefault(pages, (int)10));
        for (Page page : pages) {
            void var2_2;
            net.doo.snap.entity.Page page2 = this.pageFactory.buildPage(page.getPageId(), new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(page.getFilter());
            page2.setPolygon(page.getPolygon());
            page2.setPageSize((PDFPageSize)var2_2);
            arrayList2.add(page2);
        }
        OcrResult ocrResult = textRecognition.withPDF(document, arrayList2, (Set)var3_3).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        File file = this.blobManager.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        Set set = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }
}

