/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor$WhenMappings;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.utils.PolygonHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "(Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "createPage", "Lio/scanbot/sdk/persistence/Page;", "srcImage", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "createPage$sdk_bundle_release", "", "createPreviewTo", "previewFile", "Ljava/io/File;", "bitmap", "image", "erasePageData", "", "page", "saveBitmapTo", "file", "Configuration", "sdk-bundle_release"})
public final class PageStorageProcessor {
    private final Logger logger;
    private final PageStorage pageStorage;
    private final PageStorageSettings pageStorageSettings;

    @Inject
    public PageStorageProcessor(@NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings) {
        PageStorageProcessor pageStorageProcessor = this;
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.pageStorage = pageStorage;
        pageStorageProcessor.pageStorageSettings = pageStorageSettings;
        pageStorageProcessor.logger = LoggerProvider.getLogger();
    }

    @NotNull
    public final Page createPage$sdk_bundle_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        BitmapFactory.Options options;
        PageStorageProcessor pageStorageProcessor = this_;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])srcImage, (int)0, (int)srcImage.length, (BitmapFactory.Options)this_);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"originalBitmap");
        return pageStorageProcessor.createPage$sdk_bundle_release(bitmap, configuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createPage$sdk_bundle_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        Page.Size size;
        Object this_;
        DetectionResult detectionResult;
        Bitmap bitmap;
        Object object;
        void var2_3;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        FileUtils.forceMkdir((File)((PageStorageProcessor)this_).pageStorage.getPageDir(string));
        if (configuration.getImageOrientation() > 0 || var2_3.getImageScale() != 1.0f) {
            Matrix matrix;
            object = matrix;
            matrix = new Matrix();
            if (var2_3.getImageOrientation() > 0) {
                object.setRotate((float)var2_3.getImageOrientation(), (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            }
            if (var2_3.getImageScale() != 1.0f) {
                object.postScale(var2_3.getImageScale(), var2_3.getImageScale());
            }
            void v1 = bitmap;
            int n = v1.getWidth();
            int n2 = v1.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)v1, (int)0, (int)0, (int)n, (int)n2, (Matrix)object, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
        }
        PageStorageProcessor pageStorageProcessor = this_;
        pageStorageProcessor.saveBitmapTo(pageStorageProcessor.pageStorage.getOriginalImage(string), bitmap);
        if (var2_3.getCreatePreview()) {
            PageStorageProcessor pageStorageProcessor2 = this_;
            void v4 = bitmap;
            double d = (double)((PageStorageProcessor)this_).pageStorageSettings.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
            object = Bitmap.createScaledBitmap((Bitmap)v4, (int)((int)((double)v4.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
            File file = pageStorageProcessor2.pageStorage.getOriginalImagePreview(string);
            Object object2 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"preview");
            pageStorageProcessor2.saveBitmapTo(file, (Bitmap)object2);
        }
        object = PolygonHelper.Companion.getFulPolygon();
        DetectionResult detectionResult2 = DetectionResult.ERROR_NOTHING_DETECTED;
        if (var2_3.getCreateDocument()) {
            ContourDetector contourDetector;
            detectionResult2 = contourDetector;
            detectionResult2();
            detectionResult2.setRequiredAspectRatios(var2_3.getRequiredAspectRatios());
            detectionResult2.setRectOfInterest(var2_3.getRectOfInterest());
            detectionResult = contourDetector.detect(bitmap);
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult, (String)"detector.detect(originalBitmap)");
            if (detectionResult != DetectionResult.ERROR_NOTHING_DETECTED && detectionResult != DetectionResult.ERROR_TOO_DARK && detectionResult != DetectionResult.ERROR_TOO_NOISY) {
                object = detectionResult2.getPolygonF();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"detector.polygonF");
            }
            bitmap = detectionResult2.processImageF(bitmap, (List)object, ImageFilterType.NONE.getCode());
            if (var2_3.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && var2_3.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
                bitmap = BitmapUtils.scaleIfNeeded((Bitmap)bitmap, (int)var2_3.getDocumentImageSizeLimit().getWidth(), (int)var2_3.getDocumentImageSizeLimit().getHeight());
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapUtils.scaleIfNeede\u2026entImageSizeLimit.height)");
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"documentBitmapBeforeScaling");
            }
            Object object3 = this_;
            ((PageStorageProcessor)object3).saveBitmapTo(((PageStorageProcessor)object3).pageStorage.getDocumentImage(string), bitmap);
            ((PageStorageProcessor)object3).saveBitmapTo(((PageStorageProcessor)object3).pageStorage.getUnfilteredDocumentImage(string), bitmap);
            if (var2_3.getCreatePreview()) {
                Object object4 = this_;
                Bitmap bitmap2 = bitmap;
                double d = (double)((PageStorageProcessor)this_).pageStorageSettings.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
                this_ = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
                File file = ((PageStorageProcessor)object4).pageStorage.getDocumentImagePreview(string);
                Object object5 = this_;
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"preview");
                ((PageStorageProcessor)object4).saveBitmapTo(file, (Bitmap)object5);
                ((PageStorageProcessor)object4).saveBitmapTo(((PageStorageProcessor)object4).pageStorage.getUnfilteredDocumentImagePreview(string), (Bitmap)this_);
            }
        } else {
            detectionResult = detectionResult2;
        }
        this_ = size;
        size = new Page.Size(var2_3.getDocumentImageSizeLimit().getWidth(), var2_3.getDocumentImageSizeLimit().getHeight());
        return new Page(string, (List)object, detectionResult, null, (Page.Size)this_, null, 0, 104, null);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] bitmap) {
        BitmapFactory.Options options;
        PageStorageProcessor pageStorageProcessor = this_;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])bitmap, (int)0, (int)bitmap.length, (BitmapFactory.Options)this_);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        pageStorageProcessor.saveBitmapTo(file, bitmap2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block14: {
            FileOutputStream fileOutputStream2;
            block15: {
                block13: {
                    void var1_1;
                    FileOutputStream fileOutputStream3;
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
                    Object var3_8 = null;
                    fileOutputStream = fileOutputStream3;
                    fileOutputStream3 = new FileOutputStream((File)var1_1);
                    try {
                        void var2_7;
                        Bitmap.CompressFormat compressFormat;
                        block12: {
                            int n = PageStorageProcessor$WhenMappings.$EnumSwitchMapping$0[this.pageStorageSettings.getImageFormat().ordinal()];
                            if (n != 1) {
                                if (n == 2) {
                                    compressFormat = Bitmap.CompressFormat.PNG;
                                    break block12;
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compressFormat = Bitmap.CompressFormat.JPEG;
                        }
                        Bitmap.CompressFormat compressFormat2 = compressFormat;
                        fileOutputStream2 = fileOutputStream;
                        var2_7.compress(compressFormat2, this.pageStorageSettings.getImageQuality(), (OutputStream)fileOutputStream);
                    }
                    catch (IOException iOException) {
                        break block13;
                    }
                    break block15;
                    catch (Throwable throwable2) {
                        fileOutputStream = var3_8;
                        break block14;
                    }
                    catch (IOException iOException) {
                        fileOutputStream = var3_8;
                    }
                }
                try {
                    void var1_6;
                    fileOutputStream2 = fileOutputStream;
                    this.logger.logException((Throwable)var1_6);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream2);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull byte[] image) {
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)((byte[])image).length);
        image = bitmap;
        double d = this.pageStorageSettings.getPreviewTargetMax();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"bitmap");
        double d2 = d / (double)Math.max(image.getHeight(), image.getWidth());
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d2)), (int)((int)((double)image.getHeight() * d2)), (boolean)false);
        image = bitmap2;
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"preview");
        this.saveBitmapTo(previewFile, (Bitmap)image);
        return bitmap2;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        double d = (double)this.pageStorageSettings.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
        Bitmap bitmap3 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap3);
        return bitmap;
    }

    public final void erasePageData(@NotNull Page page) {
        block5: {
            File file;
            Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
            file = this.pageStorage.getPageDir(((Page)((Object)file)).getPageId());
            if (!file.exists()) break block5;
            if (!file.isDirectory()) break block5;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                this.logger.logException((Throwable)iOException);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0002+,BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003JU\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "createPreview", "", "createDocument", "documentImageSizeLimit", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "imageScale", "", "imageOrientation", "", "requiredAspectRatios", "", "Lnet/doo/snap/lib/detector/PageAspectRatio;", "rectOfInterest", "Landroid/graphics/RectF;", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;)V", "getCreateDocument", "()Z", "getCreatePreview", "getDocumentImageSizeLimit", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getImageOrientation", "()I", "getImageScale", "()F", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "Size", "sdk-bundle_release"})
    public static final class Configuration {
        public static final Companion Companion = new Companion(null);
        private final boolean createPreview;
        private final boolean createDocument;
        @NotNull
        private final Size documentImageSizeLimit;
        private final float imageScale;
        private final int imageOrientation;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @NotNull
        private final RectF rectOfInterest;

        public Configuration(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest) {
            Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
            this.createPreview = createPreview;
            this.createDocument = createDocument;
            this.documentImageSizeLimit = documentImageSizeLimit;
            this.imageScale = imageScale;
            this.imageOrientation = imageOrientation;
            this.requiredAspectRatios = requiredAspectRatios;
            this.rectOfInterest = rectOfInterest;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                Size size2;
                size = size2;
                size2 = new Size(0, 0, 3, null);
            }
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
            }
            if ((n2 & 0x40) != 0) {
                RectF rectF2;
                rectF = rectF2;
                rectF2 = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            this(bl, bl2, size, f, n, list, rectF);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, 127, null);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = configuration.createPreview;
            }
            if ((n2 & 2) != 0) {
                bl2 = configuration.createDocument;
            }
            if ((n2 & 4) != 0) {
                size = configuration.documentImageSizeLimit;
            }
            if ((n2 & 8) != 0) {
                f = configuration.imageScale;
            }
            if ((n2 & 0x10) != 0) {
                n = configuration.imageOrientation;
            }
            if ((n2 & 0x20) != 0) {
                list = configuration.requiredAspectRatios;
            }
            if ((n2 & 0x40) != 0) {
                rectF = configuration.rectOfInterest;
            }
            return configuration.copy(bl, bl2, size, f, n, list, rectF);
        }

        @JvmStatic
        @NotNull
        public static final Configuration DEFAULT() {
            return Companion.DEFAULT();
        }

        public final boolean getCreatePreview() {
            return this.createPreview;
        }

        public final boolean getCreateDocument() {
            return this.createDocument;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.documentImageSizeLimit;
        }

        public final float getImageScale() {
            return this.imageScale;
        }

        public final int getImageOrientation() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public final boolean component1() {
            return this.createPreview;
        }

        public final boolean component2() {
            return this.createDocument;
        }

        @NotNull
        public final Size component3() {
            return this.documentImageSizeLimit;
        }

        public final float component4() {
            return this.imageScale;
        }

        public final int component5() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> component6() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF component7() {
            return this.rectOfInterest;
        }

        @NotNull
        public final Configuration copy(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<? extends PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest) {
            Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
            return new Configuration(createPreview, createDocument, documentImageSizeLimit, imageScale, imageOrientation, requiredAspectRatios, rectOfInterest);
        }

        @NotNull
        public String toString() {
            return "Configuration(createPreview=" + this.createPreview + ", createDocument=" + this.createDocument + ", documentImageSizeLimit=" + this.documentImageSizeLimit + ", imageScale=" + this.imageScale + ", imageOrientation=" + this.imageOrientation + ", requiredAspectRatios=" + this.requiredAspectRatios + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            int n = this.createPreview ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            n *= 31;
            int n2 = this.createDocument ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            Size size = this.documentImageSizeLimit;
            int n3 = size != null ? size.hashCode() : 0;
            Configuration configuration = this;
            n = (n + n3) * 31;
            n = ((Float.floatToIntBits(configuration.imageScale) + n) * 31 + this.imageOrientation) * 31;
            List<PageAspectRatio> list = configuration.requiredAspectRatios;
            int n4 = list != null ? ((Object)list).hashCode() : 0;
            int n5 = (n + n4) * 31;
            RectF rectF = this.rectOfInterest;
            int n6 = rectF != null ? rectF.hashCode() : 0;
            return n5 + n6;
        }

        public boolean equals(@Nullable Object object) {
            block2: {
                block3: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    object = (Configuration)object;
                    if (this.createPreview == ((Configuration)object).createPreview && this.createDocument == ((Configuration)object).createDocument && Intrinsics.areEqual((Object)this.documentImageSizeLimit, (Object)((Configuration)object).documentImageSizeLimit) && Float.compare(this.imageScale, ((Configuration)object).imageScale) == 0 && this.imageOrientation == ((Configuration)object).imageOrientation && Intrinsics.areEqual(this.requiredAspectRatios, ((Configuration)object).requiredAspectRatios) && Intrinsics.areEqual((Object)this.rectOfInterest, (Object)((Configuration)object).rectOfInterest)) break block2;
                }
                return false;
            }
            return true;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-bundle_release"})
        public static final class Size
        implements Serializable {
            private final int width;
            private final int height;

            public Size(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = Integer.MAX_VALUE;
                }
                if ((n3 & 2) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this(n, n2);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = size.width;
                }
                if ((n3 & 2) != 0) {
                    n2 = size.height;
                }
                return size.copy(n, n2);
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            @NotNull
            public final Size copy(int width, int height) {
                return new Size(width, height);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                return this.width * 31 + this.height;
            }

            public boolean equals(@Nullable Object object) {
                block2: {
                    block3: {
                        if (this == object) break block2;
                        if (!(object instanceof Size)) break block3;
                        object = (Size)object;
                        if (this.width == ((Size)object).width && this.height == ((Size)object).height) break block2;
                    }
                    return false;
                }
                return true;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "()V", "DEFAULT", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "sdk-bundle_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @JvmStatic
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, 127, null);
            }
        }
    }
}

