/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera.sensor;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import net.doo.snap.camera.sensor.SignificantMoveListener;

public class SignificantMoveCatcher
implements SensorEventListener {
    private SensorManager sensorManager;
    private Sensor accelerometer;
    private float[] gravity;
    private float acceleration;
    private float currentAcceleration;
    private float lastAcceleration;
    private SignificantMoveListener moveListener = null;

    public SignificantMoveCatcher(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.accelerometer = this.sensorManager.getDefaultSensor(1);
        this.acceleration = 0.0f;
        this.currentAcceleration = 9.80665f;
        this.lastAcceleration = 9.80665f;
    }

    private void registerSensorListener() {
        Sensor sensor = this.accelerometer;
        if (sensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this, sensor, 2);
        }
    }

    private void unregisterSensorListener() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void registerSignificantMoveListener(SignificantMoveListener listener) {
        void var1_1;
        if (listener != null && this.moveListener != var1_1) {
            this.moveListener = var1_1;
            this.registerSensorListener();
        }
    }

    public void unregisterSignificantMoveListener(SignificantMoveListener listener) {
        this.moveListener = null;
        this.unregisterSensorListener();
    }

    /*
     * WARNING - void declaration
     */
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            void var1_1;
            SignificantMoveCatcher significantMoveCatcher = this;
            significantMoveCatcher.gravity = (float[])var1_1.values.clone();
            float f = significantMoveCatcher.gravity[0];
            float f2 = significantMoveCatcher.gravity[1];
            float f3 = significantMoveCatcher.gravity[2];
            float f4 = f2;
            float f5 = f;
            this.lastAcceleration = this.currentAcceleration;
            f = f5 * f5;
            f = f4 * f4 + f;
            significantMoveCatcher.currentAcceleration = (float)Math.sqrt(f3 * f3 + f);
            f = significantMoveCatcher.currentAcceleration - this.lastAcceleration;
            significantMoveCatcher.acceleration = significantMoveCatcher.acceleration * 0.9f + f;
            SignificantMoveListener significantMoveListener = significantMoveCatcher.moveListener;
            if (significantMoveListener != null && this.acceleration > significantMoveListener.getSignificantMoveThreshold()) {
                this.moveListener.onSignificantMove();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

