/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.dcscanner;

import android.content.Context;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class DCScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private DCScanner dcScanner;
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    private boolean enabled;

    public static DCScannerFrameHandler attach(ScanbotCameraView cameraView, DCScanner dcScanner) {
        DCScannerFrameHandler dCScannerFrameHandler;
        DCScannerFrameHandler dCScannerFrameHandler2 = dCScannerFrameHandler;
        dCScannerFrameHandler2(cameraView.getContext(), dcScanner);
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)dCScannerFrameHandler2);
        return dCScannerFrameHandler;
    }

    public DCScannerFrameHandler(Context context, DCScanner dcScanner) {
        DCScannerFrameHandler dCScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        dCScannerFrameHandler.dcScanner = dcScanner;
        dCScannerFrameHandler.sapManager = SapSingleton.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean notifyHandlers(FrameHandlerResult<DisabilityCertificateRecognizerResultInfo, SdkLicenseError> result) {
        DCScannerFrameHandler dCScannerFrameHandler = this_;
        boolean this_ = false;
        Set<ResultHandler> set = dCScannerFrameHandler.handlers;
        synchronized (set) {
            int n;
            Iterator<ResultHandler> iterator = dCScannerFrameHandler.handlers.iterator();
            while (true) {
                void var1_2;
                if (!iterator.hasNext()) break;
                n |= iterator.next().handle((FrameHandlerResult)var1_2);
                continue;
                break;
            }
            return n != 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        void var1_1;
        DCScannerFrameHandler dCScannerFrameHandler = this_;
        dCScannerFrameHandler.logger.logMethod();
        if (!dCScannerFrameHandler.enabled) {
            return false;
        }
        if (!this_.sapManager.checkLicenseStatus(SdkFeature.DisabilityCertRecognition).booleanValue()) {
            this_.notifyHandlers((FrameHandlerResult<DisabilityCertificateRecognizerResultInfo, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        DCScannerFrameHandler dCScannerFrameHandler2 = this_;
        DCScannerFrameHandler this_ = dCScannerFrameHandler2.dcScanner.recognizeDC(var1_1.frame, var1_1.width, var1_1.height, var1_1.frameOrientation);
        return dCScannerFrameHandler2.notifyHandlers((FrameHandlerResult<DisabilityCertificateRecognizerResultInfo, SdkLicenseError>)new FrameHandlerResult.Success((Object)this_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.remove(var1_1);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static interface ResultHandler
    extends BaseResultHandler<DisabilityCertificateRecognizerResultInfo, SdkLicenseError> {
    }
}

