/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.injection;

import android.app.ActivityManager;
import android.app.Application;
import android.app.DownloadManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.preference.PreferenceManager;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;

@Module
public class AndroidModule {
    private final Application application;

    public AndroidModule(Application application) {
        this.application = application;
    }

    @Provides
    @Singleton
    public Context providesContext() {
        return this.application;
    }

    @Provides
    @Singleton
    public Application providesApplication() {
        return this.application;
    }

    @Provides
    @Singleton
    public Resources providesResources() {
        return this.application.getResources();
    }

    @Provides
    @Singleton
    public DownloadManager providesDownloadManager() {
        return (DownloadManager)this.application.getSystemService("download");
    }

    @Provides
    @Singleton
    public SharedPreferences providesSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.application);
    }

    @Provides
    @Singleton
    public ActivityManager providesActivityManager() {
        AndroidModule this_ = (ActivityManager)this_.application.getSystemService("activity");
        if (this_ != null) {
            return this_;
        }
        throw new UnsupportedOperationException("Could not retrieve ActivityManager");
    }

    @Provides
    @Singleton
    public AssetManager providesAssetManager() {
        return this.application.getAssets();
    }

    @Provides
    @Singleton
    public PackageManager providesPackageManager() {
        return this.application.getPackageManager();
    }
}

