/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.injection;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Resources;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import io.scanbot.multipleobjectsscanner.DefaultMultipleObjectsDetector;
import io.scanbot.multipleobjectsscanner.MultipleObjectsDetector;
import io.scanbot.multipleobjectsscanner.StubMultipleObjectsDetector;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.StubScanbotBarcodeDetector;
import io.scanbot.sdk.businesscard.BusinessCardsImageProcessor;
import io.scanbot.sdk.businesscard.DefaultBusinessCardsImageProcessor;
import io.scanbot.sdk.businesscard.StubBusinessCardsImageProcessor;
import io.scanbot.sdk.filterpredictor.FilterPredictor;
import io.scanbot.sdk.filterpredictor.ScanbotFilterPredictor;
import io.scanbot.sdk.filterpredictor.StubFilterPredictor;
import io.scanbot.sdk.hicscanner.DefaultHealthInsuranceCardScanner;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import io.scanbot.sdk.hicscanner.StubHealthInsuranceCardScanner;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.ScanbotOpticalCharacterRecognizer;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.PDFRenderer;
import io.scanbot.sdk.process.PageProcessor;
import io.scanbot.sdk.process.ScanbotPDFRenderer;
import io.scanbot.sdk.textorientation.DefaultTextOrientationScanner;
import io.scanbot.sdk.textorientation.StubTextOrientationScanner;
import io.scanbot.sdk.textorientation.TextOrientationScanner;
import io.scanbot.tiffwriter.TIFFWriter;
import javax.inject.Singleton;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.chequescanner.ChequeScanner;
import net.doo.snap.chequescanner.DefaultChequeScanner;
import net.doo.snap.chequescanner.StubChequeScanner;
import net.doo.snap.connectivity.BlobsStorage;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.dcscanner.DefaultDCScanner;
import net.doo.snap.dcscanner.StubDCScanner;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.ImageProcessorBitmapBinarizer;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.OcrSettings;
import net.doo.snap.intelligence.StubLanguageProvider;
import net.doo.snap.intelligence.StubTextRecognition;
import net.doo.snap.intelligence.TextRecognizerFactory;
import net.doo.snap.intelligence.UserLanguageProvider;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.mrzscanner.DefaultMRZScanner;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.mrzscanner.StubMRZScanner;
import net.doo.snap.payformscanner.DefaultPayFormScanner;
import net.doo.snap.payformscanner.PayFormScanner;
import net.doo.snap.payformscanner.StubPayFormScanner;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.BaseUnreferencedSourcesProvider;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.DocumentProcessor;
import net.doo.snap.process.DocumentProcessorMonitor;
import net.doo.snap.process.DocumentProcessorProvider;
import net.doo.snap.process.PageProcessorMonitor;
import net.doo.snap.process.ProcessingInfoProvider;
import net.doo.snap.process.ProcessorMonitor;
import net.doo.snap.process.StubProcessingInfoProvider;
import net.doo.snap.process.TextRecognition;
import net.doo.snap.process.compose.BaseComposerFactory;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.OcrComposer;
import net.doo.snap.process.compose.P2ComposerFactory;
import net.doo.snap.process.compose.PageComposerFactory;
import net.doo.snap.process.compose.PageComposerFactoryImpl;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.process.draft.CombinedDocumentDraftExtractor;
import net.doo.snap.process.draft.CompositeDraftExtractor;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.draft.MultipleDocumentsDraftExtractor;
import net.doo.snap.security.SapProvider;
import net.doo.snap.util.bitmap.BitmapLruCache;

@Module
public class ScanbotSdkModule {
    public static DocumentDraftExtractor documentDraftExtractor;
    public static UnreferencedSourcesProvider unreferencedSourcesProvider;
    public static OcrSettings ocrSettings;

    private boolean isP2() {
        try {
            Class.forName("net.doo.snap.P2Module");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private boolean isP3() {
        try {
            Class.forName("net.doo.snap.P3Module");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private boolean isP4() {
        try {
            Class.forName("net.doo.snap.P4Module");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    @Provides
    BarcodeFileStorage providesBarcodeFileStorage(Application application) {
        return new BarcodeFileStorage(application);
    }

    @Provides
    public BlobStoreStrategy providesBlobStoreStrategy(Application application, SharedPreferences preferences) {
        return new BlobStoreStrategy(application, preferences);
    }

    @Provides
    public BlobsStorage providesBlobsStorage(SharedPreferences preferences) {
        return new BlobsStorage(preferences);
    }

    @Provides
    public BlobFactory providesBlobFactory(BlobStoreStrategy blobStoreStrategy, BlobsStorage blobsStorage, AssetManager assetManager) {
        return new BlobFactory(blobStoreStrategy, blobsStorage, assetManager);
    }

    @Provides
    public BlobManager providesBlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        return new BlobManager(blobStoreStrategy, assetManager, blobFactory);
    }

    @Provides
    public PageComposerFactory providesPageComposerFactory(ContourDetector contourDetector, PageStoreStrategy pageStoreStrategy, Resources resources) {
        return new PageComposerFactoryImpl(contourDetector, pageStoreStrategy, resources);
    }

    @Provides
    public ProcessorMonitor<Page> providesPageProcessorMonitor() {
        return new PageProcessorMonitor();
    }

    @Provides
    public ProcessorMonitor<Document> providesDocumentProcessorMonitor(DocumentStoreStrategy documentStoreStrategy) {
        return new DocumentProcessorMonitor(documentStoreStrategy);
    }

    @Provides
    public ProcessingInfoProvider providesProcessingInfoProvider() {
        return new StubProcessingInfoProvider();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public UnreferencedSourcesProvider providesUnreferencedSourcesProvider(PageStoreStrategy pageStoreStrategy) {
        Object this_ = unreferencedSourcesProvider;
        if (this_ == null) {
            void var1_1;
            BaseUnreferencedSourcesProvider baseUnreferencedSourcesProvider;
            this_ = baseUnreferencedSourcesProvider;
            baseUnreferencedSourcesProvider = new BaseUnreferencedSourcesProvider((PageStoreStrategy)var1_1);
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public DocumentDraftExtractor providesDocumentDraftExtractor(CombinedDocumentDraftExtractor combinedDocumentDraftExtractor, MultipleDocumentsDraftExtractor multipleDocumentsDraftExtractor) {
        Object this_ = documentDraftExtractor;
        if (this_ == null) {
            void var2_2;
            void var1_1;
            CompositeDraftExtractor compositeDraftExtractor;
            this_ = compositeDraftExtractor;
            compositeDraftExtractor = new CompositeDraftExtractor((CombinedDocumentDraftExtractor)var1_1, (MultipleDocumentsDraftExtractor)var2_2);
        }
        return this_;
    }

    @Provides
    @Singleton
    public SapManager providesSapManager(Application application) {
        return new SapProvider(application).get();
    }

    @Provides
    public DocumentProcessor providesDocumentProcessor(SapManager sapManager, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, ProcessorMonitor<Document> documentProcessorMonitor, Cleaner cleaner) {
        return new DocumentProcessorProvider(sapManager, documentStoreStrategy, pageStoreStrategy, resources, bitmapLruCache, composerFactory, documentProcessorMonitor, cleaner).get();
    }

    @Provides
    @Singleton
    public BitmapLruCache provideBitmapLruCache(ActivityManager manager) {
        return new BitmapLruCache(manager);
    }

    @Provides
    public PageFactory providePageFactory(BitmapLruCache bitmapLruCache, PageStoreStrategy pageStoreStrategy) {
        return new PageFactory(bitmapLruCache, pageStoreStrategy);
    }

    @Provides
    public SimpleComposer provideSimpleComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
        return new SimpleComposer(documentStoreStrategy, pageStoreStrategy);
    }

    @Provides
    public DocumentStoreStrategy provideDocumentStoreStrategy(Context context, SharedPreferences preferences) {
        return new DocumentStoreStrategy(context, preferences);
    }

    @Provides
    public PageStoreStrategy providePageStoreStrategy(Application application, SharedPreferences preferences) {
        return new PageStoreStrategy(application, preferences);
    }

    @Provides
    public OcrPdfRenderer provideOcrPdfRenderer(Context context, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, BlobStoreStrategy blobStoreStrategy, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        return new OcrPdfRenderer(context, documentStoreStrategy, pageStoreStrategy, blobStoreStrategy, bitmapBinarizer);
    }

    @Provides
    public TextRecognizerFactory provideTextRecognizerFactory(SapManager sapManager, OcrPdfRenderer pdfRenderer, DocumentStoreStrategy documentStoreStrategy, SimpleComposer simpleComposer, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, OcrSettings ocrSettings, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        return new TextRecognizerFactory(sapManager, pdfRenderer, documentStoreStrategy, simpleComposer, blobStoreStrategy, pageStoreStrategy, ocrSettings, bitmapBinarizer);
    }

    @Provides
    public OcrComposer provideOcrComposer(DocumentStoreStrategy documentStoreStrategy, BlobManager blobManager, OcrPdfRenderer pdfRenderer, SimpleComposer simpleComposer, SapManager sapManager, OcrSettings ocrSettings) {
        return new OcrComposer(documentStoreStrategy, blobManager, pdfRenderer, simpleComposer, sapManager, ocrSettings);
    }

    @Provides
    public ContourDetector providesContourDetector() {
        return new ContourDetector();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public ScanbotBarcodeDetector scanbotBarcodeDetector(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (sapManager.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            void var2_2;
            return new DefaultScanbotBarcodeDetector((BlobManager)var2_2);
        }
        return new StubScanbotBarcodeDetector((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public TextRecognition providesTextRecognition(SapManager sapManager, Lazy<TextRecognizerFactory> textRecognizerFactory) {
        void var1_1;
        if (this.isP2() && var1_1.checkLicenseStatusSilently(SdkFeature.OCR)) {
            void var2_2;
            return (TextRecognition)var2_2.get();
        }
        return new StubTextRecognition((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public ComposerFactory providesComposerFactory(SapManager sapManager, Lazy<BaseComposerFactory> baseComposerFactory, Lazy<P2ComposerFactory> p2ComposerFactory) {
        void var2_2;
        void var1_1;
        if (this.isP2() && var1_1.checkLicenseStatusSilently(SdkFeature.OCR)) {
            void var3_3;
            return (ComposerFactory)var3_3.get();
        }
        return (ComposerFactory)var2_2.get();
    }

    @Provides
    public PDFRenderer pdfRenderer(Context context, DocumentDraftExtractor documentDraftExtractor, PageFactory pageFactory, DocumentProcessor documentProcessor, PageFileStorage pageFileStorage, Cleaner cleaner, SapManager sapManager) {
        return new ScanbotPDFRenderer(context, documentDraftExtractor, pageFactory, documentProcessor, pageFileStorage, cleaner, sapManager);
    }

    @Provides
    @Singleton
    public OcrSettings provideOcrSettings() {
        ScanbotSdkModule this_ = ocrSettings;
        if (this_ == null) {
            this_ = new OcrSettings.Builder().build();
        }
        return this_;
    }

    @Provides
    OcrPdfRenderer.BitmapBinarizer providesBitmapBinarizer(ImageProcessorBitmapBinarizer bitmapBinarizer) {
        return bitmapBinarizer;
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public OpticalCharacterRecognizer ocrRecogniser(SapManager sapManager, TextRecognition textRecognition, PageFactory pageFactory, BlobManager blobManager, PageFileStorage pageFileStorage) {
        StubTextRecognition stubTextRecognition;
        void var5_5;
        void var4_4;
        void var3_3;
        void var1_1;
        if (((ScanbotSdkModule)((Object)this_)).isP2() && var1_1.checkLicenseStatusSilently(SdkFeature.OCR)) {
            void var2_2;
            return new ScanbotOpticalCharacterRecognizer((TextRecognition)var2_2, (PageFactory)var3_3, (BlobManager)var4_4, (PageFileStorage)var5_5);
        }
        StubTextRecognition this_ = stubTextRecognition;
        this_((SapManager)var1_1);
        return new ScanbotOpticalCharacterRecognizer(stubTextRecognition, (PageFactory)var3_3, (BlobManager)var4_4, (PageFileStorage)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    public LanguageProvider providesLanguageProvider(SapManager sapManager, Lazy<UserLanguageProvider> provider) {
        void var1_1;
        if (this.isP2() && var1_1.checkLicenseStatusSilently(SdkFeature.OCR)) {
            void var2_2;
            return (LanguageProvider)var2_2.get();
        }
        return new StubLanguageProvider();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public TextOrientationScanner textOrientationRecognizer(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (this.isP2() && var1_1.checkLicenseStatusSilently(SdkFeature.TextOrientationDetection)) {
            void var2_2;
            return new DefaultTextOrientationScanner((BlobManager)var2_2);
        }
        return new StubTextOrientationScanner((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public PayFormScanner providesPayFormScanner(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (this.isP3() && var1_1.checkLicenseStatusSilently(SdkFeature.PayformDetection)) {
            void var2_2;
            return new DefaultPayFormScanner((BlobManager)var2_2);
        }
        return new StubPayFormScanner((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public MRZScanner providesMRZScanner(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (this.isP3() && var1_1.checkLicenseStatusSilently(SdkFeature.MRZRecognition)) {
            void var2_2;
            return new DefaultMRZScanner((BlobManager)var2_2);
        }
        return new StubMRZScanner((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public HealthInsuranceCardScanner providesHICScanner(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (this.isP3() && var1_1.checkLicenseStatusSilently(SdkFeature.EHICRecognition)) {
            void var2_2;
            return new DefaultHealthInsuranceCardScanner((BlobManager)var2_2);
        }
        return new StubHealthInsuranceCardScanner((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public DCScanner providesDCScanner(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (this.isP4() && var1_1.checkLicenseStatusSilently(SdkFeature.DisabilityCertRecognition)) {
            void var2_2;
            return new DefaultDCScanner((BlobManager)var2_2);
        }
        return new StubDCScanner((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public ChequeScanner providesChequeScanner(SapManager sapManager, BlobManager blobManager) {
        void var1_1;
        if (this.isP4() && var1_1.checkLicenseStatusSilently(SdkFeature.Cheque)) {
            void var2_2;
            return new DefaultChequeScanner((BlobManager)var2_2);
        }
        return new StubChequeScanner((SapManager)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public FilterPredictor providesFilterPredictor(SapManager sapManager, BlobManager blobManager) {
        if (this.isP4()) {
            void var2_2;
            return new ScanbotFilterPredictor((BlobManager)var2_2);
        }
        return new StubFilterPredictor();
    }

    @Provides
    public TIFFWriter providesTiffWriter() {
        return new TIFFWriter();
    }

    @Provides
    public PageProcessor providesPageProcessor(Context context, PageFileStorage pageFileStorage, ImageProcessor imageProcessor) {
        return new PageProcessor(context, pageFileStorage, imageProcessor);
    }

    @Provides
    @Singleton
    public ImageProcessor providesImageProcessor() {
        return new ImageProcessor();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public MultipleObjectsDetector providesMultipleObjectsDetector(SapManager sapManager) {
        void var1_1;
        if (this.isP4() && var1_1.checkLicenseStatusSilently(SdkFeature.MultipleObjectsDetection)) {
            return new DefaultMultipleObjectsDetector();
        }
        return new StubMultipleObjectsDetector();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    public BusinessCardsImageProcessor providesBusinessCardsProcessor(OpticalCharacterRecognizer opticalCharacterRecognizer, PageFileStorage pageFileStorage, PageProcessor pageProcessor, TextOrientationScanner textOrientationScanner) {
        if (this.isP4()) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            return new DefaultBusinessCardsImageProcessor((OpticalCharacterRecognizer)var1_1, (PageFileStorage)var2_2, (PageProcessor)var3_3, (TextOrientationScanner)var4_4);
        }
        return new StubBusinessCardsImageProcessor();
    }
}

