/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.inject.Inject;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.source.KeyboardLanguageSource;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class UserLanguageProvider
implements LanguageProvider {
    private final Logger logger;
    private final ArrayList<LanguageSource> sources;

    @Inject
    public UserLanguageProvider(Context context) {
        UserLanguageProvider userLanguageProvider = this;
        userLanguageProvider.logger = LoggerProvider.getLogger();
        userLanguageProvider.sources = new ArrayList();
        userLanguageProvider.sources.add(new KeyboardLanguageSource(context));
        userLanguageProvider.sources.add(new DefaultLanguageSource());
    }

    public UserLanguageProvider(LanguageSource[] sources) {
        UserLanguageProvider userLanguageProvider = this;
        userLanguageProvider.logger = LoggerProvider.getLogger();
        userLanguageProvider.sources = new ArrayList();
        userLanguageProvider.sources.addAll(Arrays.asList(sources));
    }

    @Override
    @NotNull
    public Language getMostCommonLanguage() {
        Language language = null;
        try {
            language = Language.languageByIso((String)Locale.getDefault().getISO3Language());
        }
        catch (MissingResourceException missingResourceException) {
            this.logger.logException((Throwable)missingResourceException);
        }
        if (language == null) {
            language = Language.ENG;
        }
        return language;
    }

    private class DefaultLanguageSource
    implements LanguageSource {
        private DefaultLanguageSource() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Collection<Language> getLanguages() {
            HashSet<Language> hashSet;
            HashSet<Language> hashSet2;
            HashSet<Language> hashSet3 = hashSet2 = hashSet;
            hashSet3();
            hashSet3.add(Language.ENG);
            hashSet.add(UserLanguageProvider.this.getMostCommonLanguage());
            Language language = Language.languageByIso((String)Locale.getDefault().getISO3Language());
            if (language == null) return hashSet2;
            try {
                hashSet2.add(language);
            }
            catch (MissingResourceException missingResourceException) {
                UserLanguageProvider.this.logger.logException((Throwable)missingResourceException);
            }
            return hashSet2;
        }
    }

    public static interface LanguageSource {
        public Collection<Language> getLanguages();
    }
}

