/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence.source;

import android.content.Context;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.UserLanguageProvider;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class KeyboardLanguageSource
implements UserLanguageProvider.LanguageSource {
    private static final String IME_SUBTYPE_MODE_KEYBOARD = "keyboard";
    private static final String CHINESE_SIMPLIFIED = "zh_cn";
    private static final String CHINISE_TRADITIONAL = "zh_tw";
    private final Context context;
    private final Logger logger = LoggerProvider.getLogger();

    public KeyboardLanguageSource(Context context) {
        this.context = context;
    }

    private Set<Language> getKeyboardLanguages() {
        HashSet<Language> hashSet;
        HashSet<Language> hashSet2 = hashSet;
        hashSet = new HashSet<Language>();
        InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
        Iterator iterator = inputMethodManager.getEnabledInputMethodList().iterator();
        while (iterator.hasNext()) {
            for (Object object : inputMethodManager.getEnabledInputMethodSubtypeList((InputMethodInfo)iterator.next(), true)) {
                block11: {
                    block10: {
                        if (!object.getMode().equals(IME_SUBTYPE_MODE_KEYBOARD)) continue;
                        try {
                            object = object.getLocale();
                        }
                        catch (MissingResourceException missingResourceException) {
                            this.logger.logException((Throwable)missingResourceException);
                            continue;
                        }
                        Language language = Language.languageByIso((String)new Locale((String)object).getISO3Language());
                        if (language == null) break block10;
                        hashSet2.add(language);
                    }
                    if (((String)object).equalsIgnoreCase(CHINESE_SIMPLIFIED)) break block11;
                    if (!((String)object).equalsIgnoreCase(CHINISE_TRADITIONAL)) continue;
                }
                HashSet<Language> hashSet3 = hashSet2;
                HashSet<Language> hashSet4 = hashSet3;
                hashSet3.add(Language.CHI_SIM);
                hashSet4.add(Language.CHI_TRA);
            }
        }
        return hashSet2;
    }

    @Override
    public Collection<Language> getLanguages() {
        return this.getKeyboardLanguages();
    }
}

