/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class MRZScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private MRZScanner mrzScanner;
    private final Set<ResultHandler> handlers;
    protected final SapManager sapManager;
    private final Logger logger;
    protected boolean enabled;

    public static MRZScannerFrameHandler attach(ScanbotCameraView cameraView, MRZScanner mrzScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler;
        MRZScannerFrameHandler mRZScannerFrameHandler2 = mRZScannerFrameHandler;
        mRZScannerFrameHandler2(cameraView.getContext(), mrzScanner);
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)mRZScannerFrameHandler2);
        return mRZScannerFrameHandler;
    }

    public MRZScannerFrameHandler(Context context, MRZScanner mrzScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        this.handlers = new LinkedHashSet<ResultHandler>();
        this.logger = LoggerProvider.getLogger();
        this.enabled = true;
        mRZScannerFrameHandler.mrzScanner = mrzScanner;
        mRZScannerFrameHandler.sapManager = SapSingleton.getInstance();
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        MRZRecognitionResult mRZRecognitionResult;
        MRZScannerFrameHandler mRZScannerFrameHandler = this;
        mRZScannerFrameHandler.logger.logMethod();
        if (!mRZScannerFrameHandler.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.MRZRecognition).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        Rect rect = mRZRecognitionResult.finderRect;
        mRZRecognitionResult = rect == null ? this.mrzScanner.recognizeMRZ(mRZRecognitionResult.frame, mRZRecognitionResult.width, mRZRecognitionResult.height, mRZRecognitionResult.frameOrientation) : this.mrzScanner.recognizeMRZWithFinderOverlay(mRZRecognitionResult.frame, mRZRecognitionResult.width, mRZRecognitionResult.height, mRZRecognitionResult.frameOrientation, rect, false);
        return this.notifyHandlers((FrameHandlerResult<MRZRecognitionResult, SdkLicenseError>)new FrameHandlerResult.Success((Object)mRZRecognitionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            void var1_1;
            this.handlers.remove(var1_1);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected boolean notifyHandlers(FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> result) {
        MRZScannerFrameHandler mRZScannerFrameHandler = this_;
        boolean this_ = false;
        Set<ResultHandler> set = mRZScannerFrameHandler.handlers;
        synchronized (set) {
            int n;
            Iterator<ResultHandler> iterator = mRZScannerFrameHandler.handlers.iterator();
            while (true) {
                void var1_2;
                if (!iterator.hasNext()) break;
                n |= iterator.next().handle((FrameHandlerResult)var1_2);
                continue;
                break;
            }
            return n != 0;
        }
    }

    public static interface ResultHandler
    extends BaseResultHandler<MRZRecognitionResult, SdkLicenseError> {
    }
}

