/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence.cleanup;

import android.util.Pair;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import java.util.Iterator;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.ProcessingInfoProvider;
import net.doo.snap.process.util.DocumentDraft;

public class Cleaner {
    private final UnreferencedSourcesProvider unreferencedSourcesProvider;
    private final PageStoreStrategy pageStoreStrategy;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final ProcessingInfoProvider processingInfoProvider;
    private final PageStorageProcessor pageStorageProcessor;

    @Inject
    public Cleaner(UnreferencedSourcesProvider unreferencedSourcesProvider, PageStoreStrategy pageStoreStrategy, DocumentStoreStrategy documentStoreStrategy, ProcessingInfoProvider processingInfoProvider, PageStorageProcessor pageStorageProcessor) {
        this.unreferencedSourcesProvider = unreferencedSourcesProvider;
        this.pageStoreStrategy = pageStoreStrategy;
        this.documentStoreStrategy = documentStoreStrategy;
        this.processingInfoProvider = processingInfoProvider;
        this.pageStorageProcessor = pageStorageProcessor;
    }

    public void cleanUp() {
        for (Pair<String, String> object : this.unreferencedSourcesProvider.getUnreferencedDocuments()) {
            this.documentStoreStrategy.eraseDocument((String)object.first, (String)object.second);
        }
        for (String string : this.unreferencedSourcesProvider.getUnreferencedSDKPages()) {
            this.pageStoreStrategy.erasePage(string);
        }
        Iterator<Object> iterator = this.processingInfoProvider.getProcessedDocuments().iterator();
        while (iterator.hasNext()) {
            this.cleanUpPagesData(((DocumentDraft)iterator.next()).getPages());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void cleanUpPagesData(net.doo.snap.entity.Page[] pages) {
        int n = pages.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            void var4_4 = var1_1[i];
            this.pageStoreStrategy.eraseTempPageData(var4_4.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void cleanUpPagesData(Page[] pages) {
        int n = pages.length;
        for (int i = 0; i < n; ++i) {
            void var1_1;
            void var4_4 = var1_1[i];
            this.pageStorageProcessor.erasePageData((Page)var4_4);
        }
    }

    public void cleanUpDocumentData(Document document) {
        this.documentStoreStrategy.eraseDocument(document.getId(), document.getName());
    }

    public void cleanUpDocumentThumbnail(Document document) {
        this.documentStoreStrategy.eraseDocumentThumbnail(document.getId());
    }
}

