/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import net.doo.snap.R;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.ProcessorMonitor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class DocumentProcessor {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final BitmapLruCache bitmapLruCache;
    private final ComposerFactory composerFactory;
    private final ThumbnailGenerator thumbnailGenerator;
    private final ProcessorMonitor<Document> documentProcessorMonitor;
    private final Cleaner cleaner;
    private final Logger logger;

    @Inject
    public DocumentProcessor(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, ProcessorMonitor<Document> documentProcessorMonitor, Cleaner cleaner) {
        DocumentProcessor documentProcessor = this;
        this.logger = LoggerProvider.getLogger();
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.bitmapLruCache = bitmapLruCache;
        this.composerFactory = composerFactory;
        this.documentProcessorMonitor = documentProcessorMonitor;
        documentProcessor.cleaner = cleaner;
        documentProcessor.thumbnailGenerator = new ThumbnailGenerator(resources, documentStoreStrategy, pageStoreStrategy);
    }

    /*
     * WARNING - void declaration
     */
    private void performProcessing(Document document, Page[] pages) throws IOException {
        void var1_1;
        void var2_2;
        this.documentStoreStrategy.ensureDocumentDirectory(document.getId());
        if (document.getSize() < 0L) {
            for (int i = 0; i < ((void)var2_2).length; ++i) {
                void var4_5 = var2_2[i];
                if (i != 0) continue;
                this.thumbnailGenerator.generateThumbnail((Document)var1_1, (Page)var4_5);
            }
        }
        Composer composer = this.composerFactory.composerForDocument((Document)var1_1);
        this.logger.d("Processing", "(" + var1_1.getName() + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument((Document)var1_1, (Page[])var2_2);
    }

    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        DocumentProcessor documentProcessor = this;
        Document document = documentDraft.getDocument();
        documentDraft = documentDraft.getPages();
        documentProcessor.performProcessing(document, documentDraft);
        documentProcessor.documentProcessorMonitor.onProcessed(document);
        documentProcessor.bitmapLruCache.evictAll();
        documentProcessor.cleaner.cleanUpPagesData(documentDraft);
        return new DocumentProcessingResult(document, Arrays.asList(documentDraft), this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName()));
    }

    private static class ThumbnailGenerator {
        private final Resources resources;
        private final DocumentStoreStrategy documentStoreStrategy;
        private PageStoreStrategy pageStoreStrategy;

        ThumbnailGenerator(Resources resources, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
            this.resources = resources;
            this.documentStoreStrategy = documentStoreStrategy;
            this.pageStoreStrategy = pageStoreStrategy;
        }

        /*
         * WARNING - void declaration
         */
        private void generateThumbnail(Document document, Page page) throws IOException {
            BitmapFactory.Options options;
            int n = (int)this.resources.getDimension(R.dimen.document_thumbnail_size);
            BitmapFactory.Options options2 = options;
            options2();
            options2.inJustDecodeBounds = true;
            String string = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED).getPath();
            BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options2);
            int n2 = Math.max(options.outHeight, options2.outWidth) / n;
            if (n2 < 1) {
                n2 = 1;
            }
            new BitmapFactory.Options().inSampleSize = n2;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)new BitmapFactory.Options());
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                void var1_1;
                void var2_2;
                this.saveRotatedAndScaledBitmap(var2_2.getRotationType().getDegrees(), n, bitmap, this.documentStoreStrategy.getThumbnailFile(var1_1.getId()));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void saveRotatedAndScaledBitmap(int rotation2, int maxDimension2, Bitmap original, File file) throws FileNotFoundException {
            void var1_5;
            FileOutputStream fileOutputStream;
            Matrix matrix;
            Bitmap bitmap = original;
            float this322 = (float)maxDimension2 / (float)Math.max(original.getWidth(), original.getHeight());
            Matrix maxDimension2 = matrix;
            float f = this322;
            maxDimension2();
            maxDimension2.preRotate((float)rotation2, (float)(original.getWidth() / 2), (float)(original.getHeight() / 2));
            matrix.postScale(f, f);
            int this322 = bitmap.getWidth();
            rotation2 = bitmap.getHeight();
            Bitmap this322 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)this322, (int)rotation2, (Matrix)maxDimension2, (boolean)true);
            FileOutputStream rotation2 = fileOutputStream;
            rotation2(file);
            try {
                this322.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_5);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)var1_5);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }
}

