/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.JpegComposer;
import net.doo.snap.process.compose.SimpleComposer;
import org.jetbrains.annotations.NotNull;

public class BaseComposerFactory
implements ComposerFactory {
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    @Inject
    public BaseComposerFactory(SimpleComposer simpleComposer, JpegComposer jpegComposer) {
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.simpleComposer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.jpegComposer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Composer composerForDocument(Document document) {
        void var1_1;
        if (document.getName().endsWith(".jpg")) {
            return this.buildJpegOrDummyComposer((Document)var1_1);
        }
        return this.buildSimpleOrDummyComposer((Document)var1_1);
    }
}

