/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.JpegComposer;
import net.doo.snap.process.compose.OcrComposer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.device.DeviceUtils;
import org.jetbrains.annotations.NotNull;

public class P2ComposerFactory
implements ComposerFactory {
    private final DeviceUtils deviceUtils;
    private final OcrComposer ocrComposer;
    private final SimpleComposer simpleComposer;
    private final JpegComposer jpegComposer;

    @Inject
    public P2ComposerFactory(DeviceUtils deviceUtils, OcrComposer ocrComposer, SimpleComposer simpleComposer, JpegComposer jpegComposer) {
        this.deviceUtils = deviceUtils;
        this.ocrComposer = ocrComposer;
        this.simpleComposer = simpleComposer;
        this.jpegComposer = jpegComposer;
    }

    private boolean isJpeg(Document document) {
        String this_ = document.getName().toLowerCase();
        return this_.endsWith(".jpg") || this_.endsWith(".jpeg");
    }

    private Composer buildSimpleOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.simpleComposer;
    }

    private Composer buildJpegOrDummyComposer(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        return this.jpegComposer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Composer composerForDocument(Document document) {
        void var1_1;
        if (this.isJpeg(document)) {
            return this.buildJpegOrDummyComposer((Document)var1_1);
        }
        OcrStatus ocrStatus = var1_1.getOcrStatus();
        if (ocrStatus == OcrStatus.PENDING_FORCED) {
            return this.ocrComposer;
        }
        if (ocrStatus == OcrStatus.PENDING_ON_CHARGER && this.deviceUtils.isDeviceOnCharger()) {
            return this.ocrComposer;
        }
        if (ocrStatus == OcrStatus.PENDING) {
            return this.ocrComposer;
        }
        return this.buildSimpleOrDummyComposer((Document)var1_1);
    }
}

