/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.draft;

import android.content.SharedPreferences;
import java.util.UUID;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;

public class MultipleDocumentsDraftExtractor
implements DocumentDraftExtractor {
    private final String extension;

    public static MultipleDocumentsDraftExtractor forPdf() {
        return new MultipleDocumentsDraftExtractor(".pdf");
    }

    public static MultipleDocumentsDraftExtractor forJpeg() {
        return new MultipleDocumentsDraftExtractor(".jpg");
    }

    @Inject
    public MultipleDocumentsDraftExtractor(SharedPreferences sharedPreferences) {
        String string = sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false) ? ".jpg" : ".pdf";
        this(string);
    }

    private MultipleDocumentsDraftExtractor(String extension) {
        this.extension = extension;
    }

    private Document createDocument(String name, int size) {
        Document document;
        MultipleDocumentsDraftExtractor multipleDocumentsDraftExtractor = this = document;
        multipleDocumentsDraftExtractor();
        multipleDocumentsDraftExtractor.setId(UUID.randomUUID().toString());
        this.setName(name);
        document.setPagesCount(size);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DocumentDraft[] extract(SnappingDraft draft) {
        DocumentDraft[] documentDraftArray = new DocumentDraft[draft.size()];
        for (int i = 0; i < documentDraftArray.length; ++i) {
            void var1_1;
            Document document = this.createDocument(var1_1.getDocumentName() + this.extension, 1);
            documentDraftArray[i] = new DocumentDraft(document, var1_1.getPage(i));
        }
        return documentDraftArray;
    }
}

