/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private final int magnifierDrawableResourceId;
    private Magnifier magnifier = new Magnifier();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;
    private boolean enableBounding;

    public MagnifierView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawableResourceId = typedArray.getResourceId(R.styleable.MagnifierView_magnifierImageSrc, 0);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            this.enableBounding = typedArray.getBoolean(R.styleable.MagnifierView_magnifierEnableBounding, true);
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
    }

    void drawMagnifier(PointF zoomPoint) {
        this.zoomPoint = zoomPoint;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setImageRotation(float rotation) {
        MagnifierView magnifierView = this;
        magnifierView.magnifier.setImageRotation(rotation);
        magnifierView.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView view) {
        MagnifierView magnifierView = this_;
        MagnifierView this_ = BitmapUtils.drawableToBitmap((Drawable)view.getDrawable());
        magnifierView.magnifier.setup((Bitmap)this_, view.getRotation(), -16777216);
        view.setMagnifier(magnifierView);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        void var1_1;
        MagnifierView magnifierView = this;
        super.dispatchDraw(canvas);
        PointF pointF = magnifierView.zoomPoint;
        if (pointF != null) {
            this.magnifier.draw((Canvas)var1_1, pointF);
        } else {
            var1_1.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        BitmapFactory.Options options;
        MagnifierView magnifierView = this;
        super.onAttachedToWindow();
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        magnifierView.magnifierFrameBitmap = BitmapFactory.decodeResource((Resources)magnifierView.getResources(), (int)this.magnifierDrawableResourceId, (BitmapFactory.Options)options2);
        if (magnifierView.magnifierFrameBitmap == null) {
            this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap((Drawable)this.getResources().getDrawable(this.magnifierDrawableResourceId));
        }
    }

    public void onDetachedFromWindow() {
        MagnifierView magnifierView = this;
        super.onDetachedFromWindow();
        magnifierView.magnifierFrameBitmap.recycle();
        magnifierView.magnifierFrameBitmap = null;
        magnifierView.magnifier.cleanup();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        MagnifierView magnifierView = this;
        super.onLayout(changed, left, top, right, bottom);
        magnifierView.magnifier.setViewDimensions(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
    }

    public void setEnableBounding(boolean enableBounding) {
        this.enableBounding = enableBounding;
    }

    private class Magnifier {
        private final float ZOOM;
        private float bitmapScale;
        private int viewWidth;
        private int viewHeight;
        private BitmapShader shader;
        private Paint shaderPaint;
        private Matrix matrix = new Matrix();
        private float offsetX;
        private float offsetY;
        private float rotation;
        private Bitmap magnifierBitmap;

        Magnifier() {
            this.ZOOM = 2.0f;
        }

        private Bitmap drawOutline(Bitmap bitmap3, int outlineColor2) {
            Paint paint;
            Canvas canvas;
            Magnifier this_ = canvas;
            Bitmap bitmap2 = bitmap3;
            this_(bitmap3);
            this_ = paint;
            this_();
            paint.setColor(outlineColor2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            float bitmap3 = bitmap2.getWidth() - 1;
            float outlineColor2 = bitmap2.getHeight() - 1;
            canvas.drawRect(0.0f, 0.0f, bitmap3, outlineColor2, (Paint)this_);
            return bitmap3;
        }

        /*
         * WARNING - void declaration
         */
        private boolean isInLeftTop(PointF point) {
            void var1_1;
            return (int)((float)(point.x + this.offsetX < (float)(this.magnifierBitmap.getWidth() >> 1) ? (var1_1.y + this.offsetY < (float)(this.magnifierBitmap.getHeight() >> 1) ? 1 : 4) : (var1_1.y + this.offsetY < (float)(this.magnifierBitmap.getHeight() >> 1) ? 2 : 3)) - (360.0f - this.rotation) % 360.0f / 90.0f) == 1;
        }

        /*
         * WARNING - void declaration
         */
        void setViewDimensions(int width, int height) {
            void var2_2;
            void var1_1;
            this.viewWidth = width;
            this.viewHeight = height;
            Bitmap bitmap = this.magnifierBitmap;
            if (bitmap != null && var1_1 != false && var2_2 != false) {
                Magnifier magnifier = this;
                magnifier.bitmapScale = Math.max((float)bitmap.getWidth() / (float)this.viewWidth, (float)this.magnifierBitmap.getHeight() / (float)this.viewHeight);
                magnifier.offsetX = ((float)magnifier.viewWidth - (float)this.magnifierBitmap.getWidth() / this.bitmapScale) / 2.0f;
                magnifier.offsetY = ((float)magnifier.viewHeight - (float)this.magnifierBitmap.getHeight() / this.bitmapScale) / 2.0f;
            }
        }

        /*
         * WARNING - void declaration
         */
        void setup(Bitmap bitmap, float rotation, int outsideColor) {
            if (BitmapUtils.isBitmapValid((Bitmap)bitmap)) {
                void var2_2;
                void var3_3;
                void var1_1;
                if (this.shader != null) {
                    this.cleanup();
                }
                Magnifier magnifier = this;
                Magnifier magnifier2 = this;
                magnifier2.magnifierBitmap = magnifier2.drawOutline((Bitmap)var1_1, (int)var3_3);
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                magnifier2.shader = new BitmapShader(this.magnifierBitmap, tileMode, tileMode);
                magnifier2.shaderPaint = new Paint();
                magnifier2.shaderPaint.setShader((Shader)this.shader);
                magnifier.rotation = var2_2;
                magnifier.setViewDimensions(magnifier.MagnifierView.this.getWidth() - MagnifierView.this.getPaddingLeft() - MagnifierView.this.getPaddingRight(), MagnifierView.this.getHeight() - MagnifierView.this.getPaddingTop() - MagnifierView.this.getPaddingBottom());
            }
        }

        void cleanup() {
            Bitmap bitmap = this.magnifierBitmap;
            if (bitmap != null) {
                bitmap.recycle();
            }
            Magnifier magnifier = this;
            magnifier.magnifierBitmap = null;
            magnifier.shaderPaint = null;
            magnifier.shader = null;
        }

        /*
         * WARNING - void declaration
         */
        void draw(Canvas canvas, PointF zoomPointF2) {
            void var1_1;
            float f;
            PointF pointF;
            Magnifier magnifier = this;
            PointF pointF2 = pointF;
            pointF = new PointF(zoomPointF2.x * (float)this.magnifierBitmap.getWidth(), zoomPointF2.y * (float)this.magnifierBitmap.getHeight());
            float zoomPointF2 = magnifier.MagnifierView.this.magnifierMargin;
            float f2 = magnifier.MagnifierView.this.magnifierMargin;
            if (magnifier.MagnifierView.this.enableBounding && this.isInLeftTop(pointF2)) {
                f = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            void v2 = var1_1;
            Magnifier magnifier2 = this;
            magnifier2.matrix.setScale(2.0f, 2.0f);
            magnifier2.matrix.postTranslate(-pointF2.x * 2.0f + MagnifierView.this.magnifierRaduis + f, -pointF2.y * 2.0f + MagnifierView.this.magnifierRaduis + f2);
            magnifier2.shader.setLocalMatrix(this.matrix);
            var1_1.save();
            var1_1.rotate(this.rotation, f + MagnifierView.this.magnifierRaduis, f2 + MagnifierView.this.magnifierRaduis);
            v2.drawCircle((float)(f + MagnifierView.this.magnifierRaduis), f2 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.shaderPaint);
            v2.restore();
            var1_1.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f, f2, null);
        }

        void setImageRotation(float rotation) {
            this.rotation = rotation;
        }
    }
}

