/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.snap;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.detector.Line2D;

public class PolygonHelper {
    private static final int MIN_EDGE_LENGTH_PX = 35;
    private float[] tmpPoints = new float[8];
    private Matrix matrix = new Matrix();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int rotation = 0;

    public static boolean checkPolygonSize(List<Point> polygon) {
        List<Point> list;
        return !polygon.isEmpty() && Math.abs(list.get((int)1).x - list.get((int)0).x) > 35 && Math.abs(list.get((int)2).x - list.get((int)3).x) > 35 && Math.abs(list.get((int)3).y - list.get((int)0).y) > 35 && Math.abs(list.get((int)2).y - list.get((int)1).y) > 35;
    }

    /*
     * WARNING - void declaration
     */
    public void setRotation(int degrees) {
        void var1_1;
        if (this.rotation == degrees) {
            return;
        }
        this.rotation = var1_1;
        this.matrix.setRotate((float)var1_1, 0.5f, 0.5f);
    }

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setLayout(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    /*
     * WARNING - void declaration
     */
    public void polygonToPoints(List<PointF> polygon, float[] points) {
        void var1_1;
        int n;
        for (n = 0; n < var1_1.size(); ++n) {
            PolygonHelper polygonHelper = this;
            int n2 = n * 2;
            polygonHelper.tmpPoints[n2] = ((PointF)var1_1.get((int)n)).x;
            polygonHelper.tmpPoints[n2 + 1] = ((PointF)var1_1.get((int)n)).y;
        }
        this.matrix.mapPoints(this.tmpPoints);
        for (n = 0; n < var1_1.size(); ++n) {
            int n3;
            int n4 = n * 4;
            int n5 = n3 = n4;
            int n6 = n3;
            int n7 = n3;
            PolygonHelper polygonHelper = this;
            n3 = polygonHelper.left;
            float f = n3;
            int n8 = polygonHelper.width;
            float[] fArray = this.tmpPoints;
            int n9 = n * 2;
            var2_2[n7] = (float)n8 * this.tmpPoints[n9] + f;
            PolygonHelper polygonHelper2 = this;
            int n10 = polygonHelper2.top;
            float f2 = n10;
            int n11 = polygonHelper2.height;
            var2_2[n6 + 1] = (float)n11 * fArray[n9 + 1] + f2;
            float f3 = n3;
            var2_2[n5 + 2] = (float)n8 * fArray[(n9 + 2) % 8] + f3;
            f3 = n10;
            var2_2[n4 + 3] = (float)n11 * fArray[(n9 + 3) % 8] + f3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getDrawingPolygon(List<PointF> polygon, List<PointF> drawingPolygon) {
        void var2_2;
        for (int i = 0; i < var2_2.size(); ++i) {
            void var1_1;
            PointF pointF = (PointF)var1_1.get(i);
            PointF pointF2 = (PointF)var2_2.get(i);
            pointF2.x = pointF.x * (float)this.width;
            pointF2.y = pointF.y * (float)this.height;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getPolygonFromDrawingPolygon(List<PointF> drawingPolygon, List<PointF> polygon) {
        void var1_1;
        for (int i = 0; i < var1_1.size(); ++i) {
            void var2_2;
            PointF pointF = (PointF)var2_2.get(i);
            PointF pointF2 = (PointF)var1_1.get(i);
            pointF.x = pointF2.x / (float)this.width;
            pointF.y = pointF2.y / (float)this.height;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Line2D> scaleLines(List<Line2D> lines) {
        void var1_1;
        ArrayList arrayList;
        ArrayList arrayList2 = lines;
        lines = arrayList;
        arrayList = new ArrayList();
        for (Line2D line2D : arrayList2) {
            PolygonHelper polygonHelper = this;
            float f = polygonHelper.left;
            line2D.getStart().x = (float)polygonHelper.width * line2D.getStart().x + f;
            PolygonHelper polygonHelper2 = this;
            f = polygonHelper2.top;
            line2D.getStart().y = (float)polygonHelper2.height * line2D.getStart().y + f;
            PolygonHelper polygonHelper3 = this;
            f = polygonHelper3.left;
            line2D.getEnd().x = (float)polygonHelper3.width * line2D.getEnd().x + f;
            PolygonHelper polygonHelper4 = this;
            f = polygonHelper4.top;
            line2D.getEnd().y = (float)polygonHelper4.height * line2D.getEnd().y + f;
            var1_1.add(line2D);
        }
        return var1_1;
    }

    public static class Line {
        private double a;
        private double b;
        private double c;
        private PointF intersectionPoint = new PointF();

        public PointF getIntersectionPoint(Line line) {
            PointF pointF = this_.intersectionPoint;
            Line line2 = this_;
            double d = line2.c;
            double d2 = line.b;
            double d3 = d * d2;
            double d4 = line2.b;
            double this_ = line.c;
            double d5 = line.a;
            double d6 = d4 * d5;
            double d7 = line2.a;
            pointF.x = (float)((d3 -= d4 * this_) / (d6 - d7 * d2));
            pointF.y = (float)((d7 * this_ - d * d5) / (d4 * d5 - d7 * d2));
            return pointF;
        }

        public void calculateLine(PointF start2, PointF end2) {
            float f = start2.y;
            float f2 = end2.y;
            this_.a = f - f2;
            float start2 = end2.x;
            float end2 = start2.x;
            this_.b = start2 - end2;
            float this_ = (end2 - start2) * f;
            this_.c = (f2 - f) * end2 + this_;
        }

        /*
         * WARNING - void declaration
         */
        public double getDistanceToPoint(PointF point) {
            void var1_2;
            if (this.a == 0.0 && this.b == 0.0) {
                return 0.0;
            }
            Line line = this;
            double d = line.a * (double)var1_2.x;
            Line line2 = this;
            double d2 = line2.a;
            double d3 = d2 * d2;
            double d4 = line2.b;
            return Math.abs(line.b * (double)var1_2.y + d + this.c) / Math.sqrt(d4 * d4 + d3);
        }
    }

    public static class Edge {
        public PointF pointA;
        public PointF pointB;
        public PointF pointFarA;
        public PointF pointFarB;
        public Line edgeLine = new Line();
        public Line lineA = new Line();
        public Line lineB = new Line();
        private PointF handle = new PointF();
        public float prevX;
        public float prevY;
        public boolean isDetectedLine = false;

        public float getAngleInDegrees() {
            PointF pointF = this22.pointB;
            Edge this22 = this22.pointA;
            float this22 = pointF.x - ((PointF)this22).x;
            return (float)(Math.toDegrees(Math.atan2(pointF.y - ((PointF)this22).y, this22)) + 90.0);
        }

        public PointF getHandle() {
            PointF pointF = this_.pointA;
            Edge this_ = this_.pointB;
            this_.handle.x = (pointF.x + ((PointF)this_).x) / 2.0f;
            this_.handle.y = (pointF.y + ((PointF)this_).y) / 2.0f;
            return this_.handle;
        }

        public boolean isHorizontal() {
            PointF pointF = this_.pointB;
            Edge this_ = this_.pointA;
            float f = pointF.y - ((PointF)this_).y;
            return Math.abs(pointF.x - ((PointF)this_).x) > Math.abs(f);
        }
    }
}

