/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.sdk.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.TextRecognition;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J$\u0010\u001a\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010\u001d\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J,\u0010 \u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "textRecognition", "Lnet/doo/snap/process/TextRecognition;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "blobManager", "Lnet/doo/snap/blob/BlobManager;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Lnet/doo/snap/process/TextRecognition;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "checkMissingLangs", "", "languages", "", "Lnet/doo/snap/entity/Language;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lnet/doo/snap/entity/Document;", "recognizeTextFromPages", "Lnet/doo/snap/process/OcrResult;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUris", "sdk-bundle_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    private final TextRecognition textRecognition;
    private final PageFactory pageFactory;
    private final BlobManager blobManager;
    private final PageFileStorage pageFileStorage;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable iterable = imageFileUris;
        TextRecognition textRecognition = this.textRecognition;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Uri uri = (Uri)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            net.doo.snap.entity.Page page = this.pageFactory.buildPage(UriKt.toFile((Uri)it));
            collection.add(page);
        }
        collection = (List)destination$iv$iv;
        OcrResult ocrResult = textRecognition.withoutPDF((List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable iterable = pages;
        TextRecognition textRecognition = this.textRecognition;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void newPage;
            net.doo.snap.entity.Page oldPage;
            Page page = (Page)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            net.doo.snap.entity.Page page2 = oldPage = this.pageFactory.buildPage(newPage.getPageId(), new File(this.pageFileStorage.getImageURI(newPage.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(newPage.getFilter());
            net.doo.snap.entity.Page page3 = oldPage;
            collection.add(page3);
        }
        collection = (List)destination$iv$iv;
        OcrResult ocrResult = textRecognition.withoutPDF((List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withoutP\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable iterable = imageFileUris;
        Document document = this.getPendingDocument();
        TextRecognition textRecognition = this.textRecognition;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            net.doo.snap.entity.Page oldPage;
            Uri uri = (Uri)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            net.doo.snap.entity.Page page = oldPage = this.pageFactory.buildPage(UriKt.toFile((Uri)it));
            Intrinsics.checkExpressionValueIsNotNull((Object)page, (String)"oldPage");
            page.setPageSize(pageSize);
            net.doo.snap.entity.Page page2 = oldPage;
            collection.add(page2);
        }
        collection = (List)destination$iv$iv;
        OcrResult ocrResult = textRecognition.withPDF(document, (List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        Collection<net.doo.snap.entity.Page> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        Intrinsics.checkParameterIsNotNull(languages, (String)"languages");
        this.checkMissingLangs(languages);
        Iterable iterable = pages;
        Document document = this.getPendingDocument();
        TextRecognition textRecognition = this.textRecognition;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void newPage;
            net.doo.snap.entity.Page oldPage;
            Page page = (Page)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            net.doo.snap.entity.Page page2 = oldPage = this.pageFactory.buildPage(newPage.getPageId(), new File(this.pageFileStorage.getImageURI(newPage.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
            page2.setImageFilterType(newPage.getFilter());
            oldPage.setPolygon(newPage.getPolygon());
            oldPage.setPageSize(pageSize);
            net.doo.snap.entity.Page page3 = oldPage;
            collection.add(page3);
        }
        collection = (List)destination$iv$iv;
        OcrResult ocrResult = textRecognition.withPDF(document, (List)collection, languages).recognize();
        Intrinsics.checkExpressionValueIsNotNull((Object)ocrResult, (String)"textRecognition.withPDF(\u2026ges\n        ).recognize()");
        return ocrResult;
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        File file = this.blobManager.getOCRBlobsDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
        return file;
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        Set set = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"blobManager.allLanguagesWithAvailableOcrBlobs");
        return set;
    }

    private final Document getPendingDocument() {
        Document document = new Document();
        boolean bl = false;
        boolean bl2 = false;
        Document $this$apply = document;
        boolean bl3 = false;
        $this$apply.setId(UUID.randomUUID().toString());
        $this$apply.setName($this$apply.getId() + ".pdf");
        $this$apply.setOcrStatus(OcrStatus.PENDING);
        return document;
    }

    private final void checkMissingLangs(Set<? extends Language> languages) {
        Set set = SetsKt.minus(languages, (Iterable)this.getInstalledLanguages());
        boolean bl = false;
        boolean bl2 = false;
        Set missingLangs = set;
        boolean bl3 = false;
        Collection collection = missingLangs;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new LanguageNotFoundException(missingLangs + " Provided set of languages was not presented on device");
        }
    }

    @Inject
    public ScanbotOpticalCharacterRecognizer(@NotNull TextRecognition textRecognition, @NotNull PageFactory pageFactory, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkParameterIsNotNull((Object)textRecognition, (String)"textRecognition");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        this.textRecognition = textRecognition;
        this.pageFactory = pageFactory;
        this.blobManager = blobManager;
        this.pageFileStorage = pageFileStorage;
    }
}

