/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.Context;
import android.net.Uri;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.process.PDFRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.process.DocumentProcessingResult;
import net.doo.snap.process.DocumentProcessor;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;
import net.doo.snap.util.FileChooserUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/process/ScanbotPDFRenderer;", "Lio/scanbot/sdk/process/PDFRenderer;", "context", "Landroid/content/Context;", "documentDraftExtractor", "Lnet/doo/snap/process/draft/DocumentDraftExtractor;", "pageFactory", "Lnet/doo/snap/persistence/PageFactory;", "documentProcessor", "Lnet/doo/snap/process/DocumentProcessor;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "cleaner", "Lnet/doo/snap/persistence/cleanup/Cleaner;", "sapManager", "Lio/scanbot/sap/SapManager;", "(Landroid/content/Context;Lnet/doo/snap/process/draft/DocumentDraftExtractor;Lnet/doo/snap/persistence/PageFactory;Lnet/doo/snap/process/DocumentProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lnet/doo/snap/persistence/cleanup/Cleaner;Lio/scanbot/sap/SapManager;)V", "renderDocumentFromImages", "Ljava/io/File;", "imageFileUris", "", "Landroid/net/Uri;", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "renderDocumentFromPages", "pages", "Lio/scanbot/sdk/persistence/Page;", "sdk-bundle_release"})
public final class ScanbotPDFRenderer
implements PDFRenderer {
    private final Context context;
    private final DocumentDraftExtractor documentDraftExtractor;
    private final PageFactory pageFactory;
    private final DocumentProcessor documentProcessor;
    private final PageFileStorage pageFileStorage;
    private final Cleaner cleaner;
    private final SapManager sapManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File renderDocumentFromImages(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize) {
        DocumentProcessingResult documentProcessingResult;
        Intrinsics.checkParameterIsNotNull(imageFileUris, (String)"imageFileUris");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        DocumentProcessingResult processedDocument = null;
        if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
            return null;
        }
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = imageFileUris;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void uri;
                net.doo.snap.entity.Page page;
                Uri uri2 = (Uri)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                net.doo.snap.entity.Page page2 = page = this.pageFactory.buildPage(new File(FileChooserUtils.getPath(this.context, (Uri)uri)));
                Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"page");
                page2.setPageSize(pageSize);
                net.doo.snap.entity.Page page3 = page;
                collection.add(page3);
            }
            List pages = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = pages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            net.doo.snap.entity.Page[] pageArray = thisCollection$iv.toArray(new net.doo.snap.entity.Page[0]);
            if (pageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            net.doo.snap.entity.Page[] pageArray2 = pageArray;
            net.doo.snap.entity.Page[] pageArray3 = Arrays.copyOf(pageArray2, pageArray2.length);
            SnappingDraft snappingDraft = new SnappingDraft(pageArray3);
            snappingDraft.setDocumentName(UUID.randomUUID().toString());
            DocumentDraft[] documentDraft = this.documentDraftExtractor.extract(snappingDraft);
            documentProcessingResult = processedDocument = this.documentProcessor.processDocument(documentDraft[0]);
        }
        catch (Throwable throwable) {
            this.cleaner.cleanUp();
            throw throwable;
        }
        if (documentProcessingResult != null) {
            DocumentProcessingResult documentProcessingResult2 = documentProcessingResult;
            boolean bl = false;
            boolean bl2 = false;
            DocumentProcessingResult it = documentProcessingResult2;
            boolean bl3 = false;
            this.cleaner.cleanUpDocumentThumbnail(it.getDocument());
        }
        this.cleaner.cleanUp();
        DocumentProcessingResult documentProcessingResult3 = processedDocument;
        return documentProcessingResult3 != null ? documentProcessingResult3.getDocumentFile() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public File renderDocumentFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize) {
        DocumentProcessingResult documentProcessingResult;
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        Intrinsics.checkParameterIsNotNull((Object)pageSize, (String)"pageSize");
        DocumentProcessingResult processedDocument = null;
        if (!this.sapManager.checkLicenseStatus(SdkFeature.PDFCreation).booleanValue()) {
            return null;
        }
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = pages;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void newPage;
                net.doo.snap.entity.Page oldPage;
                Page page = (Page)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                net.doo.snap.entity.Page page2 = oldPage = this.pageFactory.buildPage(newPage.getPageId(), new File(this.pageFileStorage.getImageURI(newPage.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()));
                Intrinsics.checkExpressionValueIsNotNull((Object)page2, (String)"oldPage");
                page2.setPageSize(pageSize);
                oldPage.setProcessed(false);
                oldPage.setImageFilterType(newPage.getFilter());
                oldPage.setPolygon(newPage.getPolygon());
                net.doo.snap.entity.Page page3 = oldPage;
                collection.add(page3);
            }
            List oldPages = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = oldPages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            net.doo.snap.entity.Page[] pageArray = thisCollection$iv.toArray(new net.doo.snap.entity.Page[0]);
            if (pageArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            net.doo.snap.entity.Page[] pageArray2 = pageArray;
            net.doo.snap.entity.Page[] pageArray3 = Arrays.copyOf(pageArray2, pageArray2.length);
            SnappingDraft snappingDraft = new SnappingDraft(pageArray3);
            snappingDraft.setDocumentName(UUID.randomUUID().toString());
            DocumentDraft[] documentDraft = this.documentDraftExtractor.extract(snappingDraft);
            documentProcessingResult = processedDocument = this.documentProcessor.processDocument(documentDraft[0]);
        }
        catch (Throwable throwable) {
            this.cleaner.cleanUp();
            throw throwable;
        }
        if (documentProcessingResult != null) {
            DocumentProcessingResult documentProcessingResult2 = documentProcessingResult;
            boolean bl = false;
            boolean bl2 = false;
            DocumentProcessingResult it = documentProcessingResult2;
            boolean bl3 = false;
            this.cleaner.cleanUpDocumentThumbnail(it.getDocument());
        }
        this.cleaner.cleanUp();
        DocumentProcessingResult documentProcessingResult3 = processedDocument;
        return documentProcessingResult3 != null ? documentProcessingResult3.getDocumentFile() : null;
    }

    @Inject
    public ScanbotPDFRenderer(@NotNull Context context, @NotNull DocumentDraftExtractor documentDraftExtractor, @NotNull PageFactory pageFactory, @NotNull DocumentProcessor documentProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull Cleaner cleaner, @NotNull SapManager sapManager) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)documentDraftExtractor, (String)"documentDraftExtractor");
        Intrinsics.checkParameterIsNotNull((Object)pageFactory, (String)"pageFactory");
        Intrinsics.checkParameterIsNotNull((Object)documentProcessor, (String)"documentProcessor");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)cleaner, (String)"cleaner");
        Intrinsics.checkParameterIsNotNull((Object)sapManager, (String)"sapManager");
        this.context = context;
        this.documentDraftExtractor = documentDraftExtractor;
        this.pageFactory = pageFactory;
        this.documentProcessor = documentProcessor;
        this.pageFileStorage = pageFileStorage;
        this.cleaner = cleaner;
        this.sapManager = sapManager;
    }
}

