/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.utils;

import android.animation.Animator;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewTreeObserver;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J \u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J \u0010#\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0007J\u000e\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010-\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/scanbot/sdk/utils/ViewUtils;", "", "()V", "ALPHA", "", "ALPHA_DEFAULT", "", "getALPHA_DEFAULT", "()F", "ALPHA_TRANSPARENT", "getALPHA_TRANSPARENT", "DISABLED_ACTIONMODE_CALLBACK", "Landroid/view/ActionMode$Callback;", "getDISABLED_ACTIONMODE_CALLBACK", "()Landroid/view/ActionMode$Callback;", "setDISABLED_ACTIONMODE_CALLBACK", "(Landroid/view/ActionMode$Callback;)V", "ROTATION", "SCALE_DEFAULT", "getSCALE_DEFAULT", "SCALE_X", "SCALE_Y", "TRANSLATION_DEFAULT", "getTRANSLATION_DEFAULT", "TRANSLATION_X", "TRANSLATION_Y", "fitBitmapToView", "bitmap", "Landroid/graphics/Bitmap;", "view", "Landroid/view/View;", "rotation", "fitDrawableToView", "drawable", "Landroid/graphics/drawable/Drawable;", "fitRectToView", "imageBounds", "Landroid/graphics/RectF;", "getViewBounds", "Landroid/graphics/Rect;", "postOnPreDraw", "", "runnable", "Ljava/lang/Runnable;", "restoreViewTransformation", "saveViewTransformation", "DefaultAnimationListener", "HardwareLayerAnimationListener", "sdk-bundle_release"})
public final class ViewUtils {
    private static final float ALPHA_DEFAULT = 1.0f;
    private static final float ALPHA_TRANSPARENT = 0.0f;
    private static final float SCALE_DEFAULT = 1.0f;
    private static final float TRANSLATION_DEFAULT = 0.0f;
    private static final int TRANSLATION_X = 0;
    private static final int TRANSLATION_Y = 1;
    private static final int SCALE_X = 2;
    private static final int SCALE_Y = 3;
    private static final int ROTATION = 4;
    private static final int ALPHA = 5;
    @NotNull
    private static ActionMode.Callback DISABLED_ACTIONMODE_CALLBACK;
    public static final ViewUtils INSTANCE;

    public final float getALPHA_DEFAULT() {
        return ALPHA_DEFAULT;
    }

    public final float getALPHA_TRANSPARENT() {
        return ALPHA_TRANSPARENT;
    }

    public final float getSCALE_DEFAULT() {
        return SCALE_DEFAULT;
    }

    public final float getTRANSLATION_DEFAULT() {
        return TRANSLATION_DEFAULT;
    }

    @NotNull
    public final ActionMode.Callback getDISABLED_ACTIONMODE_CALLBACK() {
        return DISABLED_ACTIONMODE_CALLBACK;
    }

    public final void setDISABLED_ACTIONMODE_CALLBACK(@NotNull ActionMode.Callback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"<set-?>");
        DISABLED_ACTIONMODE_CALLBACK = callback;
    }

    public final void saveViewTransformation(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        float[] values = new float[6];
        values[ViewUtils.TRANSLATION_X] = view.getTranslationX();
        values[ViewUtils.TRANSLATION_Y] = view.getTranslationY();
        values[ViewUtils.SCALE_X] = view.getScaleX();
        values[ViewUtils.SCALE_Y] = view.getScaleY();
        values[ViewUtils.ROTATION] = view.getRotation();
        values[ViewUtils.ALPHA] = view.getAlpha();
        view.setTag((Object)values);
    }

    public final void restoreViewTransformation(@NotNull View view) throws IllegalStateException {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = view.getTag();
        if (object == null) {
            return;
        }
        Object object2 = object;
        if (!(object instanceof float[])) {
            object2 = null;
        }
        float[] fArray = (float[])object2;
        if (fArray == null) {
            throw (Throwable)new IllegalStateException();
        }
        float[] tag = fArray;
        view.setTranslationX(tag[TRANSLATION_X]);
        view.setTranslationY(tag[TRANSLATION_Y]);
        view.setScaleX(tag[SCALE_X]);
        view.setScaleY(tag[SCALE_Y]);
        view.setRotation(tag[ROTATION]);
        view.setAlpha(tag[ALPHA]);
    }

    public final void postOnPreDraw(@NotNull View view, @NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(runnable, view){
            final /* synthetic */ Runnable $runnable;
            final /* synthetic */ View $view;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onPreDraw() {
                try {
                    this.$runnable.run();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.$view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
            }
            {
                this.$runnable = $captured_local_variable$0;
                this.$view = $captured_local_variable$1;
            }
        });
    }

    @NotNull
    public final Rect getViewBounds(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Rect bounds = new Rect();
        view.getGlobalVisibleRect(bounds);
        return bounds;
    }

    public final float fitBitmapToView(@Nullable Bitmap bitmap, @NotNull View view, float rotation) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (bitmap == null) {
            return SCALE_DEFAULT;
        }
        RectF imageBounds = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        return ViewUtils.fitRectToView(view, rotation, imageBounds);
    }

    public final float fitDrawableToView(@Nullable Drawable drawable, @NotNull View view, float rotation) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (drawable == null) {
            return SCALE_DEFAULT;
        }
        RectF drawableBounds = new RectF(0.0f, 0.0f, (float)drawable.getIntrinsicWidth(), (float)drawable.getIntrinsicHeight());
        return ViewUtils.fitRectToView(view, rotation, drawableBounds);
    }

    @JvmStatic
    public static final float fitRectToView(@NotNull View view, float rotation, @NotNull RectF imageBounds) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)imageBounds, (String)"imageBounds");
        RectF viewBounds = new RectF(0.0f, 0.0f, (float)(view.getWidth() - view.getPaddingLeft() - view.getPaddingRight()), (float)(view.getHeight() - view.getPaddingBottom() - view.getPaddingTop()));
        Matrix matrix = new Matrix();
        matrix.setRotate(rotation, imageBounds.centerX(), imageBounds.centerY());
        matrix.mapRect(imageBounds);
        matrix.reset();
        matrix.setRectToRect(imageBounds, viewBounds, Matrix.ScaleToFit.FILL);
        float[] m = new float[9];
        matrix.getValues(m);
        return Math.min(m[0], m[4]);
    }

    private ViewUtils() {
    }

    static {
        ViewUtils viewUtils;
        INSTANCE = viewUtils = new ViewUtils();
        ALPHA_DEFAULT = 1.0f;
        SCALE_DEFAULT = 1.0f;
        TRANSLATION_Y = 1;
        SCALE_X = 2;
        SCALE_Y = 3;
        ROTATION = 4;
        ALPHA = 5;
        DISABLED_ACTIONMODE_CALLBACK = new ActionMode.Callback(){

            public boolean onPrepareActionMode(@NotNull ActionMode mode, @NotNull Menu menu) {
                Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
                Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
                return false;
            }

            public void onDestroyActionMode(@NotNull ActionMode mode) {
                Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
            }

            public boolean onCreateActionMode(@NotNull ActionMode mode, @NotNull Menu menu) {
                Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
                Intrinsics.checkParameterIsNotNull((Object)menu, (String)"menu");
                return false;
            }

            public boolean onActionItemClicked(@NotNull ActionMode mode, @NotNull MenuItem item) {
                Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return false;
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/utils/ViewUtils$DefaultAnimationListener;", "Landroid/animation/Animator$AnimatorListener;", "()V", "ended", "", "onAnimationCancel", "", "animator", "Landroid/animation/Animator;", "onAnimationEnd", "onAnimationFinished", "onAnimationRepeat", "onAnimationStart", "sdk-bundle_release"})
    public static class DefaultAnimationListener
    implements Animator.AnimatorListener {
        private boolean ended;

        public void onAnimationStart(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
            this.ended = false;
        }

        public void onAnimationEnd(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
            if (this.ended) {
                return;
            }
            this.onAnimationFinished(animator);
            this.ended = true;
        }

        public void onAnimationFinished(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        }

        public void onAnimationCancel(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        }

        public void onAnimationRepeat(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/utils/ViewUtils$HardwareLayerAnimationListener;", "Lio/scanbot/sdk/utils/ViewUtils$DefaultAnimationListener;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "layerType", "", "onAnimationFinished", "", "animator", "Landroid/animation/Animator;", "onAnimationStart", "sdk-bundle_release"})
    public static final class HardwareLayerAnimationListener
    extends DefaultAnimationListener {
        private final int layerType;
        private final View view;

        @Override
        public void onAnimationStart(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
            this.view.setLayerType(2, null);
        }

        @Override
        public void onAnimationFinished(@NotNull Animator animator) {
            Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
            this.view.setLayerType(this.layerType, null);
        }

        public HardwareLayerAnimationListener(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.layerType = this.view.getLayerType();
        }
    }
}

