/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.sap.SapManager;
import net.doo.snap.injection.ScanbotSdkModule;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.DebugLog;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.log.StubLogger;

@Deprecated
public class ScanbotSDKInitializer {
    protected static boolean initialized = false;
    protected boolean useLog = false;
    protected Logger logger;

    public ScanbotSDKInitializer withLogging(boolean useLog) {
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        this.useLog = useLog;
        if (!useLog) {
            this.logger = new StubLogger();
        }
        return this;
    }

    public ScanbotSDKInitializer license(Application application, String license) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)application);
        preferences.edit().putString("SCANBOT_SDK_LICENSE_KEY", license).apply();
        return this;
    }

    public ScanbotSDKInitializer ocrBlobsPath(Application application, String ocrBlobsPath) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)application);
        preferences.edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", ocrBlobsPath).apply();
        return this;
    }

    public void initialize(Application application) {
        LoggerProvider.setLogger((Logger)(this.logger == null ? (this.useLog ? new DebugLog((Context)application) : new StubLogger()) : this.logger));
        SapSingleton.initializeSapManager((Context)application);
        SapManager sapManager = SapSingleton.getInstance();
        boolean licenseValid = sapManager.isLicenseActive();
        String message = "ScanbotSDK license is " + (licenseValid ? "valid." : "not valid or expired.");
        LoggerProvider.getLogger().i("ScanbotSDKInitializer", message);
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public ScanbotSDKInitializer documentDraftExtractor(DocumentDraftExtractor extractor) {
        ScanbotSdkModule.documentDraftExtractor = extractor;
        return this;
    }

    public ScanbotSDKInitializer unreferencedSourcesProvider(UnreferencedSourcesProvider provider) {
        ScanbotSdkModule.unreferencedSourcesProvider = provider;
        return this;
    }

    public ScanbotSDKInitializer logger(Logger logger) {
        this.logger = logger;
        return this;
    }
}

