/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.graphics.PointF;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.CameraStateCallback;
import net.doo.snap.camera.CameraTakePictureCallback;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.sensor.SignificantMoveCatcher;
import net.doo.snap.camera.sensor.SignificantMoveListener;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private static final int DELAY_AFTER_MOVE_MS = 2000;
    private static final int OK_DETECTIONS_COUNT_FOR_AUTOSNAP = 3;
    private static final double OK_DETECTIONS_THRESHOLD = 0.05;
    protected final ScanbotCameraView cameraView;
    protected final SignificantMoveCatcher significantMoveCatcher;
    protected final SignificantMoveListener significantMoveListener;
    private long lastSignificantMove = 0L;
    protected final AtomicLong captureInterval = new AtomicLong(1000L);
    protected final Logger logger = LoggerProvider.getLogger();
    protected long lastCapture = 0L;
    protected AtomicBoolean capturing = new AtomicBoolean(false);
    protected boolean ignoreBadAspectRatio = false;
    protected final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isAutoSnapEnabled = true;
    private AtomicBoolean isAutosnappingShooting = new AtomicBoolean(false);
    private AutoSnappingCallback autoSnappingCallback = AutoSnappingCallback.NULL;
    private final Runnable autosnappingShoot = new Runnable(){

        @Override
        public void run() {
            boolean movedRecently;
            boolean bl = movedRecently = SystemClock.elapsedRealtime() - AutoSnappingController.this.lastSignificantMove <= 2000L;
            if (AutoSnappingController.this.isAutoSnapEnabled && !movedRecently) {
                if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                    if (Build.VERSION.SDK_INT >= 24) {
                        AutoSnappingController.this.cameraView.takePicture(false);
                    } else {
                        AutoSnappingController.this.cameraView.takePicture(true);
                    }
                }
            } else {
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    };
    private List<PointF> lastDetectedPolygon;
    private AtomicInteger okDetectionCounter = new AtomicInteger(0);

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler frameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        return AutoSnappingController.attach(cameraView, frameHandler);
    }

    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler2) {
        return new AutoSnappingController(cameraView, contourDetectorFrameHandler2);
    }

    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler2) {
        this(cameraView, (PreviewBuffer.FrameHandler)contourDetectorFrameHandler2);
        contourDetectorFrameHandler2.addResultHandler(new DetectionHandler());
    }

    protected AutoSnappingController(ScanbotCameraView cameraView, PreviewBuffer.FrameHandler frameHandler) {
        this.cameraView = cameraView;
        this.significantMoveCatcher = new SignificantMoveCatcher(cameraView.getContext().getApplicationContext());
        this.significantMoveListener = new SignificantMoveListenerImpl();
        cameraView.getPreviewBuffer().addFrameHandler(frameHandler);
        cameraView.addPictureCallback((PictureCallback)new PictureCallbackImpl());
        cameraView.addCameraStateCallback((CameraStateCallback)new CameraStateCallbackImpl());
        cameraView.addTakePictureCallback((CameraTakePictureCallback)new CameraTakePictureCallbackImpl());
    }

    protected void onDetectionOK(List<PointF> polygon) {
        if (!this.isAutosnappingShooting.get()) {
            this.checkDetectedPolygonAndSnap(polygon);
        }
    }

    private void checkDetectedPolygonAndSnap(List<PointF> polygon) {
        if (polygon == null || polygon.isEmpty() || this.okDetectionCounter.get() >= 3) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.post(this.autosnappingShoot);
            this.okDetectionCounter.set(0);
            this.lastDetectedPolygon = null;
        } else if (this.lastDetectedPolygon == null) {
            this.lastDetectedPolygon = polygon;
        } else if (this.polygonsAreClose(this.lastDetectedPolygon, polygon)) {
            this.okDetectionCounter.incrementAndGet();
        } else {
            this.okDetectionCounter.set(0);
            this.lastDetectedPolygon = polygon;
        }
    }

    private boolean polygonsAreClose(List<PointF> lastDetectedPolygon, List<PointF> polygon) {
        return (double)Math.abs(lastDetectedPolygon.get((int)0).x - polygon.get((int)0).x) < 0.05 && (double)Math.abs(lastDetectedPolygon.get((int)0).y - polygon.get((int)0).y) < 0.05 && (double)Math.abs(lastDetectedPolygon.get((int)2).x - polygon.get((int)2).x) < 0.05 && (double)Math.abs(lastDetectedPolygon.get((int)2).y - polygon.get((int)2).y) < 0.05;
    }

    public void setEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float sensitivity) {
        this.logger.logMethod();
        float threshold = 1.0f - this.clamp(sensitivity);
        this.captureInterval.set((long)(threshold * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = ignoreBadAspectRatio;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        this.logger.logMethod();
        this.autoSnappingCallback = callback != null ? callback : AutoSnappingCallback.NULL;
    }

    private class CameraTakePictureCallbackImpl
    implements CameraTakePictureCallback {
        private CameraTakePictureCallbackImpl() {
        }

        public void onTakePictureRequested() {
        }

        public void onTakePictureCancelled() {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    protected class SignificantMoveListenerImpl
    implements SignificantMoveListener {
        protected SignificantMoveListenerImpl() {
        }

        @Override
        public float getSignificantMoveThreshold() {
            return 0.6f;
        }

        @Override
        public void onSignificantMove() {
            AutoSnappingController.this.lastSignificantMove = SystemClock.elapsedRealtime();
            if (AutoSnappingController.this.capturing.get() && AutoSnappingController.this.isAutosnappingShooting.get()) {
                AutoSnappingController.this.cameraView.continuousFocus();
                AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    }

    private class CameraStateCallbackImpl
    implements CameraStateCallback {
        private CameraStateCallbackImpl() {
        }

        public void onResume() {
            AutoSnappingController.this.capturing.set(true);
            AutoSnappingController.this.significantMoveCatcher.registerSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
        }

        public void onPause() {
            AutoSnappingController.this.significantMoveCatcher.unregisterSignificantMoveListener(AutoSnappingController.this.significantMoveListener);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
            AutoSnappingController.this.capturing.set(false);
            AutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class PictureCallbackImpl
    implements PictureCallback {
        private PictureCallbackImpl() {
        }

        public void onPictureTaken(byte[] image, int imageOrientation) {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class DetectionHandler
    implements ContourDetectorFrameHandler.ResultHandler {
        private DetectionHandler() {
        }

        private void postDetectionOK(final List<PointF> polygon) {
            AutoSnappingController.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    AutoSnappingController.this.onDetectionOK(polygon);
                }
            });
        }

        public boolean handle(@NotNull FrameHandlerResult<? extends ContourDetectorFrameHandler.DetectedFrame, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                ContourDetectorFrameHandler.DetectedFrame detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)result).getValue();
                AutoSnappingController.this.logger.logMethod();
                if ((detectedFrame.detectionResult == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && detectedFrame.detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing.get() && SystemClock.elapsedRealtime() - AutoSnappingController.this.lastCapture > AutoSnappingController.this.captureInterval.get()) {
                    if (AutoSnappingController.this.lastCapture != 0L) {
                        this.postDetectionOK(detectedFrame.polygon);
                    }
                    AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                }
            }
            return false;
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

