/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.utils.PolygonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.R;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.detector.PageAspectRatio;
import net.doo.snap.security.SapSingleton;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    protected final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final int finderInnerThresholdPx;
    private final int finderOuterThresholdPx;
    protected boolean enabled = true;
    private List<PageAspectRatio> requiredPageAspectRatios = null;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler frameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        cameraView.getPreviewBuffer().addFrameHandler((PreviewBuffer.FrameHandler)frameHandler);
        return frameHandler;
    }

    public ContourDetectorFrameHandler(Context context) {
        this.contourDetector = new ContourDetector();
        this.sapManager = SapSingleton.getInstance();
        this.finderInnerThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_inner_threshold);
        this.finderOuterThresholdPx = context.getResources().getDimensionPixelSize(R.dimen.default_finder_outer_threshold);
    }

    public synchronized boolean handleFrame(PreviewBuffer.FrameHandler.Frame previewFrame) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.EdgeDetection).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError()));
            return false;
        }
        this.fixRequiredAspectRatios(previewFrame.frameOrientation);
        this.setRectOfInterest(previewFrame.frameOrientation, previewFrame.visibleRect);
        DetectionResult detectionResult = this.contourDetector.detect(previewFrame.frame, previewFrame.width, previewFrame.height);
        List polygon = this.contourDetector.getPolygonF();
        detectionResult = this.detectOffCenter(previewFrame, detectionResult, polygon);
        DetectedFrame detectedFrame = new DetectedFrame(detectionResult, polygon, previewFrame.frameOrientation, previewFrame.width, previewFrame.height, this.contourDetector.getDetectionScore(), previewFrame.finderRect, this.requiredPageAspectRatios);
        return this.notifyHandlers((FrameHandlerResult<DetectedFrame, SdkLicenseError>)new FrameHandlerResult.Success((Object)detectedFrame));
    }

    private DetectionResult detectOffCenter(PreviewBuffer.FrameHandler.Frame previewFrame, DetectionResult detectionResult, List<PointF> polygon) {
        if (!(previewFrame.finderRect == null || previewFrame.finderRect.isEmpty() || detectionResult != DetectionResult.OK && detectionResult != DetectionResult.OK_BUT_BAD_ASPECT_RATIO && detectionResult != DetectionResult.OK_BUT_TOO_SMALL && detectionResult != DetectionResult.OK_BUT_BAD_ANGLES)) {
            int frameHeight;
            List rotatedPolygon = PolygonHelper.rotatePolygon(polygon, (float)previewFrame.frameOrientation);
            boolean frameNotRotated = previewFrame.frameOrientation % 180 == 0;
            int frameWidth = frameNotRotated ? previewFrame.width : previewFrame.height;
            Rect polygonRect = new Rect((int)(((PointF)rotatedPolygon.get((int)0)).x * (float)frameWidth), (int)(((PointF)rotatedPolygon.get((int)0)).y * (float)(frameHeight = frameNotRotated ? previewFrame.height : previewFrame.width)), (int)(((PointF)rotatedPolygon.get((int)2)).x * (float)frameWidth), (int)(((PointF)rotatedPolygon.get((int)2)).y * (float)frameHeight));
            if (this.checkOuterThreshold(previewFrame.finderRect, polygonRect)) {
                detectionResult = DetectionResult.OK_OFF_CENTER;
            } else if (!this.requiredPageAspectRatios.isEmpty() && this.checkInnerThreshold(previewFrame.finderRect, polygonRect)) {
                detectionResult = DetectionResult.OK_BUT_TOO_SMALL;
            }
        }
        return detectionResult;
    }

    private boolean checkInnerThreshold(Rect finderRect, Rect polygonRect) {
        return polygonRect.left - finderRect.left > this.finderInnerThresholdPx || polygonRect.top - finderRect.top > this.finderInnerThresholdPx || finderRect.bottom - polygonRect.bottom > this.finderInnerThresholdPx || finderRect.right - polygonRect.right > this.finderInnerThresholdPx;
    }

    private boolean checkOuterThreshold(Rect finderRect, Rect polygonRect) {
        return finderRect.left - polygonRect.left > this.finderOuterThresholdPx || finderRect.top - polygonRect.top > this.finderOuterThresholdPx || polygonRect.bottom - finderRect.bottom > this.finderOuterThresholdPx || polygonRect.right - finderRect.right > this.finderOuterThresholdPx;
    }

    private void setRectOfInterest(int frameOrientation, RectF visibleRect) {
        if (visibleRect != null) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)frameOrientation, 0.5f, 0.5f);
            matrix.mapRect(visibleRect);
            this.contourDetector.setRectOfInterest(visibleRect);
        }
    }

    private void fixRequiredAspectRatios(int frameOrientation) {
        if (this.requiredPageAspectRatios != null && !this.requiredPageAspectRatios.isEmpty()) {
            ArrayList<PageAspectRatio> fixedAspectRatios = new ArrayList<PageAspectRatio>();
            for (PageAspectRatio requiredPageAspectRatio : this.requiredPageAspectRatios) {
                boolean frameNotRotated = frameOrientation % 180 == 0;
                PageAspectRatio fixedAspectRatio = frameNotRotated ? new PageAspectRatio(requiredPageAspectRatio.width, requiredPageAspectRatio.height) : new PageAspectRatio(requiredPageAspectRatio.height, requiredPageAspectRatio.width);
                fixedAspectRatios.add(fixedAspectRatio);
            }
            this.contourDetector.setRequiredAspectRatios(fixedAspectRatios);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        if (acceptedAngleScore < 0.0 || acceptedAngleScore > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
        }
        this.contourDetector.setAcceptedAngleScore(acceptedAngleScore);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        if (acceptedSizeScore < 0.0 || acceptedSizeScore > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
        }
        this.contourDetector.setAcceptedSizeScore(acceptedSizeScore);
    }

    public final void setRequiredAspectRatios(List<PageAspectRatio> requiredPageAspectRatios) {
        this.requiredPageAspectRatios = requiredPageAspectRatios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyHandlers(FrameHandlerResult<DetectedFrame, SdkLicenseError> result) {
        boolean handled = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
        }
        return handled;
    }

    public static class DetectedFrame {
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;
        public final Rect finderRect;
        public final List<PageAspectRatio> requiredPageAspectRatios;

        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = 0.0;
            this.finderRect = null;
            this.requiredPageAspectRatios = null;
        }

        public DetectedFrame(DetectionResult detectionResult, List<PointF> polygon, int frameOrientation, int frameWidth, int frameHeight, double detectionScore, Rect finderRect, List<PageAspectRatio> requiredPageAspectRatios) {
            this.detectionResult = detectionResult;
            this.frameOrientation = frameOrientation;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.polygon = Collections.unmodifiableList(polygon);
            this.detectionScore = detectionScore;
            this.finderRect = finderRect;
            this.requiredPageAspectRatios = requiredPageAspectRatios;
        }
    }

    public static interface ResultHandler
    extends BaseResultHandler<DetectedFrame, SdkLicenseError> {
    }
}

