/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.dcscanner;

import android.graphics.Bitmap;
import io.scanbot.dcscanner.DisabilityCertificateRecognizer;
import io.scanbot.dcscanner.model.DisabilityCertificateRecognizerResultInfo;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.dcscanner.DCScanner;

public class DefaultDCScanner
implements DCScanner {
    private final DisabilityCertificateRecognizer dcRecognizer;

    @Inject
    public DefaultDCScanner(BlobManager blobManager) {
        String dcTraineddataPath = null;
        String dcModelsFolderPath = null;
        try {
            dcTraineddataPath = blobManager.getOCRBlobsDirectory().getPath();
            dcModelsFolderPath = blobManager.getDcModelsFolderFile().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("DC blob is not available.");
        }
        this.dcRecognizer = new DisabilityCertificateRecognizer(dcTraineddataPath, dcModelsFolderPath);
    }

    @Override
    public DisabilityCertificateRecognizerResultInfo recognizeDC(byte[] nv21, int width, int height, int orientation) {
        return this.dcRecognizer.recognizeDC(nv21, width, height, orientation);
    }

    @Override
    public DisabilityCertificateRecognizerResultInfo recognizeDCBGR(byte[] bgr, int width, int height, int orientation) {
        return this.dcRecognizer.recognizeDCBGR(bgr, width, height, orientation);
    }

    @Override
    public DisabilityCertificateRecognizerResultInfo recognizeDCJPEG(byte[] image, int width, int height, int orientation) {
        return this.dcRecognizer.recognizeDCJPEG(image, width, height, orientation);
    }

    @Override
    public DisabilityCertificateRecognizerResultInfo recognizeDCBitmap(Bitmap image, int orientation) {
        return this.dcRecognizer.recognizeDCBitmap(image, orientation);
    }

    @Override
    public DisabilityCertificateRecognizerResultInfo detectAndRecognizeDCJPEG(byte[] image, int width, int height, int orientation) {
        return this.dcRecognizer.detectAndRecognizeDCJPEG(image, width, height, orientation);
    }

    @Override
    public DisabilityCertificateRecognizerResultInfo detectAndRecognizeDCBitmap(Bitmap image, int orientation) {
        return this.dcRecognizer.detectAndRecognizeDCBitmap(image, orientation);
    }
}

