/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.injection;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Resources;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import io.scanbot.multipleobjectsscanner.DefaultMultipleObjectsDetector;
import io.scanbot.multipleobjectsscanner.MultipleObjectsDetector;
import io.scanbot.multipleobjectsscanner.StubMultipleObjectsDetector;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.barcode.DefaultScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.StubScanbotBarcodeDetector;
import io.scanbot.sdk.businesscard.BusinessCardsImageProcessor;
import io.scanbot.sdk.businesscard.DefaultBusinessCardsImageProcessor;
import io.scanbot.sdk.businesscard.StubBusinessCardsImageProcessor;
import io.scanbot.sdk.filterpredictor.FilterPredictor;
import io.scanbot.sdk.filterpredictor.ScanbotFilterPredictor;
import io.scanbot.sdk.filterpredictor.StubFilterPredictor;
import io.scanbot.sdk.hicscanner.DefaultHealthInsuranceCardScanner;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import io.scanbot.sdk.hicscanner.StubHealthInsuranceCardScanner;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.ScanbotOpticalCharacterRecognizer;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.PDFRenderer;
import io.scanbot.sdk.process.PageProcessor;
import io.scanbot.sdk.process.ScanbotPDFRenderer;
import io.scanbot.sdk.textorientation.DefaultTextOrientationScanner;
import io.scanbot.sdk.textorientation.StubTextOrientationScanner;
import io.scanbot.sdk.textorientation.TextOrientationScanner;
import io.scanbot.tiffwriter.TIFFWriter;
import javax.inject.Singleton;
import net.doo.snap.blob.BlobFactory;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.chequescanner.ChequeScanner;
import net.doo.snap.chequescanner.DefaultChequeScanner;
import net.doo.snap.chequescanner.StubChequeScanner;
import net.doo.snap.connectivity.BlobsStorage;
import net.doo.snap.dcscanner.DCScanner;
import net.doo.snap.dcscanner.DefaultDCScanner;
import net.doo.snap.dcscanner.StubDCScanner;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.ImageProcessorBitmapBinarizer;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.OcrSettings;
import net.doo.snap.intelligence.StubLanguageProvider;
import net.doo.snap.intelligence.StubTextRecognition;
import net.doo.snap.intelligence.TextRecognizerFactory;
import net.doo.snap.intelligence.UserLanguageProvider;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.mrzscanner.DefaultMRZScanner;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.mrzscanner.StubMRZScanner;
import net.doo.snap.payformscanner.DefaultPayFormScanner;
import net.doo.snap.payformscanner.PayFormScanner;
import net.doo.snap.payformscanner.StubPayFormScanner;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageFactory;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.BaseUnreferencedSourcesProvider;
import net.doo.snap.persistence.cleanup.Cleaner;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.DocumentProcessor;
import net.doo.snap.process.DocumentProcessorMonitor;
import net.doo.snap.process.DocumentProcessorProvider;
import net.doo.snap.process.PageProcessorMonitor;
import net.doo.snap.process.ProcessingInfoProvider;
import net.doo.snap.process.ProcessorMonitor;
import net.doo.snap.process.StubProcessingInfoProvider;
import net.doo.snap.process.TextRecognition;
import net.doo.snap.process.compose.BaseComposerFactory;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.OcrComposer;
import net.doo.snap.process.compose.P2ComposerFactory;
import net.doo.snap.process.compose.PageComposerFactory;
import net.doo.snap.process.compose.PageComposerFactoryImpl;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.process.draft.CombinedDocumentDraftExtractor;
import net.doo.snap.process.draft.CompositeDraftExtractor;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.draft.MultipleDocumentsDraftExtractor;
import net.doo.snap.security.SapProvider;
import net.doo.snap.util.bitmap.BitmapLruCache;

@Module
public class ScanbotSdkModule {
    public static DocumentDraftExtractor documentDraftExtractor = null;
    public static UnreferencedSourcesProvider unreferencedSourcesProvider = null;
    public static OcrSettings ocrSettings = null;

    @Provides
    BarcodeFileStorage providesBarcodeFileStorage(Application application) {
        return new BarcodeFileStorage(application);
    }

    @Provides
    public BlobStoreStrategy providesBlobStoreStrategy(Application application, SharedPreferences preferences) {
        return new BlobStoreStrategy(application, preferences);
    }

    @Provides
    public BlobsStorage providesBlobsStorage(SharedPreferences preferences) {
        return new BlobsStorage(preferences);
    }

    @Provides
    public BlobFactory providesBlobFactory(BlobStoreStrategy blobStoreStrategy, BlobsStorage blobsStorage, AssetManager assetManager) {
        return new BlobFactory(blobStoreStrategy, blobsStorage, assetManager);
    }

    @Provides
    public BlobManager providesBlobManager(BlobStoreStrategy blobStoreStrategy, AssetManager assetManager, BlobFactory blobFactory) {
        return new BlobManager(blobStoreStrategy, assetManager, blobFactory);
    }

    @Provides
    public PageComposerFactory providesPageComposerFactory(ContourDetector contourDetector, PageStoreStrategy pageStoreStrategy, Resources resources) {
        return new PageComposerFactoryImpl(contourDetector, pageStoreStrategy, resources);
    }

    @Provides
    public ProcessorMonitor<Page> providesPageProcessorMonitor() {
        return new PageProcessorMonitor();
    }

    @Provides
    public ProcessorMonitor<Document> providesDocumentProcessorMonitor(DocumentStoreStrategy documentStoreStrategy) {
        return new DocumentProcessorMonitor(documentStoreStrategy);
    }

    @Provides
    public ProcessingInfoProvider providesProcessingInfoProvider() {
        return new StubProcessingInfoProvider();
    }

    @Provides
    public UnreferencedSourcesProvider providesUnreferencedSourcesProvider(PageStoreStrategy pageStoreStrategy) {
        return unreferencedSourcesProvider == null ? new BaseUnreferencedSourcesProvider(pageStoreStrategy) : unreferencedSourcesProvider;
    }

    @Provides
    public DocumentDraftExtractor providesDocumentDraftExtractor(CombinedDocumentDraftExtractor combinedDocumentDraftExtractor, MultipleDocumentsDraftExtractor multipleDocumentsDraftExtractor) {
        return documentDraftExtractor == null ? new CompositeDraftExtractor(combinedDocumentDraftExtractor, multipleDocumentsDraftExtractor) : documentDraftExtractor;
    }

    @Provides
    @Singleton
    public SapManager providesSapManager(Application application) {
        return new SapProvider(application).get();
    }

    @Provides
    public DocumentProcessor providesDocumentProcessor(SapManager sapManager, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, Resources resources, BitmapLruCache bitmapLruCache, ComposerFactory composerFactory, ProcessorMonitor<Document> documentProcessorMonitor, Cleaner cleaner) {
        return new DocumentProcessorProvider(sapManager, documentStoreStrategy, pageStoreStrategy, resources, bitmapLruCache, composerFactory, documentProcessorMonitor, cleaner).get();
    }

    @Provides
    @Singleton
    public BitmapLruCache provideBitmapLruCache(ActivityManager manager) {
        return new BitmapLruCache(manager);
    }

    @Provides
    public PageFactory providePageFactory(BitmapLruCache bitmapLruCache, PageStoreStrategy pageStoreStrategy) {
        return new PageFactory(bitmapLruCache, pageStoreStrategy);
    }

    @Provides
    public SimpleComposer provideSimpleComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy) {
        return new SimpleComposer(documentStoreStrategy, pageStoreStrategy);
    }

    @Provides
    public DocumentStoreStrategy provideDocumentStoreStrategy(Context context, SharedPreferences preferences) {
        return new DocumentStoreStrategy(context, preferences);
    }

    @Provides
    public PageStoreStrategy providePageStoreStrategy(Application application, SharedPreferences preferences) {
        return new PageStoreStrategy(application, preferences);
    }

    @Provides
    public OcrPdfRenderer provideOcrPdfRenderer(Context context, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, BlobStoreStrategy blobStoreStrategy, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        return new OcrPdfRenderer(context, documentStoreStrategy, pageStoreStrategy, blobStoreStrategy, bitmapBinarizer);
    }

    @Provides
    public TextRecognizerFactory provideTextRecognizerFactory(SapManager sapManager, OcrPdfRenderer pdfRenderer, DocumentStoreStrategy documentStoreStrategy, SimpleComposer simpleComposer, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, OcrSettings ocrSettings, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        return new TextRecognizerFactory(sapManager, pdfRenderer, documentStoreStrategy, simpleComposer, blobStoreStrategy, pageStoreStrategy, ocrSettings, bitmapBinarizer);
    }

    @Provides
    public OcrComposer provideOcrComposer(DocumentStoreStrategy documentStoreStrategy, BlobManager blobManager, OcrPdfRenderer pdfRenderer, SimpleComposer simpleComposer, SapManager sapManager, OcrSettings ocrSettings) {
        return new OcrComposer(documentStoreStrategy, blobManager, pdfRenderer, simpleComposer, sapManager, ocrSettings);
    }

    @Provides
    public ContourDetector providesContourDetector() {
        return new ContourDetector();
    }

    @Provides
    @Singleton
    public ScanbotBarcodeDetector scanbotBarcodeDetector(SapManager sapManager, BlobManager blobManager) {
        if (sapManager.checkLicenseStatusSilently(SdkFeature.Barcode)) {
            return new DefaultScanbotBarcodeDetector(blobManager);
        }
        return new StubScanbotBarcodeDetector(sapManager);
    }

    @Provides
    public TextRecognition providesTextRecognition(SapManager sapManager, Lazy<TextRecognizerFactory> textRecognizerFactory) {
        if (this.isP2() && sapManager.checkLicenseStatusSilently(SdkFeature.OCR)) {
            return (TextRecognition)textRecognizerFactory.get();
        }
        return new StubTextRecognition(sapManager);
    }

    @Provides
    public ComposerFactory providesComposerFactory(SapManager sapManager, Lazy<BaseComposerFactory> baseComposerFactory, Lazy<P2ComposerFactory> p2ComposerFactory) {
        if (this.isP2() && sapManager.checkLicenseStatusSilently(SdkFeature.OCR)) {
            return (ComposerFactory)p2ComposerFactory.get();
        }
        return (ComposerFactory)baseComposerFactory.get();
    }

    @Provides
    public PDFRenderer pdfRenderer(Context context, DocumentDraftExtractor documentDraftExtractor, PageFactory pageFactory, DocumentProcessor documentProcessor, PageFileStorage pageFileStorage, Cleaner cleaner, SapManager sapManager) {
        return new ScanbotPDFRenderer(context, documentDraftExtractor, pageFactory, documentProcessor, pageFileStorage, cleaner, sapManager);
    }

    @Provides
    @Singleton
    public OcrSettings provideOcrSettings() {
        return ocrSettings != null ? ocrSettings : new OcrSettings.Builder().build();
    }

    @Provides
    OcrPdfRenderer.BitmapBinarizer providesBitmapBinarizer(ImageProcessorBitmapBinarizer bitmapBinarizer) {
        return bitmapBinarizer;
    }

    @Provides
    public OpticalCharacterRecognizer ocrRecogniser(SapManager sapManager, TextRecognition textRecognition, PageFactory pageFactory, BlobManager blobManager, PageFileStorage pageFileStorage) {
        if (this.isP2() && sapManager.checkLicenseStatusSilently(SdkFeature.OCR)) {
            return new ScanbotOpticalCharacterRecognizer(textRecognition, pageFactory, blobManager, pageFileStorage);
        }
        return new ScanbotOpticalCharacterRecognizer(new StubTextRecognition(sapManager), pageFactory, blobManager, pageFileStorage);
    }

    @Provides
    public LanguageProvider providesLanguageProvider(SapManager sapManager, Lazy<UserLanguageProvider> provider) {
        if (this.isP2() && sapManager.checkLicenseStatusSilently(SdkFeature.OCR)) {
            return (LanguageProvider)provider.get();
        }
        return new StubLanguageProvider();
    }

    @Provides
    @Singleton
    public TextOrientationScanner textOrientationRecognizer(SapManager sapManager, BlobManager blobManager) {
        if (this.isP2() && sapManager.checkLicenseStatusSilently(SdkFeature.TextOrientationDetection)) {
            return new DefaultTextOrientationScanner(blobManager);
        }
        return new StubTextOrientationScanner(sapManager);
    }

    @Provides
    @Singleton
    public PayFormScanner providesPayFormScanner(SapManager sapManager, BlobManager blobManager) {
        if (this.isP3() && sapManager.checkLicenseStatusSilently(SdkFeature.PayformDetection)) {
            return new DefaultPayFormScanner(blobManager);
        }
        return new StubPayFormScanner(sapManager);
    }

    @Provides
    @Singleton
    public MRZScanner providesMRZScanner(SapManager sapManager, BlobManager blobManager) {
        if (this.isP3() && sapManager.checkLicenseStatusSilently(SdkFeature.MRZRecognition)) {
            return new DefaultMRZScanner(blobManager);
        }
        return new StubMRZScanner(sapManager);
    }

    @Provides
    @Singleton
    public HealthInsuranceCardScanner providesHICScanner(SapManager sapManager, BlobManager blobManager) {
        if (this.isP3() && sapManager.checkLicenseStatusSilently(SdkFeature.EHICRecognition)) {
            return new DefaultHealthInsuranceCardScanner(blobManager);
        }
        return new StubHealthInsuranceCardScanner(sapManager);
    }

    @Provides
    @Singleton
    public DCScanner providesDCScanner(SapManager sapManager, BlobManager blobManager) {
        if (this.isP4() && sapManager.checkLicenseStatusSilently(SdkFeature.DisabilityCertRecognition)) {
            return new DefaultDCScanner(blobManager);
        }
        return new StubDCScanner(sapManager);
    }

    @Provides
    @Singleton
    public ChequeScanner providesChequeScanner(SapManager sapManager, BlobManager blobManager) {
        if (this.isP4() && sapManager.checkLicenseStatusSilently(SdkFeature.Cheque)) {
            return new DefaultChequeScanner(blobManager);
        }
        return new StubChequeScanner(sapManager);
    }

    @Provides
    @Singleton
    public FilterPredictor providesFilterPredictor(SapManager sapManager, BlobManager blobManager) {
        if (this.isP4()) {
            return new ScanbotFilterPredictor(blobManager);
        }
        return new StubFilterPredictor();
    }

    @Provides
    public TIFFWriter providesTiffWriter() {
        return new TIFFWriter();
    }

    @Provides
    public PageProcessor providesPageProcessor(Context context, PageFileStorage pageFileStorage, ImageProcessor imageProcessor) {
        return new PageProcessor(context, pageFileStorage, imageProcessor);
    }

    @Provides
    @Singleton
    public ImageProcessor providesImageProcessor() {
        return new ImageProcessor();
    }

    @Provides
    @Singleton
    public MultipleObjectsDetector providesMultipleObjectsDetector(SapManager sapManager) {
        if (this.isP4() && sapManager.checkLicenseStatusSilently(SdkFeature.MultipleObjectsDetection)) {
            return new DefaultMultipleObjectsDetector();
        }
        return new StubMultipleObjectsDetector();
    }

    @Provides
    @Singleton
    public BusinessCardsImageProcessor providesBusinessCardsProcessor(OpticalCharacterRecognizer opticalCharacterRecognizer, PageFileStorage pageFileStorage, PageProcessor pageProcessor, TextOrientationScanner textOrientationScanner) {
        if (this.isP4()) {
            return new DefaultBusinessCardsImageProcessor(opticalCharacterRecognizer, pageFileStorage, pageProcessor, textOrientationScanner);
        }
        return new StubBusinessCardsImageProcessor();
    }

    private boolean isP2() {
        try {
            Class.forName("net.doo.snap.P2Module");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isP3() {
        try {
            Class.forName("net.doo.snap.P3Module");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isP4() {
        try {
            Class.forName("net.doo.snap.P4Module");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

