/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.inject.Inject;
import net.doo.snap.entity.Language;
import net.doo.snap.intelligence.LanguageProvider;
import net.doo.snap.intelligence.source.KeyboardLanguageSource;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.jetbrains.annotations.NotNull;

public class UserLanguageProvider
implements LanguageProvider {
    private final Logger logger = LoggerProvider.getLogger();
    private final ArrayList<LanguageSource> sources = new ArrayList();

    @Inject
    public UserLanguageProvider(Context context) {
        this.sources.add(new KeyboardLanguageSource(context));
        this.sources.add(new DefaultLanguageSource());
    }

    public UserLanguageProvider(LanguageSource[] sources) {
        this.sources.addAll(Arrays.asList(sources));
    }

    @Override
    @NotNull
    public Language getMostCommonLanguage() {
        Language language = null;
        try {
            language = Language.languageByIso((String)Locale.getDefault().getISO3Language());
        }
        catch (MissingResourceException e) {
            this.logger.logException((Throwable)e);
        }
        return language != null ? language : Language.ENG;
    }

    private class DefaultLanguageSource
    implements LanguageSource {
        private DefaultLanguageSource() {
        }

        @Override
        public Collection<Language> getLanguages() {
            HashSet<Language> languages = new HashSet<Language>();
            languages.add(Language.ENG);
            languages.add(UserLanguageProvider.this.getMostCommonLanguage());
            try {
                Language language = Language.languageByIso((String)Locale.getDefault().getISO3Language());
                if (language != null) {
                    languages.add(language);
                }
            }
            catch (MissingResourceException e) {
                UserLanguageProvider.this.logger.logException((Throwable)e);
            }
            return languages;
        }
    }

    public static interface LanguageSource {
        public Collection<Language> getLanguages();
    }
}

