/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.mrzscanner.MRZRecognizer;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.mrzscanner.MRZScanner;

public class DefaultMRZScanner
implements MRZScanner {
    private final MRZRecognizer mrzRecognizer;

    @Inject
    public DefaultMRZScanner(BlobManager blobManager) {
        String mrzTraineddataPath = null;
        try {
            mrzTraineddataPath = blobManager.getOCRBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("MRZ blob is not available.");
        }
        String cascadeFilePath = null;
        try {
            cascadeFilePath = blobManager.getMRZCascadeFile().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("MRZ cascade file blob is not available.");
        }
        this.mrzRecognizer = new MRZRecognizer(mrzTraineddataPath, cascadeFilePath);
    }

    @Override
    public MRZRecognitionResult recognizeMRZ(byte[] nv21, int width, int height, int orientation) {
        return this.mrzRecognizer.recognizeMRZ(nv21, width, height, orientation);
    }

    @Override
    public MRZRecognitionResult recognizeMRZBGR(byte[] bgr, int width, int height, int orientation) {
        return this.mrzRecognizer.recognizeMRZBGR(bgr, width, height, orientation);
    }

    @Override
    public MRZRecognitionResult recognizeMRZJPEG(byte[] image, int width, int height, int orientation) {
        return this.mrzRecognizer.recognizeMRZJPEG(image, width, height, orientation);
    }

    @Override
    public MRZRecognitionResult recognizeMRZJPEGWithFinderOverlay(byte[] image, int width, int height, int orientation, Rect finderRect, boolean detectMRZ) {
        return this.mrzRecognizer.recognizeMRZInAreaJPEG(image, width, height, orientation, finderRect, detectMRZ);
    }

    @Override
    public MRZRecognitionResult recognizeMRZBitmap(Bitmap bitmap, int orientation) {
        return this.mrzRecognizer.recognizeMRZBitmap(bitmap, orientation);
    }

    @Override
    public MRZRecognitionResult recognizeMRZWithFinderOverlay(byte[] nv21, int width, int height, int orientation, Rect finderRect, boolean detectMRZ) {
        return this.mrzRecognizer.recognizeInAreaNV21(nv21, width, height, orientation, finderRect, detectMRZ);
    }
}

